/*
 * Decompiled with CFR 0.152.
 */
package org.quickapi.framework.client;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.impl.client.HttpClientBuilder;
import org.quickapi.framework.client.Method;
import org.quickapi.framework.exception.FailException;
import org.quickapi.framework.exception.IllegalTemplateError;

public class Client {
    private static String prefix;
    private static int timeout;

    public static void setPrefix(String prefix) {
        Client.prefix = prefix;
    }

    public static void setTimeout(int timeout) {
        Client.timeout = timeout;
    }

    public static ClientBuilder get(String uri) {
        return new ClientBuilder(uri, Method.GET);
    }

    public static ClientBuilder post(String uri) {
        return new ClientBuilder(uri, Method.POST);
    }

    static {
        timeout = 3000;
    }

    public static class ClientBuilder {
        private final ObjectMapper mapper = new ObjectMapper();
        private final HttpClient client;
        private final String uri;
        private final Method method;
        private final Map<String, String> params = new HashMap<String, String>();
        private final Map<String, String> headers = new HashMap<String, String>();
        private final Map<String, String> cookies = new HashMap<String, String>();
        private byte[] requestBody;
        private byte[] responseBody;

        public ClientBuilder(String uri, Method method) {
            this.client = HttpClientBuilder.create().disableAutomaticRetries().setDefaultSocketConfig(SocketConfig.custom().setSoKeepAlive(true).setSoTimeout(timeout).setTcpNoDelay(true).build()).build();
            this.uri = uri.startsWith("http") ? uri : prefix + uri;
            this.method = method;
            this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        }

        public ClientBuilder param(String key, String value) {
            this.params.put(key, value);
            return this;
        }

        public ClientBuilder header(String key, String value) {
            this.headers.put(key, value);
            return this;
        }

        public ClientBuilder cookie(String key, String value) {
            this.cookies.put(key, value);
            return this;
        }

        public ClientBuilder json(Object src) throws IllegalTemplateError {
            if (src == null) {
                return this;
            }
            this.headers.put("Content-Type", "application/json");
            try {
                this.requestBody = this.mapper.writeValueAsBytes(src);
            }
            catch (JsonProcessingException e) {
                throw new IllegalTemplateError((Throwable)e);
            }
            return this;
        }

        public ClientBuilder plain(Map<String, Object> body) {
            this.headers.put("Content-Type", "text/plain");
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, Object> entry : body.entrySet()) {
                sb.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            this.requestBody = sb.toString().getBytes();
            return this;
        }

        public <T> T acceptJson(Class<T> type) throws IllegalTemplateError, FailException {
            this.header("Accept", "application/json");
            this.send();
            try {
                String temp = new String(this.responseBody, "utf-8");
                return (T)this.mapper.readValue(temp, type);
            }
            catch (IOException e) {
                throw new IllegalTemplateError((Throwable)e);
            }
        }

        public Map<String, String> acceptPlain() throws FailException, IllegalTemplateError {
            this.header("Accept", "text/plain");
            this.send();
            try {
                HashMap<String, String> result = new HashMap<String, String>();
                String resp = new String(this.responseBody, "utf-8");
                for (String entryLine : resp.split("&")) {
                    String[] data = entryLine.split("=");
                    result.put(data[0], data[1]);
                }
                return result;
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalTemplateError((Throwable)e);
            }
        }

        private void send() throws FailException {
            try (ByteArrayOutputStream out = new ByteArrayOutputStream();
                 InputStream in = this.client.execute((HttpUriRequest)this.getRequest()).getEntity().getContent();){
                byte[] buff = new byte[2048];
                while (in.read(buff) != -1) {
                    out.write(buff);
                }
                this.responseBody = out.toByteArray();
            }
            catch (IOException e) {
                throw new FailException(e);
            }
        }

        private HttpRequestBase getRequest() {
            HttpGet request;
            switch (this.method) {
                case GET: {
                    request = new HttpGet(this.getURL());
                    break;
                }
                case POST: {
                    request = new HttpPost(this.getURL());
                    ((HttpPost)request).setEntity((HttpEntity)new ByteArrayEntity(this.requestBody));
                    break;
                }
                default: {
                    throw new RuntimeException("UNKNOWN METHOD");
                }
            }
            for (Map.Entry<String, String> entry : this.headers.entrySet()) {
                request.setHeader(entry.getKey(), entry.getValue());
            }
            String cookies = this.getCookies();
            if (cookies != null) {
                request.setHeader("Cookie", cookies);
            }
            return request;
        }

        private String getURL() {
            StringBuilder sb = new StringBuilder(String.format("%s%s", this.uri, this.params.size() == 0 ? "" : "?"));
            for (Map.Entry<String, String> entry : this.params.entrySet()) {
                sb.append(entry.getKey()).append("=").append(entry.getValue()).append("&");
            }
            if (this.params.size() > 0) {
                sb.setLength(sb.length() - 1);
            }
            return sb.toString();
        }

        private String getCookies() {
            if (this.cookies.isEmpty()) {
                return null;
            }
            StringBuilder sb = new StringBuilder();
            for (Map.Entry<String, String> entry : this.cookies.entrySet()) {
                sb.append(entry.getKey()).append("=").append(entry.getValue()).append("; ");
            }
            sb.setLength(sb.length() - "; ".length());
            return sb.toString();
        }
    }
}

