/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.as.wildfly;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.jms.Queue;
import javax.jms.Topic;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Value;
import org.projectodd.wunderboss.as.ASDestinationManager;
import org.projectodd.wunderboss.as.ASUtils;
import org.projectodd.wunderboss.messaging.jms.JMSDestination;

public class WildFlyDestinationManager
extends ASDestinationManager {
    public WildFlyDestinationManager(ServiceTarget target, ServiceName hqServiceName) {
        super(target, hqServiceName);
    }

    @Override
    public Queue installQueueService(String name, String jndiName, String selector, boolean durable) throws Exception {
        Queue queue = (Queue)this.waitForValueAvailabilityChange((Value)this.installService(ASUtils.queueServiceClass(), name, this.target(), this.hqServiceName(), selector, durable, new String[]{jndiName}), false);
        if (queue == null) {
            this.throwTimeout("creation of queue " + name);
        }
        return queue;
    }

    @Override
    public Topic installTopicService(String name, String jndiName) throws Exception {
        Topic topic = (Topic)this.waitForValueAvailabilityChange((Value)this.installService(ASUtils.topicServiceClass(), name, this.hqServiceName(), this.target(), new String[]{jndiName}), false);
        if (topic == null) {
            this.throwTimeout("creation of topic " + name);
        }
        return topic;
    }

    @Override
    public void removeDestination(Value service, String name, String jndiName, JMSDestination.Type type) {
        if (this.waitForValueAvailabilityChange(service, true) != null) {
            this.throwTimeout("removal of " + type.name + " " + name);
        }
    }

    private Object waitForValueAvailabilityChange(Value value, boolean toNull) {
        Object v = value.getValue();
        long nap = 10L;
        for (long count = this.destinationServiceTimeout() / nap; (toNull ? v != null : v == null) && count > 0L; --count) {
            try {
                Thread.sleep(nap);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            v = value.getValue();
        }
        return v;
    }

    private Service installService(Class clazz, Object ... args) throws Exception {
        Method installer = null;
        for (Method m : clazz.getMethods()) {
            if (!"installService".equals(m.getName())) continue;
            installer = m;
            break;
        }
        if (installer == null) {
            throw new NullPointerException("Class " + clazz + " has no installService method");
        }
        if (installer.getParameterTypes().length == args.length) {
            return (Service)installer.invoke(null, args);
        }
        ArrayList<Object> extra = new ArrayList<Object>(Collections.nCopies(2, null));
        extra.addAll(Arrays.asList(args));
        return (Service)installer.invoke(null, extra.toArray());
    }
}

