/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.as.eap;

import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.Context;
import org.jboss.as.messaging.jms.JMSQueueAdd;
import org.jboss.as.messaging.jms.JMSTopicAdd;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Value;
import org.projectodd.wunderboss.as.ASDestinationManager;
import org.projectodd.wunderboss.as.ASUtils;
import org.projectodd.wunderboss.messaging.jms.JMSDestination;

public class EAPDestinationManager
extends ASDestinationManager {
    private final Context context;

    public EAPDestinationManager(ServiceTarget target, ServiceName hqServiceName, Context context) {
        super(target, hqServiceName);
        this.context = context;
    }

    @Override
    public Queue installQueueService(String name, String jndiName, String selector, boolean durable) throws Exception {
        JMSQueueAdd.INSTANCE.installServices(null, null, name, this.target(), this.hqServiceName(), selector, durable, new String[]{jndiName});
        Queue queue = (Queue)ASUtils.waitForAppearanceInJNDI(this.context, jndiName, this.destinationServiceTimeout());
        if (queue == null) {
            this.throwTimeout("creation of queue " + name);
        }
        return queue;
    }

    @Override
    public Topic installTopicService(String name, String jndiName) throws Exception {
        JMSTopicAdd.INSTANCE.installServices(null, null, name, this.hqServiceName(), this.target(), new String[]{jndiName});
        Topic topic = (Topic)ASUtils.waitForAppearanceInJNDI(this.context, jndiName, this.destinationServiceTimeout());
        if (topic == null) {
            this.throwTimeout("creation of topic " + name);
        }
        return topic;
    }

    @Override
    public void removeDestination(Value service, String name, String jndiName, JMSDestination.Type type) {
        if (!ASUtils.waitForRemovalFromJNDI(this.context, jndiName, this.destinationServiceTimeout())) {
            this.throwTimeout("removal of " + type.name + " " + name);
        }
    }
}

