/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.as;

import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.jboss.logging.Logger;
import org.projectodd.wunderboss.CompletableFuture;
import org.projectodd.wunderboss.Options;
import org.projectodd.wunderboss.as.ActionConduit;
import org.projectodd.wunderboss.web.Web;

public class ServletWeb
implements Web<Servlet> {
    private final String name;
    private final ServletContext servletContext;
    private final ActionConduit actionConduit;
    private final AtomicLong sharedTimeout;
    private static final String ORIGINAL_CONTEXT = "original-context";
    private static final Logger log = Logger.getLogger(ServletWeb.class);

    public ServletWeb(String name, ServletContext servletContext, ActionConduit actionConduit, AtomicLong sharedTimeout) {
        this.name = name;
        this.servletContext = servletContext;
        this.actionConduit = actionConduit;
        this.sharedTimeout = sharedTimeout;
    }

    public boolean registerHandler(Servlet handler, Map<Web.RegisterOption, Object> opts) {
        return this.registerServlet(handler, opts);
    }

    public boolean registerServlet(final Servlet servlet, Map<Web.RegisterOption, Object> opts) {
        CompletableFuture servletFuture;
        String mapping;
        Options options = new Options(opts);
        String context = options.getString((Object)Web.RegisterOption.PATH);
        final String servletName = options.getString((Object)Web.RegisterOption.SERVLET_NAME, context);
        Runnable action = new Runnable(mapping = context.endsWith("/") ? context + "*" : context + "/*", context, options, servletFuture = new CompletableFuture()){
            final /* synthetic */ String val$mapping;
            final /* synthetic */ String val$context;
            final /* synthetic */ Options val$options;
            final /* synthetic */ CompletableFuture val$servletFuture;
            {
                this.val$mapping = string2;
                this.val$context = string3;
                this.val$options = options;
                this.val$servletFuture = completableFuture;
            }

            @Override
            public void run() {
                try {
                    ServletRegistration.Dynamic servletRegistration = ServletWeb.this.servletContext.addServlet(servletName, servlet);
                    servletRegistration.addMapping(new String[]{this.val$mapping});
                    servletRegistration.setLoadOnStartup(1);
                    servletRegistration.setAsyncSupported(true);
                    servletRegistration.setInitParameter(ServletWeb.ORIGINAL_CONTEXT, this.val$context);
                    Map filterMap = (Map)this.val$options.get((Object)Web.RegisterOption.FILTER_MAP);
                    if (filterMap != null) {
                        for (Map.Entry entry : filterMap.entrySet()) {
                            FilterRegistration.Dynamic filter = ServletWeb.this.servletContext.addFilter((String)entry.getKey() + servletName, (Filter)entry.getValue());
                            filter.setAsyncSupported(true);
                            filter.addMappingForUrlPatterns(null, false, new String[]{this.val$mapping});
                        }
                    }
                    this.val$servletFuture.complete(null);
                }
                catch (Exception e) {
                    this.val$servletFuture.completeExceptionally((Throwable)e);
                }
            }
        };
        if (!this.actionConduit.add(action)) {
            throw new IllegalStateException("Can't add servlet after servlet init has completed");
        }
        try {
            long now = System.currentTimeMillis();
            servletFuture.get(this.sharedTimeout.get(), TimeUnit.MILLISECONDS);
            this.sharedTimeout.addAndGet(System.currentTimeMillis() - now);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            log.error((Object)"Registering servlet failed", (Throwable)e);
            throw new RuntimeException(e instanceof ExecutionException ? e.getCause() : e);
        }
        return false;
    }

    public boolean unregister(Map<Web.RegisterOption, Object> opts) {
        log.warn((Object)"Removing a servlet is a no-op in container.");
        return false;
    }

    public Set<String> registeredContexts() {
        HashSet<String> contexts = new HashSet<String>();
        for (ServletRegistration each : this.servletContext.getServletRegistrations().values()) {
            contexts.add(each.getInitParameter(ORIGINAL_CONTEXT));
        }
        return Collections.unmodifiableSet(contexts);
    }

    public void start() {
    }

    public void stop() {
    }

    public boolean isRunning() {
        return true;
    }

    public String name() {
        return this.name;
    }
}

