/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.as;

import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collections;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.annotation.WebListener;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.projectodd.wunderboss.ApplicationRunner;
import org.projectodd.wunderboss.CompletableFuture;
import org.projectodd.wunderboss.ComponentProvider;
import org.projectodd.wunderboss.WunderBoss;
import org.projectodd.wunderboss.as.ActionConduit;
import org.projectodd.wunderboss.as.MSCService;
import org.projectodd.wunderboss.as.ModuleUtils;
import org.projectodd.wunderboss.as.ServletWebProvider;
import org.projectodd.wunderboss.web.Web;

@WebListener
public class ServletListener
implements ServletContextListener {
    public static final String TIMEOUT_PROPERTY = "wunderboss.deployment.timeout";
    public static final long DEFAULT_TIMEOUT_SECONDS = 240L;
    private ApplicationRunner applicationRunner;
    private static final Logger log = Logger.getLogger((String)"org.projectodd.wunderboss.wildfly");

    public void contextInitialized(ServletContextEvent sce) {
        ServletContext sc = sce.getServletContext();
        WunderBoss.putOption((String)"servlet-context-path", (Object)sc.getContextPath());
        ActionConduit addServletActions = new ActionConduit();
        final CompletableFuture initDone = new CompletableFuture();
        long totalTimeout = 240L;
        String timeoutProp = System.getProperty(TIMEOUT_PROPERTY);
        if (timeoutProp != null) {
            totalTimeout = Long.parseLong(timeoutProp);
        }
        AtomicLong sharedTimeout = new AtomicLong(totalTimeout * 1000L);
        try {
            WunderBoss.registerComponentProvider(Web.class, (ComponentProvider)new ServletWebProvider(sc, addServletActions, sharedTimeout));
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        this.applicationRunner = new ApplicationRunner(this.getName(sc)){

            protected void updateClassPath() throws Exception {
                super.updateClassPath();
                ModuleUtils.addToModuleClasspath(Module.forClass(MSCService.class), this.classPathAdditions);
            }

            protected URL jarURL() {
                String mainPath = ApplicationRunner.class.getName().replace(".", "/") + ".class";
                String mainUrl = ApplicationRunner.class.getClassLoader().getResource(mainPath).toString();
                String marker = ".jar";
                int to = mainUrl.lastIndexOf(marker);
                try {
                    return new URL(mainUrl.substring(0, to + marker.length()));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Error determining jar url", e);
                }
            }

            public void start(String[] args) {
                try {
                    super.start(args);
                    initDone.complete(null);
                }
                catch (Exception e) {
                    initDone.completeExceptionally((Throwable)e);
                }
            }
        };
        WunderBoss.workerPool().submit(new Runnable(){

            @Override
            public void run() {
                try {
                    ServletListener.this.applicationRunner.start(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        while (sharedTimeout.get() > 0L && !initDone.isDone()) {
            Runnable action = addServletActions.poll();
            if (action != null) {
                action.run();
                continue;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException("Interrupted while waiting for application initialization to complete", e);
            }
            sharedTimeout.addAndGet(-10L);
        }
        if (sharedTimeout.get() <= 0L) {
            throw new RuntimeException(String.format("Timed out waiting for initialization to complete after %d seconds. If you need more time, use the %s sysprop.", totalTimeout, TIMEOUT_PROPERTY));
        }
        addServletActions.close();
        try {
            initDone.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Application initialization failed", e.getCause());
        }
        catch (InterruptedException | CancellationException e) {
            throw new RuntimeException("Application initialization was cancelled", e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        log.debug((Object)"Stopping WunderBoss application");
        try {
            WunderBoss.shutdownAndReset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.applicationRunner != null) {
                this.applicationRunner.stop();
                this.applicationRunner = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            for (Driver driver : Collections.list(DriverManager.getDrivers())) {
                DriverManager.deregisterDriver(driver);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private String getName(ServletContext sc) {
        String result = sc.getServletContextName();
        if (result == null && "".equals(result = sc.getContextPath())) {
            result = "/";
        }
        return result;
    }
}

