/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.as;

import java.lang.reflect.Method;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jgroups.JChannel;
import org.jgroups.protocols.CENTRAL_LOCK;
import org.jgroups.stack.Protocol;
import org.projectodd.wunderboss.WunderBoss;

public class ClusterUtils {
    private static final String[] CHANNEL_FACTORY_CLASS_NAMES = new String[]{"org.jboss.as.clustering.jgroups.ChannelFactory", "org.wildfly.clustering.jgroups.ChannelFactory"};
    private static final ServiceName[] JGROUPS_FACTORY_NAMES = new ServiceName[]{ServiceName.parse((String)"jboss.jgroups.stack"), ServiceName.parse((String)"jboss.jgroups.factory.default-stack"), ServiceName.parse((String)"jboss.jgroups.factory.default")};

    public static boolean inCluster() {
        return ClusterUtils.channelFactory() != null;
    }

    public static JChannel lockableChannel(String id) throws Exception {
        Class<?> channelInterface = null;
        ClassNotFoundException failure = null;
        for (String each : CHANNEL_FACTORY_CLASS_NAMES) {
            try {
                channelInterface = Class.forName(each);
                if (channelInterface == null) continue;
                break;
            }
            catch (ClassNotFoundException e) {
                failure = e;
            }
        }
        if (channelInterface == null) {
            throw new RuntimeException("Failed to find the ChannelFactory interface", failure);
        }
        Method createChannel = channelInterface.getDeclaredMethod("createChannel", String.class);
        JChannel chan = (JChannel)createChannel.invoke(ClusterUtils.channelFactory(), id);
        CENTRAL_LOCK l = new CENTRAL_LOCK();
        l.setNumberOfBackups(1);
        chan.getProtocolStack().addProtocol((Protocol)l);
        l.init();
        return chan;
    }

    public static Object channelFactory() {
        ServiceRegistry registry = (ServiceRegistry)WunderBoss.options().get((Object)"service-registry");
        ServiceController serviceController = null;
        if (registry != null) {
            ServiceName each;
            ServiceName[] serviceNameArray = JGROUPS_FACTORY_NAMES;
            int n = serviceNameArray.length;
            for (int i = 0; i < n && (serviceController = registry.getService(each = serviceNameArray[i])) == null; ++i) {
            }
        }
        return serviceController == null ? null : serviceController.getValue();
    }
}

