/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.as;

import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.jboss.logging.Logger;
import org.jboss.msc.service.ServiceName;

public class ASUtils {
    private static final String WF10_MESSAGING_PREFIX = "org.wildfly.extension.messaging.activemq.";
    private static final String NOT_WF10_MESSAGING_PREFIX = "org.jboss.as.messaging.";
    private static final String CONTAINER_VERSION;
    private static final ContainerType CONTAINER_TYPE;
    private static final boolean CONTAINER_IS_WILDFLY_9;
    private static final boolean CONTAINER_IS_WILDFLY_10;
    private static final Logger log;
    private static Boolean asyncSupported;

    public static boolean containerIsWildFly9() {
        return CONTAINER_IS_WILDFLY_9;
    }

    public static boolean containerIsWildFly10() {
        return CONTAINER_IS_WILDFLY_10;
    }

    public static boolean containerIsEAP() {
        return ASUtils.containerType() == ContainerType.EAP;
    }

    public static ContainerType containerType() {
        return CONTAINER_TYPE;
    }

    public static String containerTypeAsString() {
        return ASUtils.CONTAINER_TYPE.name;
    }

    public static String containerVersion() {
        return CONTAINER_VERSION;
    }

    public static boolean isAsyncStreamingSupported() {
        if (asyncSupported == null && !(asyncSupported = Boolean.valueOf(ASUtils.containerType() == ContainerType.EAP || ASUtils.containerIsWildFly9() || ASUtils.containerIsWildFly10())).booleanValue()) {
            log.warn((Object)("NOTE: HTTP stream sends are synchronous in WildFly " + CONTAINER_VERSION + ". Use 9.0.0.Alpha1 or higher to have asynchronous sends."));
        }
        return asyncSupported;
    }

    public static ServiceName messagingServiceName() {
        try {
            String methodName;
            String prefix;
            if (ASUtils.containerIsWildFly10()) {
                prefix = WF10_MESSAGING_PREFIX;
                methodName = "getActiveMQServiceName";
            } else {
                prefix = NOT_WF10_MESSAGING_PREFIX;
                methodName = "getHornetQServiceName";
            }
            Method method = ASUtils.loadClass(prefix + "MessagingServices").getMethod(methodName, String.class);
            return (ServiceName)method.invoke(null, "default");
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to determine messaging service name", e);
        }
    }

    public static ServiceName queueServiceName(String name) {
        return ((ServiceName)ASUtils.callJMSServicesMethod("getJmsQueueBaseServiceName", ASUtils.messagingServiceName())).append(new String[]{name});
    }

    public static ServiceName topicServiceName(String name) {
        return ((ServiceName)ASUtils.callJMSServicesMethod("getJmsTopicBaseServiceName", ASUtils.messagingServiceName())).append(new String[]{name});
    }

    private static Object callJMSServicesMethod(String methodName, Object ... args) {
        try {
            Class clazz = ASUtils.loadClass((ASUtils.containerIsWildFly10() ? WF10_MESSAGING_PREFIX : NOT_WF10_MESSAGING_PREFIX) + "jms.JMSServices");
            Method method = null;
            for (Method each : clazz.getMethods()) {
                if (!methodName.equals(each.getName())) continue;
                method = each;
                break;
            }
            if (method == null) {
                throw new NoSuchMethodException("No method " + methodName + " on class " + clazz);
            }
            return method.invoke(null, args);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to invoke JMSSservices method", e);
        }
    }

    public static Class queueServiceClass() {
        return ASUtils.loadClass((ASUtils.containerIsWildFly10() ? WF10_MESSAGING_PREFIX : NOT_WF10_MESSAGING_PREFIX) + "jms.JMSQueueService");
    }

    public static Class topicServiceClass() {
        return ASUtils.loadClass((ASUtils.containerIsWildFly10() ? WF10_MESSAGING_PREFIX : NOT_WF10_MESSAGING_PREFIX) + "jms.JMSTopicService");
    }

    private static Class loadClass(String name) {
        try {
            return ASUtils.class.getClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed to load class " + name, e);
        }
    }

    public static Object waitForAppearanceInJNDI(Context ctx, String jndiName, long timeout) {
        while (timeout > 0L) {
            try {
                Object result = ctx.lookup(jndiName);
                if (result != null) {
                    return result;
                }
            }
            catch (NameNotFoundException result) {
            }
            catch (NamingException ex) {
                throw new RuntimeException("Failed JNDI lookup for " + jndiName, ex);
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex2) {
                throw new RuntimeException("Interrupted while doing JNDI lookup for " + jndiName);
            }
            timeout -= 10L;
        }
        return null;
    }

    public static boolean waitForRemovalFromJNDI(Context ctx, String jndiName, long timeout) {
        boolean removed = false;
        while (!removed && timeout > 0L) {
            try {
                ctx.lookup(jndiName);
            }
            catch (NameNotFoundException ex) {
                removed = true;
            }
            catch (NamingException ex) {
                throw new RuntimeException("Failed JNDI lookup for " + jndiName, ex);
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ex) {
                throw new RuntimeException("Interrupted while doing JNDI lookup for " + jndiName);
            }
            timeout -= 10L;
        }
        return removed;
    }

    static {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        String version = null;
        String productName = null;
        try {
            ObjectName name = new ObjectName("jboss.as:management-root=server");
            version = (String)mbs.getAttribute(name, "productVersion");
            if (version == null) {
                version = (String)mbs.getAttribute(name, "releaseVersion");
            }
            productName = (String)mbs.getAttribute(name, "productName");
        }
        catch (MBeanException | OperationsException | ReflectionException name) {
            // empty catch block
        }
        CONTAINER_VERSION = version;
        ContainerType type = ContainerType.UNKNOWN;
        if ("EAP".equals(productName)) {
            type = ContainerType.EAP;
        } else if (version != null && version.startsWith("8.")) {
            type = ContainerType.WILDFLY;
        } else if (productName != null && productName.startsWith("WildFly")) {
            type = ContainerType.WILDFLY;
        }
        CONTAINER_TYPE = type;
        CONTAINER_IS_WILDFLY_9 = type == ContainerType.WILDFLY && version != null && version.startsWith("9.");
        CONTAINER_IS_WILDFLY_10 = type == ContainerType.WILDFLY && version != null && version.startsWith("10.");
        log = Logger.getLogger((String)"org.projectodd.wunderboss.as");
    }

    public static enum ContainerType {
        EAP("EAP"),
        WILDFLY("WildFly"),
        UNKNOWN("unknown");

        public String name;

        private ContainerType(String n2) {
            this.name = n2;
        }
    }
}

