/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.as;

import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.value.Value;
import org.projectodd.wunderboss.Options;
import org.projectodd.wunderboss.WunderBoss;
import org.projectodd.wunderboss.as.ASDestinationManager;
import org.projectodd.wunderboss.as.ASUtils;
import org.projectodd.wunderboss.as.MSCService;
import org.projectodd.wunderboss.messaging.Messaging;
import org.projectodd.wunderboss.messaging.hornetq.HQMessaging;
import org.projectodd.wunderboss.messaging.jms.DestinationUtil;
import org.projectodd.wunderboss.messaging.jms.JMSDestination;
import org.slf4j.Logger;

public class ASMessaging
extends HQMessaging {
    private final MSCService mscService;
    private final Context context;
    private final ASDestinationManager destinationManager;
    private static final Logger log = WunderBoss.logger((String)"org.projectodd.wunderboss.as");

    public ASMessaging(String name, MSCService service, ASDestinationManager destinationManager, Options<Messaging.CreateOption> options) {
        super(name, options);
        this.mscService = service;
        this.context = service.namingContext();
        this.destinationManager = destinationManager;
    }

    public synchronized void start() throws Exception {
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        if (this.started) {
            this.closeCloseables();
            this.started = false;
        }
    }

    protected Queue createQueue(String name, String selector, boolean durable) throws Exception {
        return this.destinationManager.installQueueService(name, DestinationUtil.jndiName((String)name, (JMSDestination.Type)JMSDestination.Type.QUEUE), selector, durable);
    }

    protected Topic createTopic(String name) throws Exception {
        return this.destinationManager.installTopicService(name, DestinationUtil.jndiName((String)name, (JMSDestination.Type)JMSDestination.Type.TOPIC));
    }

    protected void destroyQueue(String name) {
        ServiceController controller = this.mscService.serviceRegistry().getService(ASUtils.queueServiceName(name));
        controller.setMode(ServiceController.Mode.REMOVE);
        this.destinationManager.removeDestination((Value)controller, name, DestinationUtil.jndiName((String)name, (JMSDestination.Type)JMSDestination.Type.QUEUE), JMSDestination.Type.QUEUE);
    }

    protected void destroyTopic(String name) {
        ServiceController controller = this.mscService.serviceRegistry().getService(ASUtils.topicServiceName(name));
        controller.setMode(ServiceController.Mode.REMOVE);
        this.destinationManager.removeDestination((Value)controller, name, DestinationUtil.jndiName((String)name, (JMSDestination.Type)JMSDestination.Type.TOPIC), JMSDestination.Type.TOPIC);
    }

    protected Object lookupJNDI(String jndiName) {
        return this.lookupJNDIWithRetry(jndiName, 0);
    }

    private Object lookupJNDIWithRetry(String jndiName, int attempt) {
        try {
            return this.context.lookup(jndiName);
        }
        catch (NamingException ex) {
            if (ex.getCause() instanceof IllegalStateException && attempt < 100) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.lookupJNDIWithRetry(jndiName, attempt + 1);
            }
            return null;
        }
    }
}

