/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.as;

import javax.jms.Queue;
import javax.jms.Topic;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.Value;
import org.projectodd.wunderboss.messaging.jms.JMSDestination;

public abstract class ASDestinationManager {
    static final String TIMEOUT_PROP = "wunderboss.messaging.destination-availability-timeout";
    private final ServiceTarget serviceTarget;
    private final ServiceName hqServiceName;

    public ASDestinationManager(ServiceTarget target, ServiceName hqServiceName) {
        this.serviceTarget = target;
        this.hqServiceName = hqServiceName;
    }

    public abstract Queue installQueueService(String var1, String var2, String var3, boolean var4) throws Exception;

    public abstract Topic installTopicService(String var1, String var2) throws Exception;

    public abstract void removeDestination(Value var1, String var2, String var3, JMSDestination.Type var4);

    protected ServiceTarget target() {
        return this.serviceTarget;
    }

    protected ServiceName hqServiceName() {
        return this.hqServiceName;
    }

    protected long destinationServiceTimeout() {
        String timeout = System.getProperty(TIMEOUT_PROP);
        if (timeout != null) {
            return Long.parseLong(timeout);
        }
        return 60000L;
    }

    protected void throwTimeout(String message) {
        throw new RuntimeException("Gave up waiting for " + message + " after " + this.destinationServiceTimeout() + "ms. If that time is too short, you can adjust with the " + TIMEOUT_PROP + " system property.");
    }
}

