/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.wildfly;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.jms.Queue;
import javax.jms.Topic;
import javax.naming.Context;
import javax.naming.NamingException;
import org.jboss.as.messaging.MessagingServices;
import org.jboss.as.messaging.jms.JMSQueueService;
import org.jboss.as.messaging.jms.JMSServices;
import org.jboss.as.messaging.jms.JMSTopicService;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.Value;
import org.projectodd.wunderboss.Options;
import org.projectodd.wunderboss.WunderBoss;
import org.projectodd.wunderboss.messaging.Messaging;
import org.projectodd.wunderboss.messaging.hornetq.HQMessaging;
import org.projectodd.wunderboss.messaging.jms2.JMSDestination;
import org.projectodd.wunderboss.wildfly.WildFlyService;
import org.slf4j.Logger;

public class WildFlyMessaging
extends HQMessaging {
    private final WildFlyService wildFlyService;
    private final Context context;
    private static final Logger log = WunderBoss.logger((String)"org.projectodd.wunderboss.wildfly");
    private static final String TIMEOUT_PROP = "wunderboss.messaging.destination-availability-timeout";

    public WildFlyMessaging(String name, WildFlyService service, Options<Messaging.CreateOption> options) {
        super(name, options);
        this.wildFlyService = service;
        this.context = service.namingContext();
    }

    public synchronized void start() throws Exception {
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        if (this.started) {
            this.closeCloseables();
            this.started = false;
        }
    }

    protected Queue createQueue(String name, String selector, boolean durable) throws Exception {
        Queue queue = (Queue)this.waitForValueAvailabilityChange((Value)this.installService(JMSQueueService.class, name, this.wildFlyService.serviceTarget(), this.hqServiceName(), selector, durable, new String[]{JMSDestination.jndiName((String)name, (String)"queue")}), false);
        if (queue == null) {
            this.throwTimeout("creation of queue " + name);
        }
        return queue;
    }

    protected Topic createTopic(String name) throws Exception {
        Topic topic = (Topic)this.waitForValueAvailabilityChange((Value)this.installService(JMSTopicService.class, name, this.hqServiceName(), this.wildFlyService.serviceTarget(), new String[]{JMSDestination.jndiName((String)name, (String)"topic")}), false);
        if (topic == null) {
            this.throwTimeout("creation of topic " + name);
        }
        return topic;
    }

    protected void destroyQueue(String name) {
        ServiceController controller = this.wildFlyService.serviceRegistry().getService(JMSServices.getJmsQueueBaseServiceName((ServiceName)this.hqServiceName()).append(new String[]{name}));
        controller.setMode(ServiceController.Mode.REMOVE);
        if (this.waitForValueAvailabilityChange((Value)controller, true) != null) {
            this.throwTimeout("removal of queue " + name);
        }
    }

    protected void destroyTopic(String name) {
        ServiceController controller = this.wildFlyService.serviceRegistry().getService(JMSServices.getJmsTopicBaseServiceName((ServiceName)this.hqServiceName()).append(new String[]{name}));
        controller.setMode(ServiceController.Mode.REMOVE);
        if (this.waitForValueAvailabilityChange((Value)controller, true) != null) {
            this.throwTimeout("removal of topic" + name);
        }
    }

    private void throwTimeout(String message) {
        throw new RuntimeException("Gave up waiting for " + message + " after " + this.valueChangeTimeout() + "ms. If that time is too short, you can adjust with the " + TIMEOUT_PROP + " system property.");
    }

    private ServiceName hqServiceName() {
        return MessagingServices.getHornetQServiceName((String)"default");
    }

    private Object waitForValueAvailabilityChange(Value value, boolean toNull) {
        Object v = value.getValue();
        long nap = 10L;
        for (long count = this.valueChangeTimeout() / nap; (toNull ? v != null : v == null) && count > 0L; --count) {
            try {
                Thread.sleep(nap);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            v = value.getValue();
        }
        return v;
    }

    private long valueChangeTimeout() {
        String timeout = System.getProperty(TIMEOUT_PROP);
        if (timeout != null) {
            return Long.parseLong(timeout);
        }
        return 60000L;
    }

    protected Object lookupJNDI(String jndiName) {
        return this.lookupJNDIWithRetry(jndiName, 0);
    }

    private Object lookupJNDIWithRetry(String jndiName, int attempt) {
        try {
            return this.context.lookup(jndiName);
        }
        catch (NamingException ex) {
            if (ex.getCause() instanceof IllegalStateException && attempt < 100) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                return this.lookupJNDIWithRetry(jndiName, attempt + 1);
            }
            return null;
        }
    }

    private Service installService(Class clazz, Object ... args) throws Exception {
        Method installer = null;
        for (Method m : clazz.getMethods()) {
            if (!"installService".equals(m.getName())) continue;
            installer = m;
            break;
        }
        if (installer == null) {
            throw new NullPointerException("Class has no installService method");
        }
        if (installer.getParameterTypes().length == args.length) {
            return (Service)installer.invoke(null, args);
        }
        ArrayList<Object> extra = new ArrayList<Object>(Collections.nCopies(2, null));
        extra.addAll(Arrays.asList(args));
        return (Service)installer.invoke(null, extra.toArray());
    }
}

