/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.wildfly;

import java.lang.management.ManagementFactory;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import javax.naming.Context;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.projectodd.wunderboss.ComponentProvider;
import org.projectodd.wunderboss.WunderBoss;
import org.projectodd.wunderboss.caching.Caching;
import org.projectodd.wunderboss.messaging.Messaging;
import org.projectodd.wunderboss.singleton.SingletonContext;
import org.projectodd.wunderboss.transactions.Transaction;
import org.projectodd.wunderboss.wildfly.ChannelProvider;
import org.projectodd.wunderboss.wildfly.ChannelWrapper;
import org.projectodd.wunderboss.wildfly.SingletonContextProvider;
import org.projectodd.wunderboss.wildfly.WildFlyCachingProvider;
import org.projectodd.wunderboss.wildfly.WildFlyMessagingProvider;
import org.projectodd.wunderboss.wildfly.WildFlyTransactionProvider;

public class WildFlyService
implements Service<WildFlyService> {
    public static final String KEY = "wildfly-service";
    private final String deploymentName;
    private final ServiceRegistry serviceRegistry;
    private final ServiceTarget serviceTarget;
    private final Context namingContext;
    private static final Logger log = Logger.getLogger((String)"org.projectodd.wunderboss.wildfly");
    static final ServiceName JMS_MANAGER_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"messaging", "default", "jms", "manager"});
    static final ServiceName WEB_CACHE_MANAGER = ServiceName.JBOSS.append(new String[]{"infinispan", "web"});
    static final ServiceName TRANSACTION_MANAGER = ServiceName.JBOSS.append(new String[]{"txn", "TransactionManager"});

    public static ServiceName parentServiceName(String deploymentName) {
        return ServiceName.JBOSS.append(new String[]{"deployment"}).append(new String[]{"unit"}).append(new String[]{deploymentName});
    }

    public static ServiceName serviceName(String deploymentName) {
        return WildFlyService.parentServiceName(deploymentName).append(new String[]{"wunderboss"});
    }

    public WildFlyService(String deploymentName, ServiceRegistry registry, ServiceTarget serviceTarget, Context namingContext) {
        this.deploymentName = deploymentName;
        this.serviceRegistry = registry;
        this.serviceTarget = serviceTarget;
        this.namingContext = namingContext;
        WunderBoss.putOption((String)"deployment-name", (Object)this.deploymentName);
        WunderBoss.putOption((String)"service-registry", (Object)this.serviceRegistry);
        WunderBoss.putOption((String)"wildfly-version", (Object)this.getWildFlyVersion());
        WunderBoss.putOption((String)KEY, (Object)this);
    }

    public void start(StartContext context) throws StartException {
        try {
            WunderBoss.registerComponentProvider(Messaging.class, (ComponentProvider)new WildFlyMessagingProvider());
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        try {
            WunderBoss.registerComponentProvider(Caching.class, (ComponentProvider)new WildFlyCachingProvider());
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        try {
            WunderBoss.registerComponentProvider(Transaction.class, (ComponentProvider)new WildFlyTransactionProvider());
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        WunderBoss.registerComponentProvider(SingletonContext.class, (ComponentProvider)new SingletonContextProvider());
        WunderBoss.registerComponentProvider(ChannelWrapper.class, (ComponentProvider)new ChannelProvider());
    }

    public void stop(StopContext context) {
    }

    public WildFlyService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    String getWildFlyVersion() {
        MBeanServer mbs = ManagementFactory.getPlatformMBeanServer();
        String version = null;
        try {
            ObjectName name = new ObjectName("jboss.as:management-root=server");
            version = (String)mbs.getAttribute(name, "productVersion");
            if (version == null) {
                version = (String)mbs.getAttribute(name, "releaseVersion");
            }
        }
        catch (MBeanException | OperationsException | ReflectionException ffs) {
            ffs.printStackTrace();
        }
        return version;
    }

    public ServiceTarget serviceTarget() {
        return this.serviceTarget;
    }

    public ServiceRegistry serviceRegistry() {
        return this.serviceRegistry;
    }

    public Context namingContext() {
        return this.namingContext;
    }
}

