/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.wildfly;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.jgroups.Address;
import org.jgroups.Channel;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.ReceiverAdapter;
import org.jgroups.View;
import org.jgroups.blocks.MessageDispatcher;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.blocks.RequestOptions;
import org.jgroups.blocks.ResponseMode;
import org.jgroups.blocks.locking.LockService;
import org.jgroups.util.RspList;
import org.projectodd.wunderboss.Component;
import org.projectodd.wunderboss.WunderBoss;
import org.projectodd.wunderboss.wildfly.ClusterUtils;

public class ChannelWrapper
extends ReceiverAdapter
implements RequestHandler,
Component {
    private final String name;
    private JChannel channel;
    private MessageDispatcher dispatcher;
    private LockService lockService;
    private final Map<String, RequestHandler> registeredHandlers = new HashMap<String, RequestHandler>();
    private final List<MembershipListener> membershipListeners = new ArrayList<MembershipListener>();

    public ChannelWrapper(String name) {
        this.name = name;
    }

    public synchronized void start() throws Exception {
        if (this.channel == null) {
            this.channel = ClusterUtils.lockableChannel(this.name);
            this.dispatcher = new MessageDispatcher((Channel)this.channel, null, (MembershipListener)this, (RequestHandler)this);
            this.setLockService();
            this.channel.connect(WunderBoss.options().getString((Object)"deployment-name"));
        }
    }

    public synchronized void stop() throws Exception {
        if (this.channel != null) {
            this.channel.disconnect();
            this.channel.close();
            this.channel = null;
        }
    }

    public boolean isRunning() {
        return this.channel != null;
    }

    public Channel channel() {
        if (this.channel == null) {
            try {
                this.start();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return this.channel;
    }

    public String name() {
        return this.name;
    }

    public Lock getLock(String name) {
        return this.lockService.getLock(name);
    }

    public ChannelWrapper registerHandler(String id, RequestHandler handler) {
        this.registeredHandlers.put(id, handler);
        return this;
    }

    public ChannelWrapper addMembershipListener(MembershipListener listener) {
        this.membershipListeners.add(listener);
        return this;
    }

    public RspList<Address> castMessage(List<Address> dests, Object msg, long timeout) throws Exception {
        return this.dispatcher.castMessage(dests, new Message(null, msg), new RequestOptions(ResponseMode.GET_ALL, timeout));
    }

    public void viewAccepted(View view) {
        for (MembershipListener each : this.membershipListeners) {
            each.viewAccepted(view);
        }
    }

    public Object handle(Message msg) throws Exception {
        Map content = (Map)msg.getObject();
        if (this.registeredHandlers.containsKey(content.get("dispatch"))) {
            return this.registeredHandlers.get(content.get("dispatch")).handle(msg);
        }
        return null;
    }

    private void setLockService() throws Exception {
        Method setter = null;
        for (Method m : LockService.class.getMethods()) {
            if (!"setChannel".equals(m.getName())) continue;
            setter = m;
            break;
        }
        this.lockService = (LockService)LockService.class.newInstance();
        setter.invoke((Object)this.lockService, this.channel);
    }
}

