/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.wildfly;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import org.jboss.logging.Logger;
import org.jgroups.Address;
import org.jgroups.JChannel;
import org.jgroups.MembershipListener;
import org.jgroups.Message;
import org.jgroups.View;
import org.jgroups.blocks.RequestHandler;
import org.jgroups.util.Rsp;
import org.jgroups.util.RspList;
import org.projectodd.wunderboss.WunderBoss;
import org.projectodd.wunderboss.singleton.ClusterChangeCallback;
import org.projectodd.wunderboss.singleton.ClusterParticipant;
import org.projectodd.wunderboss.wildfly.ChannelWrapper;

public class SingletonClusterParticipant
implements ClusterParticipant,
RequestHandler,
MembershipListener {
    private final String name;
    private final JChannel channel;
    private final ChannelWrapper channelWrapper;
    private Address currentMaster = null;
    private ClusterChangeCallback clusterChangeCallback;
    private static final Logger log = Logger.getLogger(SingletonClusterParticipant.class);

    public SingletonClusterParticipant(String name) {
        this.name = name;
        this.channelWrapper = (ChannelWrapper)WunderBoss.findOrCreateComponent(ChannelWrapper.class);
        this.channel = (JChannel)this.channelWrapper.channel();
        this.channelWrapper.registerHandler(name, this).addMembershipListener(this);
    }

    public void viewAccepted(View view) {
        if (!view.containsMember(this.currentMaster)) {
            this.currentMaster = null;
        }
        if (this.clusterChangeCallback != null) {
            this.clusterChangeCallback.clusterChanged(this.isMasterWithoutInterrogatingCluster(), this.isMaster());
        }
    }

    public void suspect(Address suspected_mbr) {
    }

    public void block() {
    }

    public void unblock() {
    }

    public Object handle(Message msg) {
        Map content = (Map)msg.getObject();
        Address requestedMaster = (Address)content.get("payload");
        Address oldMaster = this.currentMaster;
        if (this.currentMaster == null) {
            this.currentMaster = requestedMaster;
        }
        return oldMaster;
    }

    public Address id() {
        return this.channel.getAddress();
    }

    public boolean isMasterWithoutInterrogatingCluster() {
        Address id = this.id();
        return id != null && id.equals(this.currentMaster);
    }

    public void setClusterChangeCallback(ClusterChangeCallback callback) {
        this.clusterChangeCallback = callback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isMaster() {
        boolean isMaster;
        block13: {
            isMaster = false;
            try {
                if (this.currentMaster != null) {
                    isMaster = this.isMasterWithoutInterrogatingCluster();
                    break block13;
                }
                Lock lock = this.channelWrapper.getLock(this.name);
                lock.lock();
                try {
                    if (this.currentMaster != null) {
                        isMaster = this.isMasterWithoutInterrogatingCluster();
                    } else if (this.id() != null) {
                        HashMap<String, String> msg = new HashMap<String, String>();
                        msg.put("dispatch", this.name);
                        msg.put("payload", (String)this.id());
                        RspList<Address> responses = this.channelWrapper.castMessage(null, msg, 5000L);
                        HashSet<Address> possibleMasters = new HashSet<Address>();
                        Address reportedMaster = null;
                        for (Map.Entry each : responses.entrySet()) {
                            Address addr = (Address)((Rsp)each.getValue()).getValue();
                            if (addr == null) continue;
                            possibleMasters.add(addr);
                            reportedMaster = addr;
                        }
                        if (possibleMasters.size() > 1) {
                            throw new IllegalStateException("Cluster in broken state, multiple masters for " + this.name + ": " + possibleMasters);
                        }
                        if (reportedMaster == null) {
                            isMaster = true;
                        } else {
                            this.currentMaster = reportedMaster;
                            isMaster = false;
                        }
                    }
                }
                finally {
                    lock.unlock();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isMaster;
    }
}

