/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.wildfly;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarFile;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleClassLoader;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;

public class ModuleUtils {
    public static void addToModuleClasspath(Module module, List<File> urls) throws IOException, ModuleLoadException {
        ArrayList<ResourceLoaderSpec> loaderSpecs = new ArrayList<ResourceLoaderSpec>();
        for (File each : urls) {
            String name = each.getName();
            ResourceLoader loader = name.endsWith(".jar") ? ResourceLoaders.createJarResourceLoader((String)name, (JarFile)new JarFile(each)) : ResourceLoaders.createFileResourceLoader((String)name, (File)each);
            loaderSpecs.add(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)loader));
        }
        for (ResourceLoader each : ModuleUtils.getExistingResourceLoaders(module)) {
            loaderSpecs.add(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)each));
        }
        ModuleLoader moduleLoader = module.getModuleLoader();
        try {
            ModuleUtils.lookupMethod(ModuleLoader.class, "setAndRefreshResourceLoaders", Module.class, Collection.class).invoke((Object)moduleLoader, module, loaderSpecs);
            ModuleUtils.lookupMethod(ModuleLoader.class, "refreshResourceLoaders", Module.class).invoke((Object)moduleLoader, module);
            ModuleUtils.lookupMethod(ModuleLoader.class, "relink", Module.class).invoke((Object)moduleLoader, module);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
    }

    protected static ResourceLoader[] getExistingResourceLoaders(Module module) {
        ResourceLoader[] loaders;
        try {
            loaders = (ResourceLoader[])ModuleUtils.lookupMethod(ModuleClassLoader.class, "getResourceLoaders", new Class[0]).invoke((Object)module.getClassLoader(), new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new IllegalStateException(e);
        }
        return loaders;
    }

    protected static Method lookupMethod(Class clazz, String methodName, Class ... argClasses) {
        Method method;
        try {
            method = clazz.getDeclaredMethod(methodName, argClasses);
            method.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e);
        }
        return method;
    }
}

