/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.wildfly;

import java.lang.reflect.Method;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jgroups.JChannel;
import org.jgroups.protocols.CENTRAL_LOCK;
import org.jgroups.stack.Protocol;
import org.projectodd.wunderboss.WunderBoss;

public class ClusterUtils {
    private static final String WF8_CHANNEL_FACTORY_CLASS_NAME = "org.jboss.as.clustering.jgroups.ChannelFactory";
    private static final String WF9_CHANNEL_FACTORY_CLASS_NAME = "org.wildfly.clustering.jgroups.ChannelFactory";
    private static final ServiceName WF8_JGROUPS_STACK_NAME = ServiceName.parse((String)"jboss.jgroups.stack");
    private static final ServiceName WF9_JGROUPS_STACK_NAME = ServiceName.parse((String)"jboss.jgroups.factory.default-stack");

    public static boolean inCluster() {
        return ClusterUtils.channelFactory() != null;
    }

    public static JChannel lockableChannel(String id) throws Exception {
        Class<?> channelInterface;
        try {
            channelInterface = Class.forName(WF8_CHANNEL_FACTORY_CLASS_NAME);
        }
        catch (ClassNotFoundException e) {
            try {
                channelInterface = Class.forName(WF9_CHANNEL_FACTORY_CLASS_NAME);
            }
            catch (ClassNotFoundException e2) {
                throw new RuntimeException("Failed to find the ChannelFactory interface", e2);
            }
        }
        if (channelInterface == null) {
            return null;
        }
        Method createChannel = channelInterface.getDeclaredMethod("createChannel", String.class);
        JChannel chan = (JChannel)createChannel.invoke(ClusterUtils.channelFactory(), id);
        CENTRAL_LOCK l = new CENTRAL_LOCK();
        l.setNumberOfBackups(1);
        chan.getProtocolStack().addProtocol((Protocol)l);
        l.init();
        return chan;
    }

    public static Object channelFactory() {
        ServiceRegistry registry = (ServiceRegistry)WunderBoss.options().get((Object)"service-registry");
        if (registry != null) {
            ServiceController serviceController = registry.getService(WF8_JGROUPS_STACK_NAME);
            if (serviceController == null) {
                serviceController = registry.getService(WF9_JGROUPS_STACK_NAME);
            }
            return serviceController == null ? null : serviceController.getValue();
        }
        return null;
    }
}

