/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.wildfly;

import java.util.Map;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.msc.service.ServiceRegistry;
import org.projectodd.wunderboss.Options;
import org.projectodd.wunderboss.WunderBoss;
import org.projectodd.wunderboss.caching.Caching;
import org.projectodd.wunderboss.caching.InfinispanCaching;
import org.projectodd.wunderboss.wildfly.ClusterUtils;
import org.projectodd.wunderboss.wildfly.WildFlyService;

public class WildFlyCaching
extends InfinispanCaching {
    public WildFlyCaching(String name, Options<Caching.CreateOption> options) {
        super(name, options);
    }

    public synchronized EmbeddedCacheManager manager() {
        if (this.manager == null) {
            this.manager = this.getWebCacheManager();
        }
        return this.manager;
    }

    protected Options<Caching.CreateOption> validate(Map<Caching.CreateOption, Object> options) {
        Options result = new Options(options);
        String mode = result.getString((Object)Caching.CreateOption.MODE);
        if (mode == null && ClusterUtils.inCluster()) {
            result.put((Object)Caching.CreateOption.MODE, (Object)"DIST_SYNC");
        }
        return result;
    }

    private EmbeddedCacheManager getWebCacheManager() {
        ServiceRegistry serviceRegistry = (ServiceRegistry)WunderBoss.options().get((Object)"service-registry");
        return (EmbeddedCacheManager)serviceRegistry.getRequiredService(WildFlyService.WEB_CACHE_MANAGER).getValue();
    }

    private GlobalConfiguration getGlobalConfiguration() {
        GlobalConfigurationBuilder builder = new GlobalConfigurationBuilder();
        return builder.read(this.getWebCacheManager().getCacheManagerConfiguration()).classLoader(Thread.currentThread().getContextClassLoader()).transport().clusterName("wboss").build();
    }
}

