/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.wildfly;

import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.servlet.spec.ServletContextImpl;
import java.util.Deque;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletContext;
import javax.servlet.ServletRegistration;
import org.jboss.logging.Logger;
import org.projectodd.wunderboss.Options;
import org.projectodd.wunderboss.web.UndertowWeb;
import org.projectodd.wunderboss.web.Web;

public class WildFlyWeb
extends UndertowWeb {
    private ServletContext servletContext;
    private HttpHandler servletHandler;
    private static final String ORIGINAL_RELATIVE_PATH = "wunderboss.wildfly.orig_relative_path";
    private static final String ORIGINAL_RESOLVED_PATH = "wunderboss.wildfly.orig_resolved_path";
    private static final Logger log = Logger.getLogger(WildFlyWeb.class);

    public WildFlyWeb(String name, ServletContext servletContext) {
        super(name, new Options());
        this.servletContext = servletContext;
        if (servletContext != null) {
            this.addHandlerWrapper();
        }
    }

    public boolean registerServlet(Servlet servlet, Map<Web.RegisterOption, Object> opts) {
        Options options = new Options(opts);
        String context = options.getString((Object)Web.RegisterOption.PATH);
        String mapping = context.endsWith("/") ? context + "*" : context + "/*";
        ServletRegistration.Dynamic servletRegistration = this.servletContext.addServlet(context, servlet);
        servletRegistration.addMapping(new String[]{mapping});
        servletRegistration.setLoadOnStartup(1);
        servletRegistration.setAsyncSupported(true);
        HttpHandler handler = new HttpHandler(){

            public void handleRequest(HttpServerExchange exchange) throws Exception {
                String originalRelativePath = (String)((Deque)exchange.getPathParameters().get(WildFlyWeb.ORIGINAL_RELATIVE_PATH)).remove();
                String originalResolvedPath = (String)((Deque)exchange.getPathParameters().get(WildFlyWeb.ORIGINAL_RESOLVED_PATH)).remove();
                exchange.setRelativePath(originalRelativePath);
                exchange.setResolvedPath(originalResolvedPath);
                WildFlyWeb.this.servletHandler.handleRequest(exchange);
            }
        };
        return this.registerHandler(handler, (Map)options);
    }

    public void start() {
    }

    public void stop() {
    }

    private void addHandlerWrapper() {
        ServletContextImpl servletContextImpl = (ServletContextImpl)this.servletContext;
        servletContextImpl.getDeployment().getDeploymentInfo().addInitialHandlerChainWrapper(new HandlerWrapper(){

            public HttpHandler wrap(HttpHandler handler) {
                WildFlyWeb.this.servletHandler = handler;
                return new HttpHandler(){

                    public void handleRequest(HttpServerExchange exchange) throws Exception {
                        exchange.addPathParam(WildFlyWeb.ORIGINAL_RELATIVE_PATH, exchange.getRelativePath());
                        exchange.addPathParam(WildFlyWeb.ORIGINAL_RESOLVED_PATH, exchange.getResolvedPath());
                        WildFlyWeb.this.pathology.handler().handleRequest(exchange);
                    }
                };
            }
        });
    }
}

