/*
 * Copyright 2014 Red Hat, Inc, and individual contributors.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package org.projectodd.wunderboss.wildfly;

import org.jboss.as.clustering.jgroups.ChannelFactory;
import org.jboss.as.clustering.jgroups.subsystem.ChannelFactoryService;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceRegistry;
import org.jgroups.JChannel;
import org.jgroups.protocols.CENTRAL_LOCK;
import org.projectodd.wunderboss.WunderBoss;


public class ClusterUtils {

    public static boolean inCluster() {
        return channelFactory() != null;
    }

    public static JChannel lockableChannel(String id) throws Exception {
        JChannel chan = (JChannel)channelFactory().createChannel(id);

        //TODO: check the stack and see if it already contains a lock proto
        // and we should doc that as the preferred way, since you can configure the number of backups?
        CENTRAL_LOCK l = new CENTRAL_LOCK();
        l.setNumberOfBackups(1);

        chan.getProtocolStack().addProtocol(l);

        l.init();

        return chan;
    }

    public static ChannelFactory channelFactory() {
        ServiceRegistry registry = (ServiceRegistry)WunderBoss.options().get("service-registry");
        if (registry != null) {
            ServiceController<?> serviceController = registry.getService(ChannelFactoryService.getServiceName(null));
            return serviceController == null ? null : (ChannelFactory) serviceController.getValue();
        }
        return null;
    }
}
