/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.wildfly;

import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.projectodd.wunderboss.ComponentProvider;
import org.projectodd.wunderboss.WunderBoss;
import org.projectodd.wunderboss.caching.Caching;
import org.projectodd.wunderboss.messaging.Messaging;
import org.projectodd.wunderboss.singleton.SingletonContext;
import org.projectodd.wunderboss.wildfly.ChannelProvider;
import org.projectodd.wunderboss.wildfly.ChannelWrapper;
import org.projectodd.wunderboss.wildfly.SingletonContextProvider;
import org.projectodd.wunderboss.wildfly.WildFlyCachingProvider;
import org.projectodd.wunderboss.wildfly.WildFlyMessagingProvider;

public class WildFlyService
implements Service<WildFlyService> {
    private final String deploymentName;
    private final ServiceRegistry registry;
    private static final Logger log = Logger.getLogger((String)"org.projectodd.wunderboss.wildfly");
    static final ServiceName JMS_MANAGER_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"messaging", "default", "jms", "manager"});
    static final ServiceName WEB_CACHE_MANAGER = ServiceName.JBOSS.append(new String[]{"infinispan", "web"});

    public static ServiceName parentServiceName(String deploymentName) {
        return ServiceName.JBOSS.append(new String[]{"deployment"}).append(new String[]{"unit"}).append(new String[]{deploymentName});
    }

    public static ServiceName serviceName(String deploymentName) {
        return WildFlyService.parentServiceName(deploymentName).append(new String[]{"wunderboss"});
    }

    public WildFlyService(String deploymentName, ServiceRegistry registry) {
        this.deploymentName = deploymentName;
        this.registry = registry;
        WunderBoss.putOption((String)"deployment-name", (Object)this.deploymentName);
        WunderBoss.putOption((String)"service-registry", (Object)this.registry);
        WunderBoss.putOption((String)"wildfly-service", (Object)this);
    }

    public void start(StartContext context) throws StartException {
        try {
            WunderBoss.registerComponentProvider(Messaging.class, (ComponentProvider)new WildFlyMessagingProvider());
        }
        catch (LinkageError ignored) {
            // empty catch block
        }
        try {
            WunderBoss.registerComponentProvider(Caching.class, (ComponentProvider)new WildFlyCachingProvider());
        }
        catch (LinkageError linkageError) {
            // empty catch block
        }
        WunderBoss.registerComponentProvider(SingletonContext.class, (ComponentProvider)new SingletonContextProvider());
        WunderBoss.registerComponentProvider(ChannelWrapper.class, (ComponentProvider)new ChannelProvider());
    }

    public void stop(StopContext context) {
    }

    public WildFlyService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

