/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.wildfly;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hornetq.jms.server.JMSServerManager;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceRegistry;
import org.projectodd.wunderboss.Options;
import org.projectodd.wunderboss.WunderBoss;
import org.projectodd.wunderboss.messaging.Messaging;
import org.projectodd.wunderboss.messaging.hornetq.HornetQMessaging;
import org.projectodd.wunderboss.wildfly.WildFlyService;

public class WildFlyMessaging
extends HornetQMessaging {
    private final InitialContext context;

    public WildFlyMessaging(String name, Options<Messaging.CreateOption> options) {
        super(name, options);
        try {
            this.context = new InitialContext();
        }
        catch (NamingException ex) {
            throw new RuntimeException(ex);
        }
    }

    public synchronized void start() throws Exception {
        if (!this.started) {
            ServiceRegistry serviceRegistry = (ServiceRegistry)WunderBoss.options().get((Object)"service-registry");
            ServiceName hornetQServiceName = WildFlyService.JMS_MANAGER_SERVICE_NAME;
            this.jmsServerManager = (JMSServerManager)serviceRegistry.getRequiredService(hornetQServiceName).getValue();
            this.started = true;
        }
    }

    public synchronized void stop() throws Exception {
        if (this.started) {
            this.closeDefaultConnection();
            this.jmsServerManager = null;
            this.started = false;
        }
    }

    protected Object lookupJNDI(String jndiName) {
        return this.lookupJNDIWithRetry(jndiName, 0);
    }

    private Object lookupJNDIWithRetry(String jndiName, int attempt) {
        try {
            return this.context.lookup(jndiName);
        }
        catch (NamingException ex) {
            if (ex.getCause() instanceof IllegalStateException && attempt < 100) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                }
                return this.lookupJNDIWithRetry(jndiName, attempt + 1);
            }
            throw new RuntimeException(ex);
        }
    }
}

