/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.wildfly;

import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import org.jboss.logging.Logger;
import org.jboss.modules.Module;
import org.projectodd.wunderboss.ApplicationRunner;
import org.projectodd.wunderboss.ComponentProvider;
import org.projectodd.wunderboss.WunderBoss;
import org.projectodd.wunderboss.web.Web;
import org.projectodd.wunderboss.wildfly.ModuleUtils;
import org.projectodd.wunderboss.wildfly.WildFlyService;
import org.projectodd.wunderboss.wildfly.WildflyWebProvider;

public class ServletListener
implements ServletContextListener {
    private ApplicationRunner applicationRunner;
    private static final Logger log = Logger.getLogger((String)"org.projectodd.wunderboss.wildfly");

    public void contextInitialized(ServletContextEvent sce) {
        WunderBoss.putOption((String)"servlet-context-path", (Object)sce.getServletContext().getContextPath());
        try {
            WunderBoss.registerComponentProvider(Web.class, (ComponentProvider)new WildflyWebProvider(sce.getServletContext()));
        }
        catch (LinkageError ignored) {
            // empty catch block
        }
        this.applicationRunner = new ApplicationRunner(this.getName(sce)){

            protected void updateClassPath() throws Exception {
                super.updateClassPath();
                ModuleUtils.addToModuleClasspath(Module.forClass(WildFlyService.class), this.classPathAdditions);
            }

            protected URL jarURL() {
                String mainPath = ApplicationRunner.class.getName().replace(".", "/") + ".class";
                String mainUrl = ApplicationRunner.class.getClassLoader().getResource(mainPath).toString();
                String marker = ".jar";
                int to = mainUrl.lastIndexOf(marker);
                try {
                    return new URL(mainUrl.substring(0, to + marker.length()));
                }
                catch (MalformedURLException e) {
                    throw new RuntimeException("Error determining jar url", e);
                }
            }
        };
        try {
            this.applicationRunner.start(null);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void contextDestroyed(ServletContextEvent sce) {
        log.debug((Object)"Stopping WunderBoss application");
        try {
            WunderBoss.shutdownAndReset();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            if (this.applicationRunner != null) {
                this.applicationRunner.stop();
                this.applicationRunner = null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String getName(ServletContextEvent sce) {
        String result = sce.getServletContext().getServletContextName();
        if (result == null) {
            result = sce.getServletContext().getContextPath();
        }
        return result;
    }
}

