/*
 * Decompiled with CFR 0.152.
 */
package org.projectodd.wunderboss.scheduling;

import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.projectodd.wunderboss.Options;
import org.projectodd.wunderboss.WunderBoss;
import org.projectodd.wunderboss.scheduling.RunnableJob;
import org.projectodd.wunderboss.scheduling.Scheduling;
import org.projectodd.wunderboss.singleton.SingletonContext;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.JobKey;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.DirectSchedulerFactory;
import org.quartz.listeners.TriggerListenerSupport;
import org.quartz.simpl.RAMJobStore;
import org.quartz.simpl.SimpleThreadPool;
import org.quartz.spi.JobStore;
import org.quartz.spi.ThreadPool;
import org.slf4j.Logger;

public class QuartzScheduling
implements Scheduling {
    private final String name;
    private int numThreads;
    private boolean started;
    private Scheduler scheduler;
    private final Jobs currentJobs = new Jobs();
    private static final Logger log = WunderBoss.logger(Scheduling.class);

    public QuartzScheduling(String name, Options<Scheduling.CreateOption> options) {
        this.name = name;
        this.numThreads = options.getInt((Object)Scheduling.CreateOption.NUM_THREADS);
    }

    public void start() throws Exception {
        if (!this.started) {
            System.setProperty("org.terracotta.quartz.skipUpdateCheck", "true");
            DirectSchedulerFactory factory = DirectSchedulerFactory.getInstance();
            SimpleThreadPool threadPool = new SimpleThreadPool(this.numThreads, 5);
            threadPool.setThreadNamePrefix("scheduling-worker");
            threadPool.initialize();
            String schedulerName = "SimpleQuartzScheduler:" + this.name;
            factory.createScheduler(schedulerName, "SIMPLE_NON_CLUSTERED:" + this.name, (ThreadPool)threadPool, (JobStore)new RAMJobStore());
            this.scheduler = factory.getScheduler(schedulerName);
            this.scheduler.getListenerManager().addTriggerListener((org.quartz.TriggerListener)new TriggerListener());
            this.scheduler.start();
            this.started = true;
            log.info("Quartz started");
        }
    }

    public void stop() throws Exception {
        if (this.started) {
            this.scheduler.shutdown(true);
            this.started = false;
            log.info("Quartz stopped");
        }
    }

    public boolean isRunning() {
        return this.started;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public String name() {
        return this.name;
    }

    @Override
    public synchronized boolean schedule(String name, Runnable fn, Map<Scheduling.ScheduleOption, Object> opts) throws Exception {
        Options options = new Options(opts);
        this.validateOptions((Options<Scheduling.ScheduleOption>)options);
        this.start();
        boolean replacedExisting = this.unschedule(name);
        JobDataMap jobDataMap = new JobDataMap();
        if (options.getBoolean((Object)Scheduling.ScheduleOption.SINGLETON).booleanValue()) {
            fn = ((SingletonContext)WunderBoss.findOrCreateComponent(SingletonContext.class, (String)name, null)).setRunnable(fn);
        }
        jobDataMap.put("run_function", (Object)fn);
        JobDetail job = JobBuilder.newJob(RunnableJob.class).usingJobData(jobDataMap).build();
        this.scheduler.scheduleJob(job, this.initTrigger(name, (Options<Scheduling.ScheduleOption>)options));
        this.currentJobs.put(name, job.getKey());
        return replacedExisting;
    }

    @Override
    public synchronized boolean unschedule(String name) throws SchedulerException {
        if (this.currentJobs.contains(name)) {
            JobKey job = this.currentJobs.remove(name);
            try {
                this.scheduler.deleteJob(job);
            }
            catch (SchedulerException ex) {
                this.scheduler.deleteJob(job);
            }
            return true;
        }
        return false;
    }

    @Override
    public Set<String> scheduledJobs() {
        return Collections.unmodifiableSet(new HashSet<String>(this.currentJobs.getNames()));
    }

    public synchronized JobKey lookupJob(String name) {
        return this.currentJobs.get(name);
    }

    protected void validateOptions(Options<Scheduling.ScheduleOption> opts) throws IllegalArgumentException {
        if (opts.has((Object)Scheduling.ScheduleOption.CRON)) {
            for (Scheduling.ScheduleOption each : new Scheduling.ScheduleOption[]{Scheduling.ScheduleOption.EVERY, Scheduling.ScheduleOption.LIMIT}) {
                if (!opts.has((Object)each)) continue;
                throw new IllegalArgumentException("You can't specify both 'cron' and '" + each.name + "'");
            }
        }
        if (opts.has((Object)Scheduling.ScheduleOption.AT) && opts.has((Object)Scheduling.ScheduleOption.IN)) {
            throw new IllegalArgumentException("You can't specify both 'at' and 'in'");
        }
        if (!opts.has((Object)Scheduling.ScheduleOption.EVERY)) {
            if (opts.has((Object)Scheduling.ScheduleOption.LIMIT)) {
                throw new IllegalArgumentException("You can't specify 'limit' without 'every'");
            }
            if (opts.has((Object)Scheduling.ScheduleOption.UNTIL) && !opts.has((Object)Scheduling.ScheduleOption.CRON)) {
                throw new IllegalArgumentException("You can't specify 'until' without 'every' or 'cron'");
            }
        }
    }

    protected Trigger initTrigger(String name, Options<Scheduling.ScheduleOption> opts) {
        TriggerBuilder builder = TriggerBuilder.newTrigger().withIdentity(name, this.name());
        if (opts.has((Object)Scheduling.ScheduleOption.AT)) {
            builder.startAt(opts.getDate((Object)Scheduling.ScheduleOption.AT));
        } else if (opts.has((Object)Scheduling.ScheduleOption.IN)) {
            builder.startAt(new Date(System.currentTimeMillis() + opts.getLong((Object)Scheduling.ScheduleOption.IN)));
        } else {
            builder.startNow();
        }
        if (opts.has((Object)Scheduling.ScheduleOption.UNTIL)) {
            builder.endAt(opts.getDate((Object)Scheduling.ScheduleOption.UNTIL));
        }
        if (opts.has((Object)Scheduling.ScheduleOption.CRON)) {
            builder.withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)opts.getString((Object)Scheduling.ScheduleOption.CRON)));
        } else if (opts.has((Object)Scheduling.ScheduleOption.EVERY)) {
            SimpleScheduleBuilder schedule = SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds((long)opts.getInt((Object)Scheduling.ScheduleOption.EVERY).intValue());
            if (opts.has((Object)Scheduling.ScheduleOption.LIMIT)) {
                schedule.withRepeatCount(opts.getInt((Object)Scheduling.ScheduleOption.LIMIT) - 1);
            } else {
                schedule.repeatForever();
            }
            builder.withSchedule((ScheduleBuilder)schedule);
        }
        return builder.build();
    }

    static class Jobs {
        private final Map<String, JobKey> names = new HashMap<String, JobKey>();
        private final Map<JobKey, String> keys = new HashMap<JobKey, String>();

        Jobs() {
        }

        synchronized void put(String name, JobKey key) {
            this.names.put(name, key);
            this.keys.put(key, name);
        }

        synchronized JobKey remove(String name) {
            JobKey key = this.names.remove(name);
            this.keys.remove(key);
            return key;
        }

        synchronized String remove(JobKey key) {
            String name = this.keys.remove(key);
            this.names.remove(name);
            return name;
        }

        JobKey get(String name) {
            return this.names.get(name);
        }

        synchronized boolean contains(String name) {
            return this.names.containsKey(name);
        }

        Set<String> getNames() {
            return this.names.keySet();
        }
    }

    class TriggerListener
    extends TriggerListenerSupport {
        TriggerListener() {
        }

        public String getName() {
            return "housekeeping";
        }

        public void triggerComplete(Trigger trigger, JobExecutionContext ctx, Trigger.CompletedExecutionInstruction i) {
            if (!trigger.mayFireAgain()) {
                QuartzScheduling.this.currentJobs.remove(ctx.getJobDetail().getKey());
            }
        }
    }
}

