/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.storage.serialize;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.projectnessie.nessie.relocated.protobuf.ByteString;
import org.projectnessie.nessie.relocated.protobuf.InvalidProtocolBufferException;
import org.projectnessie.versioned.storage.common.exceptions.ObjTooLargeException;
import org.projectnessie.versioned.storage.common.indexes.StoreKey;
import org.projectnessie.versioned.storage.common.objtypes.CommitHeaders;
import org.projectnessie.versioned.storage.common.objtypes.CommitObj;
import org.projectnessie.versioned.storage.common.objtypes.CommitType;
import org.projectnessie.versioned.storage.common.objtypes.Compression;
import org.projectnessie.versioned.storage.common.objtypes.ContentValueObj;
import org.projectnessie.versioned.storage.common.objtypes.IndexObj;
import org.projectnessie.versioned.storage.common.objtypes.IndexSegmentsObj;
import org.projectnessie.versioned.storage.common.objtypes.IndexStripe;
import org.projectnessie.versioned.storage.common.objtypes.RefObj;
import org.projectnessie.versioned.storage.common.objtypes.StringObj;
import org.projectnessie.versioned.storage.common.objtypes.TagObj;
import org.projectnessie.versioned.storage.common.persist.Obj;
import org.projectnessie.versioned.storage.common.persist.ObjId;
import org.projectnessie.versioned.storage.common.persist.Reference;
import org.projectnessie.versioned.storage.common.proto.StorageTypes;

public final class ProtoSerialization {
    private ProtoSerialization() {
    }

    public static byte[] serializeReference(Reference reference) {
        ObjId extendedInfoObj;
        if (reference == null) {
            return null;
        }
        StorageTypes.ReferenceProto.Builder refBuilder = StorageTypes.ReferenceProto.newBuilder().setName(reference.name()).setPointer(ProtoSerialization.serializeObjId(reference.pointer())).setDeleted(reference.deleted());
        long created = reference.createdAtMicros();
        if (created != 0L) {
            refBuilder.setCreatedAtMicros(created);
        }
        if ((extendedInfoObj = reference.extendedInfoObj()) != null) {
            refBuilder.setExtendedInfoObj(ProtoSerialization.serializeObjId(extendedInfoObj));
        }
        return refBuilder.build().toByteArray();
    }

    public static Reference deserializeReference(byte[] reference) {
        if (reference == null) {
            return null;
        }
        try {
            StorageTypes.ReferenceProto proto = StorageTypes.ReferenceProto.parseFrom((byte[])reference);
            return Reference.reference((String)proto.getName(), (ObjId)ProtoSerialization.deserializeObjId(proto.getPointer()), (boolean)proto.getDeleted(), (long)proto.getCreatedAtMicros(), (ObjId)ProtoSerialization.deserializeObjId(proto.getExtendedInfoObj()));
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public static ByteString serializeObjId(ObjId id) {
        if (id == null) {
            return null;
        }
        return id.asBytes();
    }

    public static ObjId deserializeObjId(ByteString bytes) {
        if (bytes == null || bytes.isEmpty()) {
            return null;
        }
        return ObjId.objIdFromBytes((ByteString)bytes);
    }

    public static void serializeObjIds(List<ObjId> ids, Consumer<ByteString> receiver) {
        if (ids != null) {
            for (ObjId id : ids) {
                receiver.accept(ProtoSerialization.serializeObjId(id));
            }
        }
    }

    public static void deserializeObjIds(List<ByteString> bytes, Consumer<ObjId> receiver) {
        if (bytes != null) {
            for (ByteString b : bytes) {
                receiver.accept(ProtoSerialization.deserializeObjId(b));
            }
        }
    }

    public static List<ObjId> deserializeObjIds(List<ByteString> predecessorsList) {
        ArrayList<ObjId> result = new ArrayList<ObjId>(predecessorsList.size());
        ProtoSerialization.deserializeObjIds(predecessorsList, result::add);
        return result;
    }

    public static byte[] serializeObj(Obj obj, int incrementalIndexSizeLimit, int indexSizeLimit) throws ObjTooLargeException {
        if (obj == null) {
            return null;
        }
        StorageTypes.ObjProto.Builder b = StorageTypes.ObjProto.newBuilder();
        switch (obj.type()) {
            case COMMIT: {
                return b.setCommit(ProtoSerialization.serializeCommit((CommitObj)obj, incrementalIndexSizeLimit)).build().toByteArray();
            }
            case VALUE: {
                return b.setContentValue(ProtoSerialization.serializeContentValue((ContentValueObj)obj)).build().toByteArray();
            }
            case REF: {
                return b.setRef(ProtoSerialization.serializeRef((RefObj)obj)).build().toByteArray();
            }
            case INDEX_SEGMENTS: {
                return b.setIndexSegments(ProtoSerialization.serializeIndexSegments((IndexSegmentsObj)obj)).build().toByteArray();
            }
            case INDEX: {
                return b.setIndex(ProtoSerialization.serializeIndex((IndexObj)obj, indexSizeLimit)).build().toByteArray();
            }
            case STRING: {
                return b.setStringData(ProtoSerialization.serializeStringData((StringObj)obj)).build().toByteArray();
            }
            case TAG: {
                return b.setTag(ProtoSerialization.serializeTag((TagObj)obj)).build().toByteArray();
            }
        }
        throw new UnsupportedOperationException("Unknown object type " + obj.type());
    }

    public static Obj deserializeObj(ObjId id, ByteBuffer serialized) {
        if (serialized == null) {
            return null;
        }
        try {
            StorageTypes.ObjProto obj = StorageTypes.ObjProto.parseFrom((ByteBuffer)serialized);
            return ProtoSerialization.deserializeObjProto(id, obj);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public static Obj deserializeObj(ObjId id, byte[] serialized) {
        if (serialized == null) {
            return null;
        }
        try {
            StorageTypes.ObjProto obj = StorageTypes.ObjProto.parseFrom((byte[])serialized);
            return ProtoSerialization.deserializeObjProto(id, obj);
        }
        catch (InvalidProtocolBufferException e) {
            throw new RuntimeException(e);
        }
    }

    public static Obj deserializeObjProto(ObjId id, StorageTypes.ObjProto obj) {
        if (obj.hasCommit()) {
            return ProtoSerialization.deserializeCommit(id, obj.getCommit());
        }
        if (obj.hasContentValue()) {
            return ProtoSerialization.deserializeContentValue(id, obj.getContentValue());
        }
        if (obj.hasRef()) {
            return ProtoSerialization.deserializeRef(id, obj.getRef());
        }
        if (obj.hasIndexSegments()) {
            return ProtoSerialization.deserializeIndexSegments(id, obj.getIndexSegments());
        }
        if (obj.hasIndex()) {
            return ProtoSerialization.deserializeIndex(id, obj.getIndex());
        }
        if (obj.hasStringData()) {
            return ProtoSerialization.deserializeStringData(id, obj.getStringData());
        }
        if (obj.hasTag()) {
            return ProtoSerialization.deserializeTag(id, obj.getTag());
        }
        throw new UnsupportedOperationException("Cannot deserialize " + obj);
    }

    private static CommitObj deserializeCommit(ObjId id, StorageTypes.CommitProto commit) {
        CommitObj.Builder b = CommitObj.commitBuilder().id(id).created(commit.getCreated()).seq(commit.getSeq()).message(commit.getMessage()).incrementalIndex(commit.getIncrementalIndex()).incompleteIndex(commit.getIncompleteIndex()).commitType(CommitType.valueOf((String)commit.getCommitType().name()));
        ProtoSerialization.deserializeObjIds(commit.getTailList(), arg_0 -> ((CommitObj.Builder)b).addTail(arg_0));
        ProtoSerialization.deserializeObjIds(commit.getSecondaryParentsList(), arg_0 -> ((CommitObj.Builder)b).addSecondaryParents(arg_0));
        CommitHeaders.Builder h = CommitHeaders.newCommitHeaders();
        for (StorageTypes.HeaderEntry e : commit.getHeadersList()) {
            for (String v : e.getValuesList()) {
                h.add(e.getName(), v);
            }
        }
        b.headers(h.build());
        if (commit.hasReferenceIndex()) {
            b.referenceIndex(ProtoSerialization.deserializeObjId(commit.getReferenceIndex()));
        }
        for (StorageTypes.Stripe s : commit.getReferenceIndexStripesList()) {
            b.addReferenceIndexStripes(IndexStripe.indexStripe((StoreKey)StoreKey.keyFromString((String)s.getFirstKey()), (StoreKey)StoreKey.keyFromString((String)s.getLastKey()), (ObjId)ProtoSerialization.deserializeObjId(s.getSegment())));
        }
        return b.build();
    }

    private static StorageTypes.CommitProto.Builder serializeCommit(CommitObj obj, int indexSizeLimit) throws ObjTooLargeException {
        StorageTypes.CommitProto.Builder b = StorageTypes.CommitProto.newBuilder().setCreated(obj.created()).setSeq(obj.seq()).setMessage(obj.message()).setIncrementalIndex(ProtoSerialization.verifyStoreIndexSize(obj.incrementalIndex(), indexSizeLimit)).setIncompleteIndex(obj.incompleteIndex()).setCommitType(StorageTypes.CommitTypeProto.valueOf((String)obj.commitType().name()));
        ProtoSerialization.serializeObjIds(obj.tail(), arg_0 -> ((StorageTypes.CommitProto.Builder)b).addTail(arg_0));
        ProtoSerialization.serializeObjIds(obj.secondaryParents(), arg_0 -> ((StorageTypes.CommitProto.Builder)b).addSecondaryParents(arg_0));
        for (String h : obj.headers().keySet()) {
            b.addHeaders(StorageTypes.HeaderEntry.newBuilder().setName(h).addAllValues((Iterable)obj.headers().getAll(h)));
        }
        ObjId referenceIndexId = obj.referenceIndex();
        if (referenceIndexId != null) {
            b.setReferenceIndex(ProtoSerialization.serializeObjId(referenceIndexId));
        }
        for (IndexStripe indexStripe : obj.referenceIndexStripes()) {
            b.addReferenceIndexStripes(StorageTypes.Stripe.newBuilder().setFirstKey(indexStripe.firstKey().rawString()).setLastKey(indexStripe.lastKey().rawString()).setSegment(ProtoSerialization.serializeObjId(indexStripe.segment())));
        }
        return b;
    }

    private static ByteString verifyStoreIndexSize(ByteString storeIndex, int indexSizeLimit) throws ObjTooLargeException {
        int serializedSize = storeIndex.size();
        if (serializedSize > indexSizeLimit) {
            throw new ObjTooLargeException(serializedSize, indexSizeLimit);
        }
        return storeIndex;
    }

    private static ByteString verifySize(ByteString index, int indexSizeLimit) throws ObjTooLargeException {
        int size = index.size();
        if (size > indexSizeLimit) {
            throw new ObjTooLargeException(size, indexSizeLimit);
        }
        return index;
    }

    private static ContentValueObj deserializeContentValue(ObjId id, StorageTypes.ContentValueProto contentValue) {
        return ContentValueObj.contentValue((ObjId)id, (String)contentValue.getContentId(), (int)contentValue.getPayload(), (ByteString)contentValue.getData());
    }

    private static StorageTypes.ContentValueProto.Builder serializeContentValue(ContentValueObj obj) {
        return StorageTypes.ContentValueProto.newBuilder().setContentId(obj.contentId()).setPayload(obj.payload()).setData(obj.data());
    }

    private static RefObj deserializeRef(ObjId id, StorageTypes.RefProto ref) {
        return RefObj.ref((ObjId)id, (String)ref.getName(), (ObjId)ProtoSerialization.deserializeObjId(ref.getInitialPointer()), (long)ref.getCreatedAtMicros(), (ObjId)ProtoSerialization.deserializeObjId(ref.getExtendedInfoObj()));
    }

    private static StorageTypes.RefProto.Builder serializeRef(RefObj obj) {
        StorageTypes.RefProto.Builder refBuilder = StorageTypes.RefProto.newBuilder().setName(obj.name()).setCreatedAtMicros(obj.createdAtMicros()).setInitialPointer(ProtoSerialization.serializeObjId(obj.initialPointer()));
        ObjId extendedInfoObj = obj.extendedInfoObj();
        if (extendedInfoObj != null) {
            refBuilder.setExtendedInfoObj(ProtoSerialization.serializeObjId(extendedInfoObj));
        }
        return refBuilder;
    }

    private static IndexSegmentsObj deserializeIndexSegments(ObjId id, StorageTypes.IndexSegmentsProto indexSegments) {
        ArrayList<IndexStripe> stripes = new ArrayList<IndexStripe>(indexSegments.getStripesCount());
        for (StorageTypes.Stripe s : indexSegments.getStripesList()) {
            stripes.add(IndexStripe.indexStripe((StoreKey)StoreKey.keyFromString((String)s.getFirstKey()), (StoreKey)StoreKey.keyFromString((String)s.getLastKey()), (ObjId)ProtoSerialization.deserializeObjId(s.getSegment())));
        }
        return IndexSegmentsObj.indexSegments((ObjId)id, stripes);
    }

    private static StorageTypes.IndexSegmentsProto.Builder serializeIndexSegments(IndexSegmentsObj obj) {
        StorageTypes.IndexSegmentsProto.Builder b = StorageTypes.IndexSegmentsProto.newBuilder();
        for (IndexStripe indexStripe : obj.stripes()) {
            b.addStripes(StorageTypes.Stripe.newBuilder().setFirstKey(indexStripe.firstKey().rawString()).setLastKey(indexStripe.lastKey().rawString()).setSegment(ProtoSerialization.serializeObjId(indexStripe.segment())));
        }
        return b;
    }

    private static IndexObj deserializeIndex(ObjId id, StorageTypes.IndexProto index) {
        return IndexObj.index((ObjId)id, (ByteString)index.getIndex());
    }

    private static StorageTypes.IndexProto.Builder serializeIndex(IndexObj obj, int indexSizeLimit) throws ObjTooLargeException {
        return StorageTypes.IndexProto.newBuilder().setIndex(ProtoSerialization.verifySize(obj.index(), indexSizeLimit));
    }

    private static StringObj deserializeStringData(ObjId id, StorageTypes.StringProto stringData) {
        return StringObj.stringData((ObjId)id, (String)stringData.getContentType(), (Compression)Compression.valueOf((String)stringData.getCompression().name()), (String)(stringData.hasFilename() ? stringData.getFilename() : null), ProtoSerialization.deserializeObjIds(stringData.getPredecessorsList()), (ByteString)stringData.getText());
    }

    private static StorageTypes.StringProto.Builder serializeStringData(StringObj obj) {
        StorageTypes.StringProto.Builder b = StorageTypes.StringProto.newBuilder().setCompression(StorageTypes.CompressionProto.valueOf((String)obj.compression().name())).setContentType(obj.contentType()).setText(obj.text());
        if (obj.filename() != null) {
            b.setFilename(obj.filename());
        }
        ProtoSerialization.serializeObjIds(obj.predecessors(), arg_0 -> ((StorageTypes.StringProto.Builder)b).addPredecessors(arg_0));
        return b;
    }

    private static TagObj deserializeTag(ObjId id, StorageTypes.TagProto tag) {
        CommitHeaders tagHeaders = null;
        if (tag.getHeadersCount() > 0) {
            CommitHeaders.Builder h = CommitHeaders.newCommitHeaders();
            for (StorageTypes.HeaderEntry e : tag.getHeadersList()) {
                for (String v : e.getValuesList()) {
                    h.add(e.getName(), v);
                }
            }
            tagHeaders = h.build();
        }
        String message = tag.hasMessage() ? tag.getMessage() : null;
        ByteString signature = tag.hasSignature() ? tag.getSignature() : null;
        return TagObj.tag((ObjId)id, (String)message, (CommitHeaders)tagHeaders, (ByteString)signature);
    }

    private static StorageTypes.TagProto.Builder serializeTag(TagObj obj) {
        CommitHeaders headers;
        StorageTypes.TagProto.Builder tag = StorageTypes.TagProto.newBuilder();
        if (obj.message() != null) {
            tag.setMessage(obj.message());
        }
        if (obj.signature() != null) {
            tag.setSignature(obj.signature());
        }
        if ((headers = obj.headers()) != null) {
            for (String h : headers.keySet()) {
                tag.addHeaders(StorageTypes.HeaderEntry.newBuilder().setName(h).addAllValues((Iterable)headers.getAll(h)));
            }
        }
        return tag;
    }
}

