/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter.spi;

import com.google.protobuf.ByteString;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.RefLogNotFoundException;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentAndState;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.ContentIdAndBytes;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.Difference;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;
import org.projectnessie.versioned.persist.adapter.MergeParams;
import org.projectnessie.versioned.persist.adapter.RefLog;
import org.projectnessie.versioned.persist.adapter.RepoDescription;
import org.projectnessie.versioned.persist.adapter.RepoMaintenanceParams;
import org.projectnessie.versioned.persist.adapter.TransplantParams;
import org.projectnessie.versioned.persist.adapter.spi.Traced;

public final class TracingDatabaseAdapter
implements DatabaseAdapter {
    private static final String TAG_COUNT = "count";
    private static final String TAG_REF = "ref";
    private static final String TAG_HASH = "hash";
    private static final String TAG_FROM = "from";
    private static final String TAG_TO = "to";
    private static final String TAG_CONTENT_ID = "cid";
    private final DatabaseAdapter delegate;

    public TracingDatabaseAdapter(DatabaseAdapter delegate) {
        this.delegate = delegate;
    }

    @Override
    public void initializeRepo(String defaultBranchName) {
        try (Traced ignore = Traced.trace("initializeRepo").tag(TAG_REF, defaultBranchName);){
            this.delegate.initializeRepo(defaultBranchName);
        }
    }

    @Override
    public void eraseRepo() {
        try (Traced ignore = Traced.trace("eraseRepo");){
            this.delegate.eraseRepo();
        }
    }

    @Override
    public Hash noAncestorHash() {
        return this.delegate.noAncestorHash();
    }

    @Override
    public Hash hashOnReference(NamedRef namedReference, Optional<Hash> hashOnReference) throws ReferenceNotFoundException {
        try (Traced ignore = Traced.trace("hashOnReference").tag(TAG_REF, namedReference.getName());){
            Hash hash = this.delegate.hashOnReference(namedReference, hashOnReference);
            return hash;
        }
    }

    @Override
    public Map<Key, ContentAndState<ByteString>> values(Hash commit, Collection<Key> keys, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        try (Traced ignore = Traced.trace("values").tag(TAG_HASH, commit.asString()).tag(TAG_COUNT, keys.size());){
            Map<Key, ContentAndState<ByteString>> map = this.delegate.values(commit, keys, keyFilter);
            return map;
        }
    }

    @Override
    public Stream<CommitLogEntry> commitLog(Hash offset) throws ReferenceNotFoundException {
        try (Traced ignore = Traced.trace("commitLog.stream").tag(TAG_HASH, offset.asString());){
            Stream<CommitLogEntry> stream = this.delegate.commitLog(offset);
            return stream;
        }
    }

    @Override
    public Stream<KeyListEntry> keys(Hash commit, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        try (Traced ignore = Traced.trace("keys.stream").tag(TAG_HASH, commit.asString());){
            Stream<KeyListEntry> stream = this.delegate.keys(commit, keyFilter);
            return stream;
        }
    }

    @Override
    public Hash commit(CommitParams commitParams) throws ReferenceConflictException, ReferenceNotFoundException {
        try (Traced ignore = Traced.trace("commit").tag(TAG_REF, commitParams.getToBranch().getName());){
            Hash hash = this.delegate.commit(commitParams);
            return hash;
        }
    }

    @Override
    public Hash transplant(TransplantParams transplantParams) throws ReferenceNotFoundException, ReferenceConflictException {
        try (Traced ignore = Traced.trace("transplant").tag(TAG_REF, transplantParams.getToBranch().getName());){
            Hash hash = this.delegate.transplant(transplantParams);
            return hash;
        }
    }

    @Override
    public Hash merge(MergeParams mergeParams) throws ReferenceNotFoundException, ReferenceConflictException {
        try (Traced ignore = Traced.trace("merge").tag(TAG_REF, mergeParams.getToBranch().getName()).tag(TAG_HASH, mergeParams.getMergeFromHash().asString());){
            Hash hash = this.delegate.merge(mergeParams);
            return hash;
        }
    }

    @Override
    public ReferenceInfo<ByteString> namedRef(String ref, GetNamedRefsParams params) throws ReferenceNotFoundException {
        try (Traced ignore = Traced.trace("namedRef").tag(TAG_REF, ref);){
            ReferenceInfo<ByteString> referenceInfo = this.delegate.namedRef(ref, params);
            return referenceInfo;
        }
    }

    @Override
    public Stream<ReferenceInfo<ByteString>> namedRefs(GetNamedRefsParams params) throws ReferenceNotFoundException {
        try (Traced ignore = Traced.trace("namedRefs.stream");){
            Stream<ReferenceInfo<ByteString>> stream = this.delegate.namedRefs(params);
            return stream;
        }
    }

    @Override
    public Hash create(NamedRef ref, Hash target) throws ReferenceAlreadyExistsException, ReferenceNotFoundException {
        try (Traced ignore = Traced.trace("create").tag(TAG_REF, ref.getName()).tag(TAG_HASH, target.asString());){
            Hash hash = this.delegate.create(ref, target);
            return hash;
        }
    }

    @Override
    public void delete(NamedRef reference, Optional<Hash> expectedHead) throws ReferenceNotFoundException, ReferenceConflictException {
        try (Traced ignore = Traced.trace("delete").tag(TAG_REF, reference.getName());){
            this.delegate.delete(reference, expectedHead);
        }
    }

    @Override
    public void assign(NamedRef assignee, Optional<Hash> expectedHead, Hash assignTo) throws ReferenceNotFoundException, ReferenceConflictException {
        try (Traced ignore = Traced.trace("assign").tag(TAG_HASH, assignTo.asString()).tag(TAG_REF, assignee.getName());){
            this.delegate.assign(assignee, expectedHead, assignTo);
        }
    }

    @Override
    public Stream<Difference> diff(Hash from, Hash to, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        try (Traced ignore = Traced.trace("diff.stream").tag(TAG_FROM, from.asString()).tag(TAG_TO, to.asString());){
            Stream<Difference> stream = this.delegate.diff(from, to, keyFilter);
            return stream;
        }
    }

    @Override
    public RepoDescription fetchRepositoryDescription() {
        try (Traced ignore = Traced.trace("fetchRepositoryDescription");){
            RepoDescription repoDescription = this.delegate.fetchRepositoryDescription();
            return repoDescription;
        }
    }

    @Override
    public void updateRepositoryDescription(Function<RepoDescription, RepoDescription> updater) throws ReferenceConflictException {
        try (Traced ignore = Traced.trace("updateRepositoryDescription");){
            this.delegate.updateRepositoryDescription(updater);
        }
    }

    @Override
    public Stream<ContentId> globalKeys() {
        try (Traced ignore = Traced.trace("globalKeys.stream");){
            Stream<ContentId> stream = this.delegate.globalKeys();
            return stream;
        }
    }

    @Override
    public Stream<ContentIdAndBytes> globalContent(Set<ContentId> keys) {
        try (Traced ignore = Traced.trace("globalContent.stream").tag(TAG_COUNT, keys.size());){
            Stream<ContentIdAndBytes> stream = this.delegate.globalContent(keys);
            return stream;
        }
    }

    @Override
    public Optional<ContentIdAndBytes> globalContent(ContentId contentId) {
        try (Traced ignore = Traced.trace("globalContent").tag(TAG_CONTENT_ID, contentId.getId());){
            Optional<ContentIdAndBytes> optional = this.delegate.globalContent(contentId);
            return optional;
        }
    }

    @Override
    public Stream<RefLog> refLog(Hash offset) throws RefLogNotFoundException {
        try (Traced ignore = Traced.trace("refLog.stream").tag(TAG_HASH, offset != null ? offset.asString() : "HEAD");){
            Stream<RefLog> stream = this.delegate.refLog(offset);
            return stream;
        }
    }

    @Override
    public Map<String, Map<String, String>> repoMaintenance(RepoMaintenanceParams repoMaintenanceParams) {
        try (Traced ignore = Traced.trace("repoMaintenance");){
            Map<String, Map<String, String>> map = this.delegate.repoMaintenance(repoMaintenanceParams);
            return map;
        }
    }

    @Override
    public void assertCleanStateForTests() {
        this.delegate.assertCleanStateForTests();
    }
}

