/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter.spi;

import com.google.common.base.Preconditions;
import com.google.common.hash.Hasher;
import com.google.protobuf.ByteString;
import com.google.protobuf.UnsafeByteOperations;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ImmutableReferenceInfo;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.MetadataRewriter;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.RefLogNotFoundException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.StoreWorker;
import org.projectnessie.versioned.TagName;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.CommitParams;
import org.projectnessie.versioned.persist.adapter.ContentAndState;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.Difference;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitLogEntry;
import org.projectnessie.versioned.persist.adapter.ImmutableKeyList;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyListEntity;
import org.projectnessie.versioned.persist.adapter.KeyListEntry;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;
import org.projectnessie.versioned.persist.adapter.MergeParams;
import org.projectnessie.versioned.persist.adapter.MetadataRewriteParams;
import org.projectnessie.versioned.persist.adapter.RefLog;
import org.projectnessie.versioned.persist.adapter.TransplantParams;
import org.projectnessie.versioned.persist.adapter.spi.DatabaseAdapterMetrics;
import org.projectnessie.versioned.persist.adapter.spi.DatabaseAdapterUtil;
import org.projectnessie.versioned.persist.adapter.spi.Traced;
import org.projectnessie.versioned.persist.adapter.spi.TryLoopState;

public abstract class AbstractDatabaseAdapter<OP_CONTEXT, CONFIG extends DatabaseAdapterConfig>
implements DatabaseAdapter {
    private static final Function<Hash, CommitLogEntry> NO_IN_MEMORY_COMMITS = hash -> null;
    protected static final String TAG_HASH = "hash";
    protected static final String TAG_COUNT = "count";
    protected final CONFIG config;
    protected final StoreWorker<?, ?, ?> storeWorker;
    public static final Hash NO_ANCESTOR = Hash.of((ByteString)UnsafeByteOperations.unsafeWrap((byte[])DatabaseAdapterUtil.newHasher().putString((CharSequence)"empty", StandardCharsets.UTF_8).hash().asBytes()));
    protected static long COMMIT_LOG_HASH_SEED = 946928273206945677L;

    protected AbstractDatabaseAdapter(CONFIG config, StoreWorker<?, ?, ?> storeWorker) {
        Objects.requireNonNull(config, "config parameter must not be null");
        this.config = config;
        this.storeWorker = storeWorker;
    }

    @Override
    public Hash noAncestorHash() {
        return NO_ANCESTOR;
    }

    protected long commitTimeInMicros() {
        Instant instant = this.config.getClock().instant();
        long time = instant.getEpochSecond();
        long nano = instant.getNano();
        return TimeUnit.SECONDS.toMicros(time) + TimeUnit.NANOSECONDS.toMicros(nano);
    }

    protected CommitLogEntry commitAttempt(OP_CONTEXT ctx, long timeInMicros, Hash branchHead, CommitParams commitParams, Consumer<Hash> newKeyLists) throws ReferenceNotFoundException, ReferenceConflictException {
        long commitSeq;
        ArrayList<String> mismatches = new ArrayList<String>();
        Callable<Void> validator = commitParams.getValidator();
        if (validator != null) {
            try {
                validator.call();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        this.checkContentKeysUnique(commitParams);
        this.checkExpectedGlobalStates(ctx, commitParams, mismatches::add);
        this.checkForModifiedKeysBetweenExpectedAndCurrentCommit(ctx, commitParams, branchHead, mismatches);
        if (!mismatches.isEmpty()) {
            throw new ReferenceConflictException(String.join((CharSequence)"\n", mismatches));
        }
        CommitLogEntry currentBranchEntry = this.fetchFromCommitLog(ctx, branchHead);
        int parentsPerCommit = this.config.getParentsPerCommit();
        ArrayList<Hash> newParents = new ArrayList<Hash>(parentsPerCommit);
        newParents.add(branchHead);
        if (currentBranchEntry != null) {
            List<Hash> p = currentBranchEntry.getParents();
            newParents.addAll(p.subList(0, Math.min(p.size(), parentsPerCommit - 1)));
            commitSeq = currentBranchEntry.getCommitSeq() + 1L;
        } else {
            commitSeq = 1L;
        }
        CommitLogEntry newBranchCommit = this.buildIndividualCommit(ctx, timeInMicros, newParents, commitSeq, commitParams.getCommitMetaSerialized(), commitParams.getPuts(), commitParams.getDeletes(), currentBranchEntry != null ? currentBranchEntry.getKeyListDistance() : 0, newKeyLists, NO_IN_MEMORY_COMMITS);
        this.writeIndividualCommit(ctx, newBranchCommit);
        return newBranchCommit;
    }

    private void checkContentKeysUnique(CommitParams commitParams) {
        HashSet keys = new HashSet();
        HashSet duplicates = new HashSet();
        Stream.concat(Stream.concat(commitParams.getDeletes().stream(), commitParams.getPuts().stream().map(KeyWithBytes::getKey)), commitParams.getUnchanged().stream()).forEach(key -> {
            if (!keys.add(key)) {
                duplicates.add(key);
            }
        });
        if (!duplicates.isEmpty()) {
            throw new IllegalArgumentException(String.format("Duplicate keys are not allowed in a commit: %s", duplicates.stream().map(Key::toString).collect(Collectors.joining(", "))));
        }
    }

    protected Hash mergeAttempt(OP_CONTEXT ctx, long timeInMicros, Hash toHead, Consumer<Hash> branchCommits, Consumer<Hash> newKeyLists, MergeParams mergeParams) throws ReferenceNotFoundException, ReferenceConflictException {
        this.validateHashExists(ctx, mergeParams.getMergeFromHash());
        this.hashOnRef(ctx, (NamedRef)mergeParams.getToBranch(), mergeParams.getExpectedHead(), toHead);
        Hash commonAncestor = this.findCommonAncestor(ctx, mergeParams.getMergeFromHash(), (NamedRef)mergeParams.getToBranch(), toHead);
        List<CommitLogEntry> toEntriesReverseChronological = DatabaseAdapterUtil.takeUntilExcludeLast(this.readCommitLogStream(ctx, toHead), e -> e.getHash().equals((Object)commonAncestor)).collect(Collectors.toList());
        List<CommitLogEntry> commitsToMergeChronological = DatabaseAdapterUtil.takeUntilExcludeLast(this.readCommitLogStream(ctx, mergeParams.getMergeFromHash()), e -> e.getHash().equals((Object)commonAncestor)).collect(Collectors.toList());
        if (commitsToMergeChronological.isEmpty()) {
            throw new IllegalArgumentException(String.format("No hashes to merge from '%s' onto '%s' @ '%s'.", mergeParams.getMergeFromHash().asString(), mergeParams.getToBranch().getName(), toHead));
        }
        return this.mergeTransplantCommon(ctx, timeInMicros, toHead, branchCommits, newKeyLists, commitsToMergeChronological, toEntriesReverseChronological, mergeParams);
    }

    protected Hash transplantAttempt(OP_CONTEXT ctx, long timeInMicros, Hash targetHead, Consumer<Hash> branchCommits, Consumer<Hash> newKeyLists, TransplantParams transplantParams) throws ReferenceNotFoundException, ReferenceConflictException {
        if (transplantParams.getSequenceToTransplant().isEmpty()) {
            throw new IllegalArgumentException("No hashes to transplant given.");
        }
        ArrayList<CommitLogEntry> targetEntriesReverseChronological = new ArrayList<CommitLogEntry>();
        this.hashOnRef(ctx, targetHead, (NamedRef)transplantParams.getToBranch(), transplantParams.getExpectedHead(), targetEntriesReverseChronological::add);
        if (!targetEntriesReverseChronological.isEmpty() && transplantParams.getExpectedHead().isPresent() && ((CommitLogEntry)targetEntriesReverseChronological.get(0)).getHash().equals((Object)transplantParams.getExpectedHead().get())) {
            targetEntriesReverseChronological.remove(0);
        }
        int[] index = new int[]{transplantParams.getSequenceToTransplant().size() - 1};
        Hash lastHash = transplantParams.getSequenceToTransplant().get(transplantParams.getSequenceToTransplant().size() - 1);
        List<CommitLogEntry> commitsToTransplantChronological = DatabaseAdapterUtil.takeUntilExcludeLast(this.readCommitLogStream(ctx, lastHash), e -> {
            int n = index[0];
            index[0] = n - 1;
            int i = n;
            if (i == -1) {
                return true;
            }
            if (!e.getHash().equals((Object)transplantParams.getSequenceToTransplant().get(i))) {
                throw new IllegalArgumentException("Sequence of hashes is not contiguous.");
            }
            return false;
        }).collect(Collectors.toList());
        return this.mergeTransplantCommon(ctx, timeInMicros, targetHead, branchCommits, newKeyLists, commitsToTransplantChronological, targetEntriesReverseChronological, transplantParams);
    }

    protected Hash mergeTransplantCommon(OP_CONTEXT ctx, long timeInMicros, Hash toHead, Consumer<Hash> branchCommits, Consumer<Hash> newKeyLists, List<CommitLogEntry> commitsToMergeChronological, List<CommitLogEntry> toEntriesReverseChronological, MetadataRewriteParams params) throws ReferenceConflictException, ReferenceNotFoundException {
        Collections.reverse(toEntriesReverseChronological);
        Set<Key> keysTouchedOnTarget = this.collectModifiedKeys(toEntriesReverseChronological);
        Predicate<Key> skipCheckPredicate = k -> params.getMergeTypes().getOrDefault(k, params.getDefaultMergeType()).isSkipCheck();
        Predicate<Key> mergePredicate = k -> params.getMergeTypes().getOrDefault(k, params.getDefaultMergeType()).isMerge();
        keysTouchedOnTarget.removeIf(skipCheckPredicate);
        this.checkForKeyCollisions(ctx, toHead, keysTouchedOnTarget, commitsToMergeChronological);
        if (params.keepIndividualCommits() || commitsToMergeChronological.size() == 1) {
            toHead = this.copyCommits(ctx, timeInMicros, toHead, commitsToMergeChronological, newKeyLists, params.getUpdateCommitMetadata(), mergePredicate);
            commitsToMergeChronological.stream().map(CommitLogEntry::getHash).forEach(branchCommits);
            this.writeMultipleCommits(ctx, commitsToMergeChronological);
        } else {
            toHead = this.squashCommits(ctx, timeInMicros, toHead, commitsToMergeChronological, newKeyLists, params.getUpdateCommitMetadata(), mergePredicate);
        }
        return toHead;
    }

    protected Stream<Difference> buildDiff(OP_CONTEXT ctx, Hash from, Hash to, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        HashSet allKeys = new HashSet();
        try (Stream<Key> s = this.keysForCommitEntry(ctx, from, keyFilter).map(KeyListEntry::getKey);){
            s.forEach(allKeys::add);
        }
        s = this.keysForCommitEntry(ctx, to, keyFilter).map(KeyListEntry::getKey);
        try {
            s.forEach(allKeys::add);
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
        if (allKeys.isEmpty()) {
            return Stream.empty();
        }
        ArrayList<Key> allKeysList = new ArrayList<Key>(allKeys);
        Map<Key, ContentAndState<ByteString>> fromValues = this.fetchValues(ctx, from, allKeysList, keyFilter);
        Map<Key, ContentAndState<ByteString>> toValues = this.fetchValues(ctx, to, allKeysList, keyFilter);
        Function<ContentAndState, Optional> valToContent = cs -> cs != null ? Optional.of((ByteString)cs.getRefState()) : Optional.empty();
        return IntStream.range(0, allKeys.size()).mapToObj(allKeysList::get).map(k -> {
            Optional t;
            ContentAndState fromVal = (ContentAndState)fromValues.get(k);
            ContentAndState toVal = (ContentAndState)toValues.get(k);
            Optional f = (Optional)valToContent.apply(fromVal);
            if (f.equals(t = (Optional)valToContent.apply(toVal))) {
                return null;
            }
            Optional<ByteString> g = Optional.ofNullable(fromVal != null ? (ByteString)fromVal.getGlobalState() : (toVal != null ? (ByteString)toVal.getGlobalState() : null));
            return Difference.of(k, g, f, t);
        }).filter(Objects::nonNull);
    }

    protected Stream<ReferenceInfo<ByteString>> namedRefsFilterAndEnhance(OP_CONTEXT ctx, GetNamedRefsParams params, Hash defaultBranchHead, Stream<ReferenceInfo<ByteString>> refs) {
        refs = AbstractDatabaseAdapter.namedRefsMaybeFilter(params, refs);
        refs = this.namedRefsWithDefaultBranchRelatedInfo(ctx, params, refs, defaultBranchHead);
        refs = this.namedReferenceWithCommitMeta(ctx, params, refs);
        return refs;
    }

    protected static Stream<ReferenceInfo<ByteString>> namedRefsMaybeFilter(GetNamedRefsParams params, Stream<ReferenceInfo<ByteString>> refs) {
        if (params.getBranchRetrieveOptions().isRetrieve() && params.getTagRetrieveOptions().isRetrieve()) {
            return refs;
        }
        return refs.filter(ref -> AbstractDatabaseAdapter.namedRefsRetrieveOptionsForReference(params, (ReferenceInfo<ByteString>)ref).isRetrieve());
    }

    protected static boolean namedRefsRequiresBaseReference(GetNamedRefsParams params) {
        return AbstractDatabaseAdapter.namedRefsRequiresBaseReference(params.getBranchRetrieveOptions()) || AbstractDatabaseAdapter.namedRefsRequiresBaseReference(params.getTagRetrieveOptions());
    }

    protected static boolean namedRefsRequiresBaseReference(GetNamedRefsParams.RetrieveOptions retrieveOptions) {
        return retrieveOptions.isComputeAheadBehind() || retrieveOptions.isComputeCommonAncestor();
    }

    protected static boolean namedRefsAnyRetrieves(GetNamedRefsParams params) {
        return params.getBranchRetrieveOptions().isRetrieve() || params.getTagRetrieveOptions().isRetrieve();
    }

    protected static GetNamedRefsParams.RetrieveOptions namedRefsRetrieveOptionsForReference(GetNamedRefsParams params, ReferenceInfo<ByteString> ref) {
        return AbstractDatabaseAdapter.namedRefsRetrieveOptionsForReference(params, ref.getNamedRef());
    }

    protected static GetNamedRefsParams.RetrieveOptions namedRefsRetrieveOptionsForReference(GetNamedRefsParams params, NamedRef ref) {
        if (ref instanceof BranchName) {
            return params.getBranchRetrieveOptions();
        }
        if (ref instanceof TagName) {
            return params.getTagRetrieveOptions();
        }
        throw new IllegalArgumentException("ref must be either BranchName or TabName, but is " + ref);
    }

    protected Stream<ReferenceInfo<ByteString>> namedReferenceWithCommitMeta(OP_CONTEXT ctx, GetNamedRefsParams params, Stream<ReferenceInfo<ByteString>> refs) {
        return refs.map(ref -> {
            if (!AbstractDatabaseAdapter.namedRefsRetrieveOptionsForReference(params, (ReferenceInfo<ByteString>)ref).isRetrieveCommitMetaForHead()) {
                return ref;
            }
            CommitLogEntry logEntry = this.fetchFromCommitLog(ctx, ref.getHash());
            if (logEntry == null) {
                return ref;
            }
            return ImmutableReferenceInfo.builder().from(ref).headCommitMeta((Object)logEntry.getMetadata()).commitSeq(logEntry.getCommitSeq()).build();
        });
    }

    protected Stream<ReferenceInfo<ByteString>> namedRefsWithDefaultBranchRelatedInfo(OP_CONTEXT ctx, GetNamedRefsParams params, Stream<ReferenceInfo<ByteString>> refs, Hash defaultBranchHead) {
        if (defaultBranchHead == null) {
            return refs;
        }
        CommonAncestorState commonAncestorState = new CommonAncestorState(ctx, defaultBranchHead, params.getBranchRetrieveOptions().isComputeAheadBehind() || params.getTagRetrieveOptions().isComputeAheadBehind());
        return refs.map(ref -> {
            if (ref.getNamedRef().equals(params.getBaseReference())) {
                return ref;
            }
            GetNamedRefsParams.RetrieveOptions retrieveOptions = AbstractDatabaseAdapter.namedRefsRetrieveOptionsForReference(params, (ReferenceInfo<ByteString>)ref);
            ReferenceInfo updated = AbstractDatabaseAdapter.namedRefsRequiresBaseReference(retrieveOptions) ? this.findCommonAncestor(ctx, ref.getHash(), commonAncestorState, (Integer diffOnFrom, Hash hash) -> {
                ReferenceInfo newRef = ref;
                if (retrieveOptions.isComputeCommonAncestor()) {
                    newRef = newRef.withCommonAncestor(hash);
                }
                if (retrieveOptions.isComputeAheadBehind()) {
                    int behind = commonAncestorState.indexOf((Hash)hash);
                    ReferenceInfo.CommitsAheadBehind aheadBehind = ReferenceInfo.CommitsAheadBehind.of((int)diffOnFrom, (int)behind);
                    newRef = newRef.withAheadBehind(aheadBehind);
                }
                return newRef;
            }) : null;
            return updated != null ? updated : ref;
        });
    }

    protected Hash hashOnRef(OP_CONTEXT ctx, NamedRef reference, Optional<Hash> hashOnRef, Hash knownHead) throws ReferenceNotFoundException {
        return this.hashOnRef(ctx, knownHead, reference, hashOnRef, null);
    }

    protected Hash hashOnRef(OP_CONTEXT ctx, Hash knownHead, NamedRef ref, Optional<Hash> hashOnRef, Consumer<CommitLogEntry> commitLogVisitor) throws ReferenceNotFoundException {
        if (hashOnRef.isPresent()) {
            Hash suspect = hashOnRef.get();
            if (suspect.equals((Object)NO_ANCESTOR)) {
                if (commitLogVisitor != null) {
                    this.readCommitLogStream(ctx, knownHead).forEach(commitLogVisitor);
                }
                return suspect;
            }
            Stream<Hash> hashes = commitLogVisitor != null ? this.readCommitLogStream(ctx, knownHead).peek(commitLogVisitor).map(CommitLogEntry::getHash) : this.readCommitLogHashesStream(ctx, knownHead);
            if (hashes.noneMatch(arg_0 -> ((Hash)suspect).equals(arg_0))) {
                throw DatabaseAdapterUtil.hashNotFound(ref, suspect);
            }
            return suspect;
        }
        return knownHead;
    }

    protected void validateHashExists(OP_CONTEXT ctx, Hash hash) throws ReferenceNotFoundException {
        if (!NO_ANCESTOR.equals((Object)hash) && this.fetchFromCommitLog(ctx, hash) == null) {
            throw DatabaseAdapterUtil.referenceNotFound(hash);
        }
    }

    protected final CommitLogEntry fetchFromCommitLog(OP_CONTEXT ctx, Hash hash) {
        try (Traced ignore = Traced.trace("fetchFromCommitLog").tag(TAG_HASH, hash.asString());){
            CommitLogEntry commitLogEntry = this.doFetchFromCommitLog(ctx, hash);
            return commitLogEntry;
        }
    }

    protected abstract CommitLogEntry doFetchFromCommitLog(OP_CONTEXT var1, Hash var2);

    private List<CommitLogEntry> fetchMultipleFromCommitLog(OP_CONTEXT ctx, List<Hash> hashes) {
        if (hashes.isEmpty()) {
            return Collections.emptyList();
        }
        try (Traced ignore = Traced.trace("fetchPageFromCommitLog").tag(TAG_HASH, hashes.get(0).asString()).tag(TAG_COUNT, hashes.size());){
            List<CommitLogEntry> list = this.doFetchMultipleFromCommitLog(ctx, hashes);
            return list;
        }
    }

    private List<CommitLogEntry> fetchMultipleFromCommitLog(OP_CONTEXT ctx, List<Hash> hashes, @Nonnull Function<Hash, CommitLogEntry> inMemoryCommits) {
        ArrayList<CommitLogEntry> result = new ArrayList<CommitLogEntry>(hashes.size());
        ArrayList<Hash> remainingHashes = new ArrayList<Hash>(hashes.size());
        ArrayList<Integer> remainingIndexes = new ArrayList<Integer>(hashes.size());
        int idx = 0;
        for (Hash hash : hashes) {
            CommitLogEntry found = inMemoryCommits.apply(hash);
            if (found != null) {
                result.add(found);
            } else {
                result.add(null);
                remainingHashes.add(hash);
                remainingIndexes.add(idx);
            }
            ++idx;
        }
        if (!remainingHashes.isEmpty()) {
            List<CommitLogEntry> fromStorage = this.fetchMultipleFromCommitLog(ctx, remainingHashes);
            idx = 0;
            for (CommitLogEntry entry : fromStorage) {
                int i = (Integer)remainingIndexes.get(idx++);
                result.set(i, entry);
            }
        }
        return result;
    }

    protected abstract List<CommitLogEntry> doFetchMultipleFromCommitLog(OP_CONTEXT var1, List<Hash> var2);

    protected Stream<CommitLogEntry> readCommitLogStream(OP_CONTEXT ctx, Hash initialHash) throws ReferenceNotFoundException {
        Spliterator<CommitLogEntry> split = this.readCommitLog(ctx, initialHash, NO_IN_MEMORY_COMMITS);
        return StreamSupport.stream(split, false);
    }

    protected Stream<CommitLogEntry> readCommitLogStream(OP_CONTEXT ctx, Hash initialHash, @Nonnull Function<Hash, CommitLogEntry> inMemoryCommits) throws ReferenceNotFoundException {
        Spliterator<CommitLogEntry> split = this.readCommitLog(ctx, initialHash, inMemoryCommits);
        return StreamSupport.stream(split, false);
    }

    protected Spliterator<CommitLogEntry> readCommitLog(OP_CONTEXT ctx, Hash initialHash, @Nonnull Function<Hash, CommitLogEntry> inMemoryCommits) throws ReferenceNotFoundException {
        Preconditions.checkNotNull(inMemoryCommits, (Object)"in-memory commits cannot be null");
        if (NO_ANCESTOR.equals((Object)initialHash)) {
            return Spliterators.emptySpliterator();
        }
        CommitLogEntry initial = inMemoryCommits.apply(initialHash);
        if (initial == null) {
            initial = this.fetchFromCommitLog(ctx, initialHash);
        }
        if (initial == null) {
            throw DatabaseAdapterUtil.referenceNotFound(initialHash);
        }
        BiFunction<Object, List, List> fetcher = inMemoryCommits == NO_IN_MEMORY_COMMITS ? this::fetchMultipleFromCommitLog : (c, hashes) -> this.fetchMultipleFromCommitLog((OP_CONTEXT)c, (List<Hash>)hashes, inMemoryCommits);
        return this.logFetcher(ctx, initial, fetcher, CommitLogEntry::getParents);
    }

    protected Stream<Hash> readCommitLogHashesStream(OP_CONTEXT ctx, Hash initialHash) {
        Spliterator<Hash> split = this.readCommitLogHashes(ctx, initialHash);
        return StreamSupport.stream(split, false);
    }

    protected Spliterator<Hash> readCommitLogHashes(OP_CONTEXT ctx, Hash initialHash) {
        return this.logFetcher(ctx, initialHash, (c, hashes) -> hashes, hash -> {
            CommitLogEntry entry = this.fetchFromCommitLog(ctx, (Hash)hash);
            if (entry == null) {
                return Collections.emptyList();
            }
            return entry.getParents();
        });
    }

    protected <T> Spliterator<T> logFetcher(OP_CONTEXT ctx, T initial, BiFunction<OP_CONTEXT, List<Hash>, List<T>> fetcher, Function<T, List<Hash>> nextPage) {
        return this.logFetcherCommon(ctx, Collections.singletonList(initial), fetcher, nextPage);
    }

    protected <T> Spliterator<T> logFetcherWithPage(OP_CONTEXT ctx, List<Hash> initialPage, BiFunction<OP_CONTEXT, List<Hash>, List<T>> fetcher, Function<T, List<Hash>> nextPage) {
        return this.logFetcherCommon(ctx, fetcher.apply(ctx, initialPage), fetcher, nextPage);
    }

    private <T> Spliterator<T> logFetcherCommon(final OP_CONTEXT ctx, final List<T> initial, final BiFunction<OP_CONTEXT, List<Hash>, List<T>> fetcher, final Function<T, List<Hash>> nextPage) {
        return new Spliterators.AbstractSpliterator<T>(Long.MAX_VALUE, 0){
            private Iterator<T> currentBatch;
            private boolean eof;
            private T previous;

            @Override
            public boolean tryAdvance(Consumer<? super T> consumer) {
                if (this.eof) {
                    return false;
                }
                if (this.currentBatch == null) {
                    this.currentBatch = initial.iterator();
                } else if (!this.currentBatch.hasNext()) {
                    if (this.previous == null) {
                        this.eof = true;
                        return false;
                    }
                    List page = (List)nextPage.apply(this.previous);
                    this.previous = null;
                    if (!page.isEmpty()) {
                        this.currentBatch = ((List)fetcher.apply(ctx, page)).iterator();
                    } else {
                        this.eof = true;
                        return false;
                    }
                }
                Object v = this.currentBatch.next();
                if (v != null) {
                    consumer.accept(v);
                    this.previous = v;
                }
                return true;
            }
        };
    }

    protected CommitLogEntry buildIndividualCommit(OP_CONTEXT ctx, long timeInMicros, List<Hash> parentHashes, long commitSeq, ByteString commitMeta, Iterable<KeyWithBytes> puts, Iterable<Key> deletes, int currentKeyListDistance, Consumer<Hash> newKeyLists, @Nonnull Function<Hash, CommitLogEntry> inMemoryCommits) throws ReferenceNotFoundException {
        Hash commitHash = this.individualCommitHash(parentHashes, commitMeta, puts, deletes);
        int keyListDistance = currentKeyListDistance + 1;
        CommitLogEntry entry = CommitLogEntry.of(timeInMicros, commitHash, commitSeq, parentHashes, commitMeta, puts, deletes, keyListDistance, null, Collections.emptyList());
        if (keyListDistance >= this.config.getKeyListDistance()) {
            entry = this.buildKeyList(ctx, entry, newKeyLists, inMemoryCommits);
        }
        return entry;
    }

    protected Hash individualCommitHash(List<Hash> parentHashes, ByteString commitMeta, Iterable<KeyWithBytes> puts, Iterable<Key> deletes) {
        Hasher hasher = DatabaseAdapterUtil.newHasher();
        hasher.putLong(COMMIT_LOG_HASH_SEED);
        parentHashes.forEach(h -> hasher.putBytes(h.asBytes().asReadOnlyByteBuffer()));
        hasher.putBytes(commitMeta.asReadOnlyByteBuffer());
        puts.forEach(e -> {
            DatabaseAdapterUtil.hashKey(hasher, e.getKey());
            hasher.putString((CharSequence)e.getContentId().getId(), StandardCharsets.UTF_8);
            hasher.putBytes(e.getValue().asReadOnlyByteBuffer());
        });
        deletes.forEach(e -> DatabaseAdapterUtil.hashKey(hasher, e));
        return Hash.of((ByteString)UnsafeByteOperations.unsafeWrap((byte[])hasher.hash().asBytes()));
    }

    protected CommitLogEntry buildKeyList(OP_CONTEXT ctx, CommitLogEntry unwrittenEntry, Consumer<Hash> newKeyLists, @Nonnull Function<Hash, CommitLogEntry> inMemoryCommits) throws ReferenceNotFoundException {
        Hash startHash = unwrittenEntry.getParents().get(0);
        ImmutableCommitLogEntry.Builder newCommitEntry = ImmutableCommitLogEntry.builder().from(unwrittenEntry).keyListDistance(0);
        KeyListBuildState buildState = new KeyListBuildState(this.entitySize(unwrittenEntry), newCommitEntry);
        this.keysForCommitEntry(ctx, startHash, inMemoryCommits).forEach(keyWithType -> {
            int keyTypeSize = this.entitySize((KeyListEntry)keyWithType);
            if (buildState.embedded) {
                if (buildState.currentSize + keyTypeSize < this.config.getMaxKeyListSize()) {
                    buildState.addToEmbedded((KeyListEntry)keyWithType, keyTypeSize);
                } else {
                    buildState.embedded = false;
                    buildState.newKeyListEntity();
                    buildState.addToKeyListEntity((KeyListEntry)keyWithType, keyTypeSize);
                }
            } else {
                if (buildState.currentSize + keyTypeSize > this.config.getMaxKeyListSize()) {
                    buildState.finishKeyListEntity();
                    buildState.newKeyListEntity();
                }
                buildState.addToKeyListEntity((KeyListEntry)keyWithType, keyTypeSize);
            }
        });
        if (buildState.currentKeyList != null) {
            buildState.finishKeyListEntity();
        }
        buildState.newKeyListEntities.stream().map(KeyListEntity::getId).forEach(newKeyLists);
        if (!buildState.newKeyListEntities.isEmpty()) {
            this.writeKeyListEntities(ctx, buildState.newKeyListEntities);
        }
        return newCommitEntry.keyList(buildState.embeddedBuilder.build()).build();
    }

    protected abstract int entitySize(CommitLogEntry var1);

    protected abstract int entitySize(KeyListEntry var1);

    protected void checkForModifiedKeysBetweenExpectedAndCurrentCommit(OP_CONTEXT ctx, CommitParams commitParams, Hash branchHead, List<String> mismatches) throws ReferenceNotFoundException {
        Hash expectedHead;
        if (commitParams.getExpectedHead().isPresent() && !(expectedHead = commitParams.getExpectedHead().get()).equals((Object)branchHead)) {
            HashSet<Key> operationKeys = new HashSet<Key>();
            operationKeys.addAll(commitParams.getDeletes());
            operationKeys.addAll(commitParams.getUnchanged());
            commitParams.getPuts().stream().map(KeyWithBytes::getKey).forEach(operationKeys::add);
            boolean sinceSeen = this.checkConflictingKeysForCommit(ctx, branchHead, expectedHead, operationKeys, mismatches::add);
            if (!sinceSeen && !expectedHead.equals((Object)NO_ANCESTOR)) {
                throw DatabaseAdapterUtil.hashNotFound((NamedRef)commitParams.getToBranch(), expectedHead);
            }
        }
    }

    protected Stream<KeyListEntry> keysForCommitEntry(OP_CONTEXT ctx, Hash hash, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        return this.keysForCommitEntry(ctx, hash, NO_IN_MEMORY_COMMITS).filter(kt -> keyFilter.check(kt.getKey(), kt.getContentId(), kt.getType()));
    }

    protected Stream<KeyListEntry> keysForCommitEntry(OP_CONTEXT ctx, Hash hash, @Nonnull Function<Hash, CommitLogEntry> inMemoryCommits) throws ReferenceNotFoundException {
        HashSet seen = new HashSet();
        Stream<CommitLogEntry> log = this.readCommitLogStream(ctx, hash, inMemoryCommits);
        log = DatabaseAdapterUtil.takeUntilIncludeLast(log, e -> e.getKeyList() != null);
        return log.flatMap(e -> {
            seen.addAll(e.getDeletes());
            Stream<KeyListEntry> stream = e.getPuts().stream().filter(put -> seen.add(put.getKey())).map(put -> KeyListEntry.of(put.getKey(), put.getContentId(), put.getType(), e.getHash()));
            if (e.getKeyList() != null) {
                Stream<KeyListEntry> embedded = e.getKeyList().getKeys().stream().filter(kt -> seen.add(kt.getKey()));
                stream = Stream.concat(stream, embedded);
                if (!e.getKeyListsIds().isEmpty()) {
                    stream = Stream.concat(stream, Stream.of(e.getKeyListsIds()).flatMap(ids -> this.fetchKeyLists(ctx, (List<Hash>)ids)).map(KeyListEntity::getKeys).flatMap(keyList -> keyList.getKeys().stream()).filter(keyListEntry -> seen.add(keyListEntry.getKey())));
                }
            }
            return stream;
        });
    }

    protected Map<Key, ContentAndState<ByteString>> fetchValues(OP_CONTEXT ctx, Hash refHead, Collection<Key> keys, KeyFilterPredicate keyFilter) throws ReferenceNotFoundException {
        HashSet<Key> remainingKeys = new HashSet<Key>(keys);
        HashMap nonGlobal = new HashMap();
        HashMap keyToContentIds = new HashMap();
        HashSet<ContentId> contentIdsForGlobal = new HashSet<ContentId>();
        Consumer<CommitLogEntry> commitLogEntryHandler = entry -> {
            entry.getDeletes().forEach(remainingKeys::remove);
            for (KeyWithBytes put : entry.getPuts()) {
                if (!remainingKeys.remove(put.getKey()) || !keyFilter.check(put.getKey(), put.getContentId(), put.getType())) continue;
                nonGlobal.put(put.getKey(), put.getValue());
                keyToContentIds.put(put.getKey(), put.getContentId());
                if (!this.storeWorker.requiresGlobalState(put.getValue())) continue;
                contentIdsForGlobal.add(put.getContentId());
            }
        };
        try (Stream<CommitLogEntry> log = DatabaseAdapterUtil.takeUntilExcludeLast(this.readCommitLogStream(ctx, refHead), e -> remainingKeys.isEmpty());){
            log.forEach(entry -> {
                commitLogEntryHandler.accept((CommitLogEntry)entry);
                if (entry.getKeyList() != null) {
                    HashSet remainingInKeyList = new HashSet();
                    try (Stream<KeyList> keyLists = Stream.concat(Stream.of(entry.getKeyList()), this.fetchKeyLists(ctx, entry.getKeyListsIds()).map(KeyListEntity::getKeys));){
                        keyLists.flatMap(keyList -> keyList.getKeys().stream()).filter(keyListEntry -> remainingKeys.contains(keyListEntry.getKey())).forEach(remainingInKeyList::add);
                    }
                    if (!remainingInKeyList.isEmpty()) {
                        List<CommitLogEntry> commitLogEntries = this.fetchMultipleFromCommitLog(ctx, remainingInKeyList.stream().map(KeyListEntry::getCommitId).filter(Objects::nonNull).distinct().collect(Collectors.toList()));
                        commitLogEntries.forEach(commitLogEntryHandler);
                    }
                    remainingKeys.retainAll(remainingInKeyList.stream().map(KeyListEntry::getKey).collect(Collectors.toSet()));
                }
            });
        }
        Map globals = contentIdsForGlobal.isEmpty() ? Collections.emptyMap() : this.fetchGlobalStates(ctx, contentIdsForGlobal);
        return nonGlobal.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ContentAndState.of((ByteString)e.getValue(), (ByteString)globals.get(keyToContentIds.get(e.getKey())))));
    }

    protected final Map<ContentId, ByteString> fetchGlobalStates(OP_CONTEXT ctx, Set<ContentId> contentIds) throws ReferenceNotFoundException {
        try (Traced ignore = Traced.trace("fetchGlobalStates").tag(TAG_COUNT, contentIds.size());){
            Map<ContentId, ByteString> map = this.doFetchGlobalStates(ctx, contentIds);
            return map;
        }
    }

    protected abstract Map<ContentId, ByteString> doFetchGlobalStates(OP_CONTEXT var1, Set<ContentId> var2) throws ReferenceNotFoundException;

    protected final Stream<KeyListEntity> fetchKeyLists(OP_CONTEXT ctx, List<Hash> keyListsIds) {
        if (keyListsIds.isEmpty()) {
            return Stream.empty();
        }
        try (Traced ignore = Traced.trace("fetchKeyLists").tag(TAG_COUNT, keyListsIds.size());){
            Stream<KeyListEntity> stream = this.doFetchKeyLists(ctx, keyListsIds);
            return stream;
        }
    }

    protected abstract Stream<KeyListEntity> doFetchKeyLists(OP_CONTEXT var1, List<Hash> var2);

    protected final void writeIndividualCommit(OP_CONTEXT ctx, CommitLogEntry entry) throws ReferenceConflictException {
        try (Traced ignore = Traced.trace("writeIndividualCommit");){
            this.doWriteIndividualCommit(ctx, entry);
        }
    }

    protected abstract void doWriteIndividualCommit(OP_CONTEXT var1, CommitLogEntry var2) throws ReferenceConflictException;

    protected final void writeMultipleCommits(OP_CONTEXT ctx, List<CommitLogEntry> entries) throws ReferenceConflictException {
        try (Traced ignore = Traced.trace("writeMultipleCommits").tag(TAG_COUNT, entries.size());){
            this.doWriteMultipleCommits(ctx, entries);
        }
    }

    protected abstract void doWriteMultipleCommits(OP_CONTEXT var1, List<CommitLogEntry> var2) throws ReferenceConflictException;

    protected final void writeKeyListEntities(OP_CONTEXT ctx, List<KeyListEntity> newKeyListEntities) {
        try (Traced ignore = Traced.trace("writeKeyListEntities").tag(TAG_COUNT, newKeyListEntities.size());){
            this.doWriteKeyListEntities(ctx, newKeyListEntities);
        }
    }

    protected abstract void doWriteKeyListEntities(OP_CONTEXT var1, List<KeyListEntity> var2);

    protected boolean checkConflictingKeysForCommit(OP_CONTEXT ctx, Hash upToCommitIncluding, Hash sinceCommitExcluding, Set<Key> keys, Consumer<String> mismatches) throws ReferenceNotFoundException {
        boolean[] sinceSeen = new boolean[1];
        Stream<CommitLogEntry> log = this.readCommitLogStream(ctx, upToCommitIncluding);
        log = DatabaseAdapterUtil.takeUntilExcludeLast(log, e -> {
            if (e.getHash().equals((Object)sinceCommitExcluding)) {
                sinceSeen[0] = true;
                return true;
            }
            return false;
        });
        HashSet handled = new HashSet();
        log.forEach(e -> {
            e.getPuts().forEach(a -> {
                if (keys.contains(a.getKey()) && handled.add(a.getKey())) {
                    mismatches.accept(String.format("Key '%s' has conflicting put-operation from another commit.", a.getKey()));
                }
            });
            e.getDeletes().forEach(a -> {
                if (keys.contains(a) && handled.add(a)) {
                    mismatches.accept(String.format("Key '%s' has conflicting delete-operation from another commit.", a));
                }
            });
        });
        return sinceSeen[0];
    }

    protected Hash findCommonAncestor(OP_CONTEXT ctx, Hash from, NamedRef toBranch, Hash toHead) throws ReferenceConflictException {
        CommonAncestorState commonAncestorState = new CommonAncestorState(ctx, toHead, false);
        Hash commonAncestorHash = this.findCommonAncestor(ctx, from, commonAncestorState, (Integer dist, Hash hash) -> hash);
        if (commonAncestorHash == null) {
            throw new ReferenceConflictException(String.format("No common ancestor found for merge of '%s' into branch '%s'", from, toBranch.getName()));
        }
        return commonAncestorHash;
    }

    protected <R> R findCommonAncestor(OP_CONTEXT ctx, Hash from, CommonAncestorState state, BiFunction<Integer, Hash, R> result) {
        Iterator<Hash> fromLog = Spliterators.iterator(this.readCommitLogHashes(ctx, from));
        ArrayList<Hash> fromCommitHashes = new ArrayList<Hash>();
        block0: while (true) {
            boolean anyFetched = false;
            for (int i = 0; i < this.config.getParentsPerCommit(); ++i) {
                if (state.fetchNext()) {
                    anyFetched = true;
                }
                if (!fromLog.hasNext()) continue;
                fromCommitHashes.add(fromLog.next());
                anyFetched = true;
            }
            if (!anyFetched) {
                return null;
            }
            int diffOnFrom = 0;
            while (true) {
                if (diffOnFrom >= fromCommitHashes.size()) continue block0;
                Hash f = (Hash)fromCommitHashes.get(diffOnFrom);
                if (state.contains(f)) {
                    return result.apply(diffOnFrom, f);
                }
                ++diffOnFrom;
            }
            break;
        }
    }

    protected void checkForKeyCollisions(OP_CONTEXT ctx, Hash refHead, Set<Key> keysTouchedOnTarget, List<CommitLogEntry> commitsChronological) throws ReferenceConflictException, ReferenceNotFoundException {
        HashSet<Key> keyCollisions = new HashSet<Key>();
        for (int i = commitsChronological.size() - 1; i >= 0; --i) {
            CommitLogEntry sourceCommit = commitsChronological.get(i);
            Stream.concat(sourceCommit.getPuts().stream().map(KeyWithBytes::getKey), sourceCommit.getDeletes().stream()).filter(keysTouchedOnTarget::contains).forEach(keyCollisions::add);
        }
        if (!keyCollisions.isEmpty()) {
            this.removeKeyCollisionsForNamespaces(ctx, refHead, commitsChronological.get(commitsChronological.size() - 1).getHash(), keyCollisions);
            if (!keyCollisions.isEmpty()) {
                throw new ReferenceConflictException(String.format("The following keys have been changed in conflict: %s", keyCollisions.stream().map(k -> String.format("'%s'", k.toString())).collect(Collectors.joining(", "))));
            }
        }
    }

    private void removeKeyCollisionsForNamespaces(OP_CONTEXT ctx, Hash hashFromTarget, Hash hashFromSource, Set<Key> keyCollisions) throws ReferenceNotFoundException {
        Predicate<Map.Entry> isNamespace = e -> this.storeWorker.isNamespace((ByteString)((ContentAndState)e.getValue()).getRefState());
        Set<Key> namespacesOnTarget = this.fetchValues(ctx, hashFromTarget, keyCollisions, KeyFilterPredicate.ALLOW_ALL).entrySet().stream().filter(isNamespace).map(Map.Entry::getKey).collect(Collectors.toSet());
        Set<Key> intersection = this.fetchValues(ctx, hashFromSource, namespacesOnTarget, KeyFilterPredicate.ALLOW_ALL).entrySet().stream().filter(isNamespace).map(Map.Entry::getKey).collect(Collectors.toSet());
        intersection.forEach(keyCollisions::remove);
    }

    protected Set<Key> collectModifiedKeys(List<CommitLogEntry> commitsReverseChronological) {
        HashSet<Key> keysTouchedOnTarget = new HashSet<Key>();
        commitsReverseChronological.forEach(e -> {
            e.getPuts().stream().map(KeyWithBytes::getKey).forEach(keysTouchedOnTarget::add);
            e.getDeletes().forEach(keysTouchedOnTarget::remove);
        });
        return keysTouchedOnTarget;
    }

    protected Hash squashCommits(OP_CONTEXT ctx, long timeInMicros, Hash toHead, List<CommitLogEntry> commitsToMergeChronological, Consumer<Hash> newKeyLists, MetadataRewriter<ByteString> rewriteMetadata, Predicate<Key> includeKeyPredicate) throws ReferenceConflictException, ReferenceNotFoundException {
        int keyListDistance;
        long commitSeq;
        ArrayList<ByteString> commitMeta = new ArrayList<ByteString>();
        HashMap<Key, KeyWithBytes> puts = new HashMap<Key, KeyWithBytes>();
        HashSet<Key> deletes = new HashSet<Key>();
        for (int i = commitsToMergeChronological.size() - 1; i >= 0; --i) {
            CommitLogEntry source = commitsToMergeChronological.get(i);
            for (Key delete : source.getDeletes()) {
                if (!includeKeyPredicate.test(delete)) continue;
                deletes.add(delete);
                puts.remove(delete);
            }
            for (KeyWithBytes put : source.getPuts()) {
                if (!includeKeyPredicate.test(put.getKey())) continue;
                deletes.remove(put.getKey());
                puts.put(put.getKey(), put);
            }
            commitMeta.add(source.getMetadata());
        }
        if (puts.isEmpty() && deletes.isEmpty()) {
            return toHead;
        }
        ByteString newCommitMeta = (ByteString)rewriteMetadata.squash(commitMeta);
        CommitLogEntry targetHeadCommit = this.fetchFromCommitLog(ctx, toHead);
        int parentsPerCommit = this.config.getParentsPerCommit();
        ArrayList<Hash> parents = new ArrayList<Hash>(parentsPerCommit);
        parents.add(toHead);
        if (targetHeadCommit != null) {
            List<Hash> p = targetHeadCommit.getParents();
            parents.addAll(p.subList(0, Math.min(p.size(), parentsPerCommit - 1)));
            commitSeq = targetHeadCommit.getCommitSeq() + 1L;
            keyListDistance = targetHeadCommit.getKeyListDistance();
        } else {
            commitSeq = 1L;
            keyListDistance = 0;
        }
        CommitLogEntry squashedCommit = this.buildIndividualCommit(ctx, timeInMicros, parents, commitSeq, newCommitMeta, puts.values(), deletes, keyListDistance, newKeyLists, h -> null);
        this.writeIndividualCommit(ctx, squashedCommit);
        return squashedCommit.getHash();
    }

    protected Hash copyCommits(OP_CONTEXT ctx, long timeInMicros, Hash targetHead, List<CommitLogEntry> commitsChronological, Consumer<Hash> newKeyLists, MetadataRewriter<ByteString> rewriteMetadata, Predicate<Key> includeKeyPredicate) throws ReferenceNotFoundException {
        long commitSeq;
        int parentsPerCommit = this.config.getParentsPerCommit();
        ArrayList<Hash> parents = new ArrayList<Hash>(parentsPerCommit);
        CommitLogEntry targetHeadCommit = this.fetchFromCommitLog(ctx, targetHead);
        if (targetHeadCommit != null) {
            parents.addAll(targetHeadCommit.getParents());
            commitSeq = targetHeadCommit.getCommitSeq() + 1L;
        } else {
            commitSeq = 1L;
        }
        int keyListDistance = targetHeadCommit != null ? targetHeadCommit.getKeyListDistance() : 0;
        HashMap<Hash, CommitLogEntry> unwrittenCommits = new HashMap<Hash, CommitLogEntry>();
        int i = commitsChronological.size() - 1;
        while (i >= 0) {
            CommitLogEntry sourceCommit = commitsChronological.get(i);
            List<KeyWithBytes> puts = sourceCommit.getPuts().stream().filter(p -> includeKeyPredicate.test(p.getKey())).collect(Collectors.toList());
            List<Key> deletes = sourceCommit.getDeletes().stream().filter(includeKeyPredicate).collect(Collectors.toList());
            if (puts.isEmpty() && deletes.isEmpty()) {
                commitsChronological.remove(i);
            } else {
                while (parents.size() > parentsPerCommit - 1) {
                    parents.remove(parentsPerCommit - 1);
                }
                if (parents.isEmpty()) {
                    parents.add(targetHead);
                } else {
                    parents.add(0, targetHead);
                }
                ByteString updatedMetadata = (ByteString)rewriteMetadata.rewriteSingle((Object)sourceCommit.getMetadata());
                CommitLogEntry newEntry = this.buildIndividualCommit(ctx, timeInMicros, parents, commitSeq, updatedMetadata, puts, deletes, keyListDistance, newKeyLists, unwrittenCommits::get);
                keyListDistance = newEntry.getKeyListDistance();
                unwrittenCommits.put(newEntry.getHash(), newEntry);
                if (!newEntry.getHash().equals((Object)sourceCommit.getHash())) {
                    commitsChronological.set(i, newEntry);
                } else {
                    commitsChronological.remove(i);
                }
                targetHead = newEntry.getHash();
            }
            --i;
            ++commitSeq;
        }
        return targetHead;
    }

    protected void checkExpectedGlobalStates(OP_CONTEXT ctx, CommitParams commitParams, Consumer<String> mismatches) throws ReferenceNotFoundException {
        Map<ContentId, Optional<ByteString>> expectedStates = commitParams.getExpectedStates();
        if (expectedStates.isEmpty()) {
            return;
        }
        Map<ContentId, ByteString> globalStates = this.fetchGlobalStates(ctx, expectedStates.keySet());
        for (Map.Entry<ContentId, Optional<ByteString>> expectedState : expectedStates.entrySet()) {
            ByteString currentState = globalStates.get(expectedState.getKey());
            if (currentState == null) {
                if (!expectedState.getValue().isPresent()) continue;
                mismatches.accept(String.format("No current global-state for content-id '%s'.", expectedState.getKey()));
                continue;
            }
            if (!expectedState.getValue().isPresent()) {
                mismatches.accept(String.format("Global-state for content-id '%s' already exists.", expectedState.getKey()));
                continue;
            }
            if (currentState.equals((Object)expectedState.getValue().get())) continue;
            mismatches.accept(String.format("Mismatch in global-state for content-id '%s'.", expectedState.getKey()));
        }
    }

    protected final RefLog fetchFromRefLog(OP_CONTEXT ctx, Hash refLogId) {
        try (Traced ignore = Traced.trace("fetchFromRefLog").tag(TAG_HASH, refLogId != null ? refLogId.asString() : "HEAD");){
            RefLog refLog = this.doFetchFromRefLog(ctx, refLogId);
            return refLog;
        }
    }

    protected abstract RefLog doFetchFromRefLog(OP_CONTEXT var1, Hash var2);

    protected final List<RefLog> fetchPageFromRefLog(OP_CONTEXT ctx, List<Hash> hashes) {
        if (hashes.isEmpty()) {
            return Collections.emptyList();
        }
        try (Traced ignore = Traced.trace("fetchPageFromRefLog").tag(TAG_HASH, hashes.get(0).asString()).tag(TAG_COUNT, hashes.size());){
            List<RefLog> list = this.doFetchPageFromRefLog(ctx, hashes);
            return list;
        }
    }

    protected abstract List<RefLog> doFetchPageFromRefLog(OP_CONTEXT var1, List<Hash> var2);

    protected Stream<RefLog> readRefLogStream(OP_CONTEXT ctx, Hash initialHash) throws RefLogNotFoundException {
        Spliterator<RefLog> split = this.readRefLog(ctx, initialHash);
        return StreamSupport.stream(split, false);
    }

    protected Spliterator<RefLog> readRefLog(OP_CONTEXT ctx, Hash initialHash) throws RefLogNotFoundException {
        if (NO_ANCESTOR.equals((Object)initialHash)) {
            return Spliterators.emptySpliterator();
        }
        RefLog initial = this.fetchFromRefLog(ctx, initialHash);
        if (initial == null) {
            throw RefLogNotFoundException.forRefLogId((String)initialHash.asString());
        }
        return this.logFetcher(ctx, initial, this::fetchPageFromRefLog, RefLog::getParents);
    }

    protected void tryLoopStateCompletion(@Nonnull Boolean success, TryLoopState state) {
        DatabaseAdapterMetrics.tryLoopFinished(success != false ? "success" : "fail", state.getRetries(), state.getDuration(TimeUnit.NANOSECONDS));
    }

    protected final class CommonAncestorState {
        final Iterator<Hash> toLog;
        final List<Hash> toCommitHashesList;
        final Set<Hash> toCommitHashes = new HashSet<Hash>();

        public CommonAncestorState(OP_CONTEXT ctx, Hash toHead, boolean trackCount) {
            this.toLog = Spliterators.iterator(AbstractDatabaseAdapter.this.readCommitLogHashes(ctx, toHead));
            this.toCommitHashesList = trackCount ? new ArrayList() : null;
        }

        boolean fetchNext() {
            if (this.toLog.hasNext()) {
                Hash hash = this.toLog.next();
                this.toCommitHashes.add(hash);
                if (this.toCommitHashesList != null) {
                    this.toCommitHashesList.add(hash);
                }
                return true;
            }
            return false;
        }

        public boolean contains(Hash candidate) {
            return this.toCommitHashes.contains(candidate);
        }

        public int indexOf(Hash hash) {
            return this.toCommitHashesList.indexOf(hash);
        }
    }

    private static class KeyListBuildState {
        final ImmutableCommitLogEntry.Builder newCommitEntry;
        ImmutableKeyList.Builder embeddedBuilder = ImmutableKeyList.builder();
        ImmutableKeyList.Builder currentKeyList;
        List<KeyListEntity> newKeyListEntities = new ArrayList<KeyListEntity>();
        boolean embedded = true;
        int currentSize;

        KeyListBuildState(int initialSize, ImmutableCommitLogEntry.Builder newCommitEntry) {
            this.currentSize = initialSize;
            this.newCommitEntry = newCommitEntry;
        }

        void finishKeyListEntity() {
            Hash id = DatabaseAdapterUtil.randomHash();
            this.newKeyListEntities.add(KeyListEntity.of(id, this.currentKeyList.build()));
            this.newCommitEntry.addKeyListsIds(id);
        }

        void newKeyListEntity() {
            this.currentSize = 0;
            this.currentKeyList = ImmutableKeyList.builder();
        }

        void addToKeyListEntity(KeyListEntry keyListEntry, int keyTypeSize) {
            this.currentSize += keyTypeSize;
            this.currentKeyList.addKeys(keyListEntry);
        }

        void addToEmbedded(KeyListEntry keyListEntry, int keyTypeSize) {
            this.currentSize += keyTypeSize;
            this.embeddedBuilder.addKeys(keyListEntry);
        }
    }
}

