/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import java.time.Clock;
import org.immutables.value.Value;

public interface DatabaseAdapterConfig {
    public static final String DEFAULT_REPOSITORY_ID = "";
    public static final int DEFAULT_PARENTS_PER_COMMIT = 20;
    public static final int DEFAULT_KEY_LIST_DISTANCE = 20;
    public static final int DEFAULT_MAX_KEY_LIST_SIZE = 250000;
    public static final int DEFAULT_COMMIT_TIMEOUT = 500;
    public static final int DEFAULT_COMMIT_RETRIES = Integer.MAX_VALUE;
    public static final int DEFAULT_PARENTS_PER_REFLOG_ENTRY = 20;
    public static final int DEFAULT_RETRY_INITIAL_SLEEP_MILLIS_LOWER = 5;
    public static final int DEFAULT_RETRY_INITIAL_SLEEP_MILLIS_UPPER = 25;
    public static final int DEFAULT_RETRY_MAX_SLEEP_MILLIS = 75;

    @Value.Default
    default public String getRepositoryId() {
        return DEFAULT_REPOSITORY_ID;
    }

    @Value.Default
    default public int getParentsPerCommit() {
        return 20;
    }

    @Value.Default
    default public int getKeyListDistance() {
        return 20;
    }

    @Value.Default
    default public int getMaxKeyListSize() {
        return this.getDefaultMaxKeyListSize();
    }

    default public int getDefaultMaxKeyListSize() {
        return 250000;
    }

    @Value.Default
    default public long getCommitTimeout() {
        return 500L;
    }

    @Value.Default
    default public int getCommitRetries() {
        return Integer.MAX_VALUE;
    }

    @Value.Default
    default public long getRetryInitialSleepMillisLower() {
        return 5L;
    }

    @Value.Default
    default public long getRetryInitialSleepMillisUpper() {
        return 25L;
    }

    @Value.Default
    default public long getRetryMaxSleepMillis() {
        return 75L;
    }

    @Value.Default
    default public Clock getClock() {
        return Clock.systemUTC();
    }

    @Value.Default
    default public int getParentsPerRefLogEntry() {
        return 20;
    }
}

