package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.MergeType;
import org.projectnessie.versioned.MetadataRewriter;

/**
 * Immutable implementation of {@link TransplantParams}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTransplantParams.builder()}.
 */
@Generated(from = "TransplantParams", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTransplantParams
    implements TransplantParams {
  private final BranchName toBranch;
  private final Optional<Hash> expectedHead;
  private final boolean keepIndividualCommits;
  private final ImmutableMap<Key, MergeType> mergeTypes;
  private final MergeType defaultMergeType;
  private final MetadataRewriter<ByteString> updateCommitMetadata;
  private final ImmutableList<Hash> sequenceToTransplant;

  private ImmutableTransplantParams(ImmutableTransplantParams.Builder builder) {
    this.toBranch = builder.toBranch;
    this.mergeTypes = builder.mergeTypes.build();
    this.updateCommitMetadata = builder.updateCommitMetadata;
    this.sequenceToTransplant = builder.sequenceToTransplant.build();
    if (builder.expectedHead != null) {
      initShim.expectedHead(builder.expectedHead);
    }
    if (builder.keepIndividualCommitsIsSet()) {
      initShim.keepIndividualCommits(builder.keepIndividualCommits);
    }
    if (builder.defaultMergeType != null) {
      initShim.defaultMergeType(builder.defaultMergeType);
    }
    this.expectedHead = initShim.getExpectedHead();
    this.keepIndividualCommits = initShim.keepIndividualCommits();
    this.defaultMergeType = initShim.getDefaultMergeType();
    this.initShim = null;
  }

  private ImmutableTransplantParams(
      BranchName toBranch,
      Optional<Hash> expectedHead,
      boolean keepIndividualCommits,
      ImmutableMap<Key, MergeType> mergeTypes,
      MergeType defaultMergeType,
      MetadataRewriter<ByteString> updateCommitMetadata,
      ImmutableList<Hash> sequenceToTransplant) {
    this.toBranch = toBranch;
    this.expectedHead = expectedHead;
    this.keepIndividualCommits = keepIndividualCommits;
    this.mergeTypes = mergeTypes;
    this.defaultMergeType = defaultMergeType;
    this.updateCommitMetadata = updateCommitMetadata;
    this.sequenceToTransplant = sequenceToTransplant;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "TransplantParams", generator = "Immutables")
  private final class InitShim {
    private byte expectedHeadBuildStage = STAGE_UNINITIALIZED;
    private Optional<Hash> expectedHead;

    Optional<Hash> getExpectedHead() {
      if (expectedHeadBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (expectedHeadBuildStage == STAGE_UNINITIALIZED) {
        expectedHeadBuildStage = STAGE_INITIALIZING;
        this.expectedHead = Objects.requireNonNull(getExpectedHeadInitialize(), "expectedHead");
        expectedHeadBuildStage = STAGE_INITIALIZED;
      }
      return this.expectedHead;
    }

    void expectedHead(Optional<Hash> expectedHead) {
      this.expectedHead = expectedHead;
      expectedHeadBuildStage = STAGE_INITIALIZED;
    }

    private byte keepIndividualCommitsBuildStage = STAGE_UNINITIALIZED;
    private boolean keepIndividualCommits;

    boolean keepIndividualCommits() {
      if (keepIndividualCommitsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (keepIndividualCommitsBuildStage == STAGE_UNINITIALIZED) {
        keepIndividualCommitsBuildStage = STAGE_INITIALIZING;
        this.keepIndividualCommits = keepIndividualCommitsInitialize();
        keepIndividualCommitsBuildStage = STAGE_INITIALIZED;
      }
      return this.keepIndividualCommits;
    }

    void keepIndividualCommits(boolean keepIndividualCommits) {
      this.keepIndividualCommits = keepIndividualCommits;
      keepIndividualCommitsBuildStage = STAGE_INITIALIZED;
    }

    private byte defaultMergeTypeBuildStage = STAGE_UNINITIALIZED;
    private MergeType defaultMergeType;

    MergeType getDefaultMergeType() {
      if (defaultMergeTypeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (defaultMergeTypeBuildStage == STAGE_UNINITIALIZED) {
        defaultMergeTypeBuildStage = STAGE_INITIALIZING;
        this.defaultMergeType = Objects.requireNonNull(getDefaultMergeTypeInitialize(), "defaultMergeType");
        defaultMergeTypeBuildStage = STAGE_INITIALIZED;
      }
      return this.defaultMergeType;
    }

    void defaultMergeType(MergeType defaultMergeType) {
      this.defaultMergeType = defaultMergeType;
      defaultMergeTypeBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (expectedHeadBuildStage == STAGE_INITIALIZING) attributes.add("expectedHead");
      if (keepIndividualCommitsBuildStage == STAGE_INITIALIZING) attributes.add("keepIndividualCommits");
      if (defaultMergeTypeBuildStage == STAGE_INITIALIZING) attributes.add("defaultMergeType");
      return "Cannot build TransplantParams, attribute initializers form cycle " + attributes;
    }
  }

  private Optional<Hash> getExpectedHeadInitialize() {
    return TransplantParams.super.getExpectedHead();
  }

  private boolean keepIndividualCommitsInitialize() {
    return TransplantParams.super.keepIndividualCommits();
  }

  private MergeType getDefaultMergeTypeInitialize() {
    return TransplantParams.super.getDefaultMergeType();
  }

  /**
   * Branch to commit to. If {@link #getExpectedHead()} is present, the referenced branch's HEAD
   * must be equal to this hash.
   */
  @Override
  public BranchName getToBranch() {
    return toBranch;
  }

  /**
   *Expected HEAD of {@link #getToBranch()}. 
   */
  @Override
  public Optional<Hash> getExpectedHead() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getExpectedHead()
        : this.expectedHead;
  }

  /**
   *Whether to keep the individual commits and do not squash the commits to merge. 
   */
  @Override
  public boolean keepIndividualCommits() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.keepIndividualCommits()
        : this.keepIndividualCommits;
  }

  /**
   * @return The value of the {@code mergeTypes} attribute
   */
  @Override
  public ImmutableMap<Key, MergeType> getMergeTypes() {
    return mergeTypes;
  }

  /**
   * @return The value of the {@code defaultMergeType} attribute
   */
  @Override
  public MergeType getDefaultMergeType() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDefaultMergeType()
        : this.defaultMergeType;
  }

  /**
   *Function to rewrite the commit-metadata. 
   */
  @Override
  public MetadataRewriter<ByteString> getUpdateCommitMetadata() {
    return updateCommitMetadata;
  }

  /**
   *Commits to cherry-pick onto {@link #getToBranch()}. 
   */
  @Override
  public ImmutableList<Hash> getSequenceToTransplant() {
    return sequenceToTransplant;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransplantParams#getToBranch() toBranch} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toBranch
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransplantParams withToBranch(BranchName value) {
    if (this.toBranch == value) return this;
    BranchName newValue = Objects.requireNonNull(value, "toBranch");
    return new ImmutableTransplantParams(
        newValue,
        this.expectedHead,
        this.keepIndividualCommits,
        this.mergeTypes,
        this.defaultMergeType,
        this.updateCommitMetadata,
        this.sequenceToTransplant);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransplantParams#getExpectedHead() expectedHead} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expectedHead
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransplantParams withExpectedHead(Optional<Hash> value) {
    Optional<Hash> newValue = Objects.requireNonNull(value, "expectedHead");
    if (this.expectedHead.equals(newValue)) return this;
    return new ImmutableTransplantParams(
        this.toBranch,
        newValue,
        this.keepIndividualCommits,
        this.mergeTypes,
        this.defaultMergeType,
        this.updateCommitMetadata,
        this.sequenceToTransplant);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransplantParams#keepIndividualCommits() keepIndividualCommits} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keepIndividualCommits
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransplantParams withKeepIndividualCommits(boolean value) {
    if (this.keepIndividualCommits == value) return this;
    return new ImmutableTransplantParams(
        this.toBranch,
        this.expectedHead,
        value,
        this.mergeTypes,
        this.defaultMergeType,
        this.updateCommitMetadata,
        this.sequenceToTransplant);
  }

  /**
   * Copy the current immutable object by replacing the {@link TransplantParams#getMergeTypes() mergeTypes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the mergeTypes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTransplantParams withMergeTypes(Map<? extends Key, ? extends MergeType> entries) {
    if (this.mergeTypes == entries) return this;
    ImmutableMap<Key, MergeType> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableTransplantParams(
        this.toBranch,
        this.expectedHead,
        this.keepIndividualCommits,
        newValue,
        this.defaultMergeType,
        this.updateCommitMetadata,
        this.sequenceToTransplant);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransplantParams#getDefaultMergeType() defaultMergeType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultMergeType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransplantParams withDefaultMergeType(MergeType value) {
    MergeType newValue = Objects.requireNonNull(value, "defaultMergeType");
    if (this.defaultMergeType == newValue) return this;
    return new ImmutableTransplantParams(
        this.toBranch,
        this.expectedHead,
        this.keepIndividualCommits,
        this.mergeTypes,
        newValue,
        this.updateCommitMetadata,
        this.sequenceToTransplant);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransplantParams#getUpdateCommitMetadata() updateCommitMetadata} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updateCommitMetadata
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransplantParams withUpdateCommitMetadata(MetadataRewriter<ByteString> value) {
    if (this.updateCommitMetadata == value) return this;
    MetadataRewriter<ByteString> newValue = Objects.requireNonNull(value, "updateCommitMetadata");
    return new ImmutableTransplantParams(
        this.toBranch,
        this.expectedHead,
        this.keepIndividualCommits,
        this.mergeTypes,
        this.defaultMergeType,
        newValue,
        this.sequenceToTransplant);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TransplantParams#getSequenceToTransplant() sequenceToTransplant}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTransplantParams withSequenceToTransplant(Hash... elements) {
    ImmutableList<Hash> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTransplantParams(
        this.toBranch,
        this.expectedHead,
        this.keepIndividualCommits,
        this.mergeTypes,
        this.defaultMergeType,
        this.updateCommitMetadata,
        newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TransplantParams#getSequenceToTransplant() sequenceToTransplant}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of sequenceToTransplant elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTransplantParams withSequenceToTransplant(Iterable<? extends Hash> elements) {
    if (this.sequenceToTransplant == elements) return this;
    ImmutableList<Hash> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTransplantParams(
        this.toBranch,
        this.expectedHead,
        this.keepIndividualCommits,
        this.mergeTypes,
        this.defaultMergeType,
        this.updateCommitMetadata,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTransplantParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTransplantParams
        && equalTo(0, (ImmutableTransplantParams) another);
  }

  private boolean equalTo(int synthetic, ImmutableTransplantParams another) {
    return toBranch.equals(another.toBranch)
        && expectedHead.equals(another.expectedHead)
        && keepIndividualCommits == another.keepIndividualCommits
        && mergeTypes.equals(another.mergeTypes)
        && defaultMergeType.equals(another.defaultMergeType)
        && updateCommitMetadata.equals(another.updateCommitMetadata)
        && sequenceToTransplant.equals(another.sequenceToTransplant);
  }

  /**
   * Computes a hash code from attributes: {@code toBranch}, {@code expectedHead}, {@code keepIndividualCommits}, {@code mergeTypes}, {@code defaultMergeType}, {@code updateCommitMetadata}, {@code sequenceToTransplant}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + toBranch.hashCode();
    h += (h << 5) + expectedHead.hashCode();
    h += (h << 5) + Booleans.hashCode(keepIndividualCommits);
    h += (h << 5) + mergeTypes.hashCode();
    h += (h << 5) + defaultMergeType.hashCode();
    h += (h << 5) + updateCommitMetadata.hashCode();
    h += (h << 5) + sequenceToTransplant.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TransplantParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TransplantParams")
        .omitNullValues()
        .add("toBranch", toBranch)
        .add("expectedHead", expectedHead)
        .add("keepIndividualCommits", keepIndividualCommits)
        .add("mergeTypes", mergeTypes)
        .add("defaultMergeType", defaultMergeType)
        .add("updateCommitMetadata", updateCommitMetadata)
        .add("sequenceToTransplant", sequenceToTransplant)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link TransplantParams} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TransplantParams instance
   */
  public static ImmutableTransplantParams copyOf(TransplantParams instance) {
    if (instance instanceof ImmutableTransplantParams) {
      return (ImmutableTransplantParams) instance;
    }
    return ImmutableTransplantParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTransplantParams ImmutableTransplantParams}.
   * <pre>
   * ImmutableTransplantParams.builder()
   *    .toBranch(org.projectnessie.versioned.BranchName) // required {@link TransplantParams#getToBranch() toBranch}
   *    .expectedHead(Optional&amp;lt;org.projectnessie.versioned.Hash&amp;gt;) // optional {@link TransplantParams#getExpectedHead() expectedHead}
   *    .keepIndividualCommits(boolean) // optional {@link TransplantParams#keepIndividualCommits() keepIndividualCommits}
   *    .putMergeTypes|putAllMergeTypes(org.projectnessie.versioned.Key =&gt; org.projectnessie.versioned.MergeType) // {@link TransplantParams#getMergeTypes() mergeTypes} mappings
   *    .defaultMergeType(org.projectnessie.versioned.MergeType) // optional {@link TransplantParams#getDefaultMergeType() defaultMergeType}
   *    .updateCommitMetadata(org.projectnessie.versioned.MetadataRewriter&amp;lt;com.google.protobuf.ByteString&amp;gt;) // required {@link TransplantParams#getUpdateCommitMetadata() updateCommitMetadata}
   *    .addSequenceToTransplant|addAllSequenceToTransplant(org.projectnessie.versioned.Hash) // {@link TransplantParams#getSequenceToTransplant() sequenceToTransplant} elements
   *    .build();
   * </pre>
   * @return A new ImmutableTransplantParams builder
   */
  public static ImmutableTransplantParams.Builder builder() {
    return new ImmutableTransplantParams.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTransplantParams ImmutableTransplantParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TransplantParams", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TO_BRANCH = 0x1L;
    private static final long INIT_BIT_UPDATE_COMMIT_METADATA = 0x2L;
    private static final long OPT_BIT_KEEP_INDIVIDUAL_COMMITS = 0x1L;
    private long initBits = 0x3L;
    private long optBits;

    private @Nullable BranchName toBranch;
    private @Nullable Optional<Hash> expectedHead;
    private boolean keepIndividualCommits;
    private ImmutableMap.Builder<Key, MergeType> mergeTypes = ImmutableMap.builder();
    private @Nullable MergeType defaultMergeType;
    private @Nullable MetadataRewriter<ByteString> updateCommitMetadata;
    private ImmutableList.Builder<Hash> sequenceToTransplant = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.versioned.persist.adapter.TransplantParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TransplantParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.versioned.persist.adapter.MetadataRewriteParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MetadataRewriteParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.versioned.persist.adapter.ToBranchParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ToBranchParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof TransplantParams) {
        TransplantParams instance = (TransplantParams) object;
        if ((bits & 0x1L) == 0) {
          updateCommitMetadata(instance.getUpdateCommitMetadata());
          bits |= 0x1L;
        }
        addAllSequenceToTransplant(instance.getSequenceToTransplant());
        if ((bits & 0x2L) == 0) {
          expectedHead(instance.getExpectedHead());
          bits |= 0x2L;
        }
        if ((bits & 0x4L) == 0) {
          keepIndividualCommits(instance.keepIndividualCommits());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          toBranch(instance.getToBranch());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          defaultMergeType(instance.getDefaultMergeType());
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          putAllMergeTypes(instance.getMergeTypes());
          bits |= 0x20L;
        }
      }
      if (object instanceof MetadataRewriteParams) {
        MetadataRewriteParams instance = (MetadataRewriteParams) object;
        if ((bits & 0x1L) == 0) {
          updateCommitMetadata(instance.getUpdateCommitMetadata());
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          keepIndividualCommits(instance.keepIndividualCommits());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          toBranch(instance.getToBranch());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          defaultMergeType(instance.getDefaultMergeType());
          bits |= 0x10L;
        }
        if ((bits & 0x2L) == 0) {
          expectedHead(instance.getExpectedHead());
          bits |= 0x2L;
        }
        if ((bits & 0x20L) == 0) {
          putAllMergeTypes(instance.getMergeTypes());
          bits |= 0x20L;
        }
      }
      if (object instanceof ToBranchParams) {
        ToBranchParams instance = (ToBranchParams) object;
        if ((bits & 0x8L) == 0) {
          toBranch(instance.getToBranch());
          bits |= 0x8L;
        }
        if ((bits & 0x2L) == 0) {
          expectedHead(instance.getExpectedHead());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link TransplantParams#getToBranch() toBranch} attribute.
     * @param toBranch The value for toBranch 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder toBranch(BranchName toBranch) {
      this.toBranch = Objects.requireNonNull(toBranch, "toBranch");
      initBits &= ~INIT_BIT_TO_BRANCH;
      return this;
    }

    /**
     * Initializes the value for the {@link TransplantParams#getExpectedHead() expectedHead} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link TransplantParams#getExpectedHead() expectedHead}.</em>
     * @param expectedHead The value for expectedHead 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder expectedHead(Optional<Hash> expectedHead) {
      this.expectedHead = Objects.requireNonNull(expectedHead, "expectedHead");
      return this;
    }

    /**
     * Initializes the value for the {@link TransplantParams#keepIndividualCommits() keepIndividualCommits} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link TransplantParams#keepIndividualCommits() keepIndividualCommits}.</em>
     * @param keepIndividualCommits The value for keepIndividualCommits 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder keepIndividualCommits(boolean keepIndividualCommits) {
      this.keepIndividualCommits = keepIndividualCommits;
      optBits |= OPT_BIT_KEEP_INDIVIDUAL_COMMITS;
      return this;
    }

    /**
     * Put one entry to the {@link TransplantParams#getMergeTypes() mergeTypes} map.
     * @param key The key in the mergeTypes map
     * @param value The associated value in the mergeTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMergeTypes(Key key, MergeType value) {
      this.mergeTypes.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link TransplantParams#getMergeTypes() mergeTypes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMergeTypes(Map.Entry<? extends Key, ? extends MergeType> entry) {
      this.mergeTypes.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link TransplantParams#getMergeTypes() mergeTypes} map. Nulls are not permitted
     * @param entries The entries that will be added to the mergeTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mergeTypes(Map<? extends Key, ? extends MergeType> entries) {
      this.mergeTypes = ImmutableMap.builder();
      return putAllMergeTypes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link TransplantParams#getMergeTypes() mergeTypes} map. Nulls are not permitted
     * @param entries The entries that will be added to the mergeTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllMergeTypes(Map<? extends Key, ? extends MergeType> entries) {
      this.mergeTypes.putAll(entries);
      return this;
    }

    /**
     * Initializes the value for the {@link TransplantParams#getDefaultMergeType() defaultMergeType} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link TransplantParams#getDefaultMergeType() defaultMergeType}.</em>
     * @param defaultMergeType The value for defaultMergeType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultMergeType(MergeType defaultMergeType) {
      this.defaultMergeType = Objects.requireNonNull(defaultMergeType, "defaultMergeType");
      return this;
    }

    /**
     * Initializes the value for the {@link TransplantParams#getUpdateCommitMetadata() updateCommitMetadata} attribute.
     * @param updateCommitMetadata The value for updateCommitMetadata 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder updateCommitMetadata(MetadataRewriter<ByteString> updateCommitMetadata) {
      this.updateCommitMetadata = Objects.requireNonNull(updateCommitMetadata, "updateCommitMetadata");
      initBits &= ~INIT_BIT_UPDATE_COMMIT_METADATA;
      return this;
    }

    /**
     * Adds one element to {@link TransplantParams#getSequenceToTransplant() sequenceToTransplant} list.
     * @param element A sequenceToTransplant element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSequenceToTransplant(Hash element) {
      this.sequenceToTransplant.add(element);
      return this;
    }

    /**
     * Adds elements to {@link TransplantParams#getSequenceToTransplant() sequenceToTransplant} list.
     * @param elements An array of sequenceToTransplant elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSequenceToTransplant(Hash... elements) {
      this.sequenceToTransplant.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link TransplantParams#getSequenceToTransplant() sequenceToTransplant} list.
     * @param elements An iterable of sequenceToTransplant elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sequenceToTransplant(Iterable<? extends Hash> elements) {
      this.sequenceToTransplant = ImmutableList.builder();
      return addAllSequenceToTransplant(elements);
    }

    /**
     * Adds elements to {@link TransplantParams#getSequenceToTransplant() sequenceToTransplant} list.
     * @param elements An iterable of sequenceToTransplant elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSequenceToTransplant(Iterable<? extends Hash> elements) {
      this.sequenceToTransplant.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableTransplantParams ImmutableTransplantParams}.
     * @return An immutable instance of TransplantParams
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTransplantParams build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTransplantParams(this);
    }

    private boolean keepIndividualCommitsIsSet() {
      return (optBits & OPT_BIT_KEEP_INDIVIDUAL_COMMITS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TO_BRANCH) != 0) attributes.add("toBranch");
      if ((initBits & INIT_BIT_UPDATE_COMMIT_METADATA) != 0) attributes.add("updateCommitMetadata");
      return "Cannot build TransplantParams, some of required attributes are not set " + attributes;
    }
  }
}
