package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RepoMaintenanceParams}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRepoMaintenanceParams.builder()}.
 */
@Generated(from = "RepoMaintenanceParams", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRepoMaintenanceParams
    implements RepoMaintenanceParams {
  private final GlobalLogCompactionParams globalLogCompactionParams;

  private ImmutableRepoMaintenanceParams(GlobalLogCompactionParams globalLogCompactionParams) {
    this.globalLogCompactionParams = globalLogCompactionParams;
  }

  /**
   * @return The value of the {@code globalLogCompactionParams} attribute
   */
  @Override
  public GlobalLogCompactionParams getGlobalLogCompactionParams() {
    return globalLogCompactionParams;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepoMaintenanceParams#getGlobalLogCompactionParams() globalLogCompactionParams} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for globalLogCompactionParams
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepoMaintenanceParams withGlobalLogCompactionParams(GlobalLogCompactionParams value) {
    if (this.globalLogCompactionParams == value) return this;
    GlobalLogCompactionParams newValue = Objects.requireNonNull(value, "globalLogCompactionParams");
    return new ImmutableRepoMaintenanceParams(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRepoMaintenanceParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRepoMaintenanceParams
        && equalTo(0, (ImmutableRepoMaintenanceParams) another);
  }

  private boolean equalTo(int synthetic, ImmutableRepoMaintenanceParams another) {
    return globalLogCompactionParams.equals(another.globalLogCompactionParams);
  }

  /**
   * Computes a hash code from attributes: {@code globalLogCompactionParams}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + globalLogCompactionParams.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RepoMaintenanceParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RepoMaintenanceParams")
        .omitNullValues()
        .add("globalLogCompactionParams", globalLogCompactionParams)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link RepoMaintenanceParams} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RepoMaintenanceParams instance
   */
  public static ImmutableRepoMaintenanceParams copyOf(RepoMaintenanceParams instance) {
    if (instance instanceof ImmutableRepoMaintenanceParams) {
      return (ImmutableRepoMaintenanceParams) instance;
    }
    return ImmutableRepoMaintenanceParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRepoMaintenanceParams ImmutableRepoMaintenanceParams}.
   * <pre>
   * ImmutableRepoMaintenanceParams.builder()
   *    .globalLogCompactionParams(org.projectnessie.versioned.persist.adapter.GlobalLogCompactionParams) // required {@link RepoMaintenanceParams#getGlobalLogCompactionParams() globalLogCompactionParams}
   *    .build();
   * </pre>
   * @return A new ImmutableRepoMaintenanceParams builder
   */
  public static ImmutableRepoMaintenanceParams.Builder builder() {
    return new ImmutableRepoMaintenanceParams.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRepoMaintenanceParams ImmutableRepoMaintenanceParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RepoMaintenanceParams", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_GLOBAL_LOG_COMPACTION_PARAMS = 0x1L;
    private long initBits = 0x1L;

    private @Nullable GlobalLogCompactionParams globalLogCompactionParams;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RepoMaintenanceParams} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RepoMaintenanceParams instance) {
      Objects.requireNonNull(instance, "instance");
      globalLogCompactionParams(instance.getGlobalLogCompactionParams());
      return this;
    }

    /**
     * Initializes the value for the {@link RepoMaintenanceParams#getGlobalLogCompactionParams() globalLogCompactionParams} attribute.
     * @param globalLogCompactionParams The value for globalLogCompactionParams 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder globalLogCompactionParams(GlobalLogCompactionParams globalLogCompactionParams) {
      this.globalLogCompactionParams = Objects.requireNonNull(globalLogCompactionParams, "globalLogCompactionParams");
      initBits &= ~INIT_BIT_GLOBAL_LOG_COMPACTION_PARAMS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableRepoMaintenanceParams ImmutableRepoMaintenanceParams}.
     * @return An immutable instance of RepoMaintenanceParams
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRepoMaintenanceParams build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRepoMaintenanceParams(globalLogCompactionParams);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_GLOBAL_LOG_COMPACTION_PARAMS) != 0) attributes.add("globalLogCompactionParams");
      return "Cannot build RepoMaintenanceParams, some of required attributes are not set " + attributes;
    }
  }
}
