package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link KeyList}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableKeyList.builder()}.
 */
@Generated(from = "KeyList", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableKeyList implements KeyList {
  private final ImmutableList<KeyListEntry> keys;

  private ImmutableKeyList(
      ImmutableList<KeyListEntry> keys) {
    this.keys = keys;
  }

  /**
   * @return The value of the {@code keys} attribute
   */
  @Override
  public ImmutableList<KeyListEntry> getKeys() {
    return keys;
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link KeyList#getKeys() keys}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableKeyList withKeys(KeyListEntry... elements) {
    ImmutableList<KeyListEntry> newValue = ImmutableList.copyOf(elements);
    return new ImmutableKeyList(newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link KeyList#getKeys() keys}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of keys elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableKeyList withKeys(Iterable<? extends KeyListEntry> elements) {
    if (this.keys == elements) return this;
    ImmutableList<KeyListEntry> newValue = ImmutableList.copyOf(elements);
    return new ImmutableKeyList(newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableKeyList} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableKeyList
        && equalTo(0, (ImmutableKeyList) another);
  }

  private boolean equalTo(int synthetic, ImmutableKeyList another) {
    return keys.equals(another.keys);
  }

  /**
   * Computes a hash code from attributes: {@code keys}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + keys.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code KeyList} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("KeyList")
        .omitNullValues()
        .add("keys", keys)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link KeyList} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable KeyList instance
   */
  public static ImmutableKeyList copyOf(KeyList instance) {
    if (instance instanceof ImmutableKeyList) {
      return (ImmutableKeyList) instance;
    }
    return ImmutableKeyList.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableKeyList ImmutableKeyList}.
   * <pre>
   * ImmutableKeyList.builder()
   *    .addKeys|addAllKeys(org.projectnessie.versioned.persist.adapter.KeyListEntry) // {@link KeyList#getKeys() keys} elements
   *    .build();
   * </pre>
   * @return A new ImmutableKeyList builder
   */
  public static ImmutableKeyList.Builder builder() {
    return new ImmutableKeyList.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableKeyList ImmutableKeyList}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "KeyList", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private ImmutableList.Builder<KeyListEntry> keys = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code KeyList} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(KeyList instance) {
      Objects.requireNonNull(instance, "instance");
      addAllKeys(instance.getKeys());
      return this;
    }

    /**
     * Adds one element to {@link KeyList#getKeys() keys} list.
     * @param element A keys element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addKeys(KeyListEntry element) {
      this.keys.add(element);
      return this;
    }

    /**
     * Adds elements to {@link KeyList#getKeys() keys} list.
     * @param elements An array of keys elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addKeys(KeyListEntry... elements) {
      this.keys.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link KeyList#getKeys() keys} list.
     * @param elements An iterable of keys elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder keys(Iterable<? extends KeyListEntry> elements) {
      this.keys = ImmutableList.builder();
      return addAllKeys(elements);
    }

    /**
     * Adds elements to {@link KeyList#getKeys() keys} list.
     * @param elements An iterable of keys elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllKeys(Iterable<? extends KeyListEntry> elements) {
      this.keys.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableKeyList ImmutableKeyList}.
     * @return An immutable instance of KeyList
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableKeyList build() {
      return new ImmutableKeyList(keys.build());
    }
  }
}
