package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.MergeType;
import org.projectnessie.versioned.MetadataRewriter;

/**
 * Immutable implementation of {@link MergeParams}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMergeParams.builder()}.
 */
@Generated(from = "MergeParams", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMergeParams implements MergeParams {
  private final BranchName toBranch;
  private final Optional<Hash> expectedHead;
  private final boolean keepIndividualCommits;
  private final ImmutableMap<Key, MergeType> mergeTypes;
  private final MergeType defaultMergeType;
  private final MetadataRewriter<ByteString> updateCommitMetadata;
  private final Hash mergeFromHash;

  private ImmutableMergeParams(ImmutableMergeParams.Builder builder) {
    this.toBranch = builder.toBranch;
    this.mergeTypes = builder.mergeTypes.build();
    this.updateCommitMetadata = builder.updateCommitMetadata;
    this.mergeFromHash = builder.mergeFromHash;
    if (builder.expectedHead != null) {
      initShim.expectedHead(builder.expectedHead);
    }
    if (builder.keepIndividualCommitsIsSet()) {
      initShim.keepIndividualCommits(builder.keepIndividualCommits);
    }
    if (builder.defaultMergeType != null) {
      initShim.defaultMergeType(builder.defaultMergeType);
    }
    this.expectedHead = initShim.getExpectedHead();
    this.keepIndividualCommits = initShim.keepIndividualCommits();
    this.defaultMergeType = initShim.getDefaultMergeType();
    this.initShim = null;
  }

  private ImmutableMergeParams(
      BranchName toBranch,
      Optional<Hash> expectedHead,
      boolean keepIndividualCommits,
      ImmutableMap<Key, MergeType> mergeTypes,
      MergeType defaultMergeType,
      MetadataRewriter<ByteString> updateCommitMetadata,
      Hash mergeFromHash) {
    this.toBranch = toBranch;
    this.expectedHead = expectedHead;
    this.keepIndividualCommits = keepIndividualCommits;
    this.mergeTypes = mergeTypes;
    this.defaultMergeType = defaultMergeType;
    this.updateCommitMetadata = updateCommitMetadata;
    this.mergeFromHash = mergeFromHash;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "MergeParams", generator = "Immutables")
  private final class InitShim {
    private byte expectedHeadBuildStage = STAGE_UNINITIALIZED;
    private Optional<Hash> expectedHead;

    Optional<Hash> getExpectedHead() {
      if (expectedHeadBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (expectedHeadBuildStage == STAGE_UNINITIALIZED) {
        expectedHeadBuildStage = STAGE_INITIALIZING;
        this.expectedHead = Objects.requireNonNull(getExpectedHeadInitialize(), "expectedHead");
        expectedHeadBuildStage = STAGE_INITIALIZED;
      }
      return this.expectedHead;
    }

    void expectedHead(Optional<Hash> expectedHead) {
      this.expectedHead = expectedHead;
      expectedHeadBuildStage = STAGE_INITIALIZED;
    }

    private byte keepIndividualCommitsBuildStage = STAGE_UNINITIALIZED;
    private boolean keepIndividualCommits;

    boolean keepIndividualCommits() {
      if (keepIndividualCommitsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (keepIndividualCommitsBuildStage == STAGE_UNINITIALIZED) {
        keepIndividualCommitsBuildStage = STAGE_INITIALIZING;
        this.keepIndividualCommits = keepIndividualCommitsInitialize();
        keepIndividualCommitsBuildStage = STAGE_INITIALIZED;
      }
      return this.keepIndividualCommits;
    }

    void keepIndividualCommits(boolean keepIndividualCommits) {
      this.keepIndividualCommits = keepIndividualCommits;
      keepIndividualCommitsBuildStage = STAGE_INITIALIZED;
    }

    private byte defaultMergeTypeBuildStage = STAGE_UNINITIALIZED;
    private MergeType defaultMergeType;

    MergeType getDefaultMergeType() {
      if (defaultMergeTypeBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (defaultMergeTypeBuildStage == STAGE_UNINITIALIZED) {
        defaultMergeTypeBuildStage = STAGE_INITIALIZING;
        this.defaultMergeType = Objects.requireNonNull(getDefaultMergeTypeInitialize(), "defaultMergeType");
        defaultMergeTypeBuildStage = STAGE_INITIALIZED;
      }
      return this.defaultMergeType;
    }

    void defaultMergeType(MergeType defaultMergeType) {
      this.defaultMergeType = defaultMergeType;
      defaultMergeTypeBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (expectedHeadBuildStage == STAGE_INITIALIZING) attributes.add("expectedHead");
      if (keepIndividualCommitsBuildStage == STAGE_INITIALIZING) attributes.add("keepIndividualCommits");
      if (defaultMergeTypeBuildStage == STAGE_INITIALIZING) attributes.add("defaultMergeType");
      return "Cannot build MergeParams, attribute initializers form cycle " + attributes;
    }
  }

  private Optional<Hash> getExpectedHeadInitialize() {
    return MergeParams.super.getExpectedHead();
  }

  private boolean keepIndividualCommitsInitialize() {
    return MergeParams.super.keepIndividualCommits();
  }

  private MergeType getDefaultMergeTypeInitialize() {
    return MergeParams.super.getDefaultMergeType();
  }

  /**
   * Branch to commit to. If {@link #getExpectedHead()} is present, the referenced branch's HEAD
   * must be equal to this hash.
   */
  @Override
  public BranchName getToBranch() {
    return toBranch;
  }

  /**
   *Expected HEAD of {@link #getToBranch()}. 
   */
  @Override
  public Optional<Hash> getExpectedHead() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getExpectedHead()
        : this.expectedHead;
  }

  /**
   *Whether to keep the individual commits and do not squash the commits to merge. 
   */
  @Override
  public boolean keepIndividualCommits() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.keepIndividualCommits()
        : this.keepIndividualCommits;
  }

  /**
   * @return The value of the {@code mergeTypes} attribute
   */
  @Override
  public ImmutableMap<Key, MergeType> getMergeTypes() {
    return mergeTypes;
  }

  /**
   * @return The value of the {@code defaultMergeType} attribute
   */
  @Override
  public MergeType getDefaultMergeType() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.getDefaultMergeType()
        : this.defaultMergeType;
  }

  /**
   *Function to rewrite the commit-metadata. 
   */
  @Override
  public MetadataRewriter<ByteString> getUpdateCommitMetadata() {
    return updateCommitMetadata;
  }

  /**
   *Commit-hash to start reading commits from. 
   */
  @Override
  public Hash getMergeFromHash() {
    return mergeFromHash;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MergeParams#getToBranch() toBranch} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toBranch
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMergeParams withToBranch(BranchName value) {
    if (this.toBranch == value) return this;
    BranchName newValue = Objects.requireNonNull(value, "toBranch");
    return new ImmutableMergeParams(
        newValue,
        this.expectedHead,
        this.keepIndividualCommits,
        this.mergeTypes,
        this.defaultMergeType,
        this.updateCommitMetadata,
        this.mergeFromHash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MergeParams#getExpectedHead() expectedHead} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expectedHead
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMergeParams withExpectedHead(Optional<Hash> value) {
    Optional<Hash> newValue = Objects.requireNonNull(value, "expectedHead");
    if (this.expectedHead.equals(newValue)) return this;
    return new ImmutableMergeParams(
        this.toBranch,
        newValue,
        this.keepIndividualCommits,
        this.mergeTypes,
        this.defaultMergeType,
        this.updateCommitMetadata,
        this.mergeFromHash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MergeParams#keepIndividualCommits() keepIndividualCommits} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keepIndividualCommits
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMergeParams withKeepIndividualCommits(boolean value) {
    if (this.keepIndividualCommits == value) return this;
    return new ImmutableMergeParams(
        this.toBranch,
        this.expectedHead,
        value,
        this.mergeTypes,
        this.defaultMergeType,
        this.updateCommitMetadata,
        this.mergeFromHash);
  }

  /**
   * Copy the current immutable object by replacing the {@link MergeParams#getMergeTypes() mergeTypes} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the mergeTypes map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableMergeParams withMergeTypes(Map<? extends Key, ? extends MergeType> entries) {
    if (this.mergeTypes == entries) return this;
    ImmutableMap<Key, MergeType> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableMergeParams(
        this.toBranch,
        this.expectedHead,
        this.keepIndividualCommits,
        newValue,
        this.defaultMergeType,
        this.updateCommitMetadata,
        this.mergeFromHash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MergeParams#getDefaultMergeType() defaultMergeType} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for defaultMergeType
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMergeParams withDefaultMergeType(MergeType value) {
    MergeType newValue = Objects.requireNonNull(value, "defaultMergeType");
    if (this.defaultMergeType == newValue) return this;
    return new ImmutableMergeParams(
        this.toBranch,
        this.expectedHead,
        this.keepIndividualCommits,
        this.mergeTypes,
        newValue,
        this.updateCommitMetadata,
        this.mergeFromHash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MergeParams#getUpdateCommitMetadata() updateCommitMetadata} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updateCommitMetadata
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMergeParams withUpdateCommitMetadata(MetadataRewriter<ByteString> value) {
    if (this.updateCommitMetadata == value) return this;
    MetadataRewriter<ByteString> newValue = Objects.requireNonNull(value, "updateCommitMetadata");
    return new ImmutableMergeParams(
        this.toBranch,
        this.expectedHead,
        this.keepIndividualCommits,
        this.mergeTypes,
        this.defaultMergeType,
        newValue,
        this.mergeFromHash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MergeParams#getMergeFromHash() mergeFromHash} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mergeFromHash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMergeParams withMergeFromHash(Hash value) {
    if (this.mergeFromHash == value) return this;
    Hash newValue = Objects.requireNonNull(value, "mergeFromHash");
    return new ImmutableMergeParams(
        this.toBranch,
        this.expectedHead,
        this.keepIndividualCommits,
        this.mergeTypes,
        this.defaultMergeType,
        this.updateCommitMetadata,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMergeParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMergeParams
        && equalTo(0, (ImmutableMergeParams) another);
  }

  private boolean equalTo(int synthetic, ImmutableMergeParams another) {
    return toBranch.equals(another.toBranch)
        && expectedHead.equals(another.expectedHead)
        && keepIndividualCommits == another.keepIndividualCommits
        && mergeTypes.equals(another.mergeTypes)
        && defaultMergeType.equals(another.defaultMergeType)
        && updateCommitMetadata.equals(another.updateCommitMetadata)
        && mergeFromHash.equals(another.mergeFromHash);
  }

  /**
   * Computes a hash code from attributes: {@code toBranch}, {@code expectedHead}, {@code keepIndividualCommits}, {@code mergeTypes}, {@code defaultMergeType}, {@code updateCommitMetadata}, {@code mergeFromHash}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + toBranch.hashCode();
    h += (h << 5) + expectedHead.hashCode();
    h += (h << 5) + Booleans.hashCode(keepIndividualCommits);
    h += (h << 5) + mergeTypes.hashCode();
    h += (h << 5) + defaultMergeType.hashCode();
    h += (h << 5) + updateCommitMetadata.hashCode();
    h += (h << 5) + mergeFromHash.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MergeParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MergeParams")
        .omitNullValues()
        .add("toBranch", toBranch)
        .add("expectedHead", expectedHead)
        .add("keepIndividualCommits", keepIndividualCommits)
        .add("mergeTypes", mergeTypes)
        .add("defaultMergeType", defaultMergeType)
        .add("updateCommitMetadata", updateCommitMetadata)
        .add("mergeFromHash", mergeFromHash)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link MergeParams} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MergeParams instance
   */
  public static ImmutableMergeParams copyOf(MergeParams instance) {
    if (instance instanceof ImmutableMergeParams) {
      return (ImmutableMergeParams) instance;
    }
    return ImmutableMergeParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMergeParams ImmutableMergeParams}.
   * <pre>
   * ImmutableMergeParams.builder()
   *    .toBranch(org.projectnessie.versioned.BranchName) // required {@link MergeParams#getToBranch() toBranch}
   *    .expectedHead(Optional&amp;lt;org.projectnessie.versioned.Hash&amp;gt;) // optional {@link MergeParams#getExpectedHead() expectedHead}
   *    .keepIndividualCommits(boolean) // optional {@link MergeParams#keepIndividualCommits() keepIndividualCommits}
   *    .putMergeTypes|putAllMergeTypes(org.projectnessie.versioned.Key =&gt; org.projectnessie.versioned.MergeType) // {@link MergeParams#getMergeTypes() mergeTypes} mappings
   *    .defaultMergeType(org.projectnessie.versioned.MergeType) // optional {@link MergeParams#getDefaultMergeType() defaultMergeType}
   *    .updateCommitMetadata(org.projectnessie.versioned.MetadataRewriter&amp;lt;com.google.protobuf.ByteString&amp;gt;) // required {@link MergeParams#getUpdateCommitMetadata() updateCommitMetadata}
   *    .mergeFromHash(org.projectnessie.versioned.Hash) // required {@link MergeParams#getMergeFromHash() mergeFromHash}
   *    .build();
   * </pre>
   * @return A new ImmutableMergeParams builder
   */
  public static ImmutableMergeParams.Builder builder() {
    return new ImmutableMergeParams.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMergeParams ImmutableMergeParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MergeParams", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TO_BRANCH = 0x1L;
    private static final long INIT_BIT_UPDATE_COMMIT_METADATA = 0x2L;
    private static final long INIT_BIT_MERGE_FROM_HASH = 0x4L;
    private static final long OPT_BIT_KEEP_INDIVIDUAL_COMMITS = 0x1L;
    private long initBits = 0x7L;
    private long optBits;

    private @Nullable BranchName toBranch;
    private @Nullable Optional<Hash> expectedHead;
    private boolean keepIndividualCommits;
    private ImmutableMap.Builder<Key, MergeType> mergeTypes = ImmutableMap.builder();
    private @Nullable MergeType defaultMergeType;
    private @Nullable MetadataRewriter<ByteString> updateCommitMetadata;
    private @Nullable Hash mergeFromHash;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.versioned.persist.adapter.MergeParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MergeParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.versioned.persist.adapter.MetadataRewriteParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MetadataRewriteParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.versioned.persist.adapter.ToBranchParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ToBranchParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof MergeParams) {
        MergeParams instance = (MergeParams) object;
        if ((bits & 0x1L) == 0) {
          updateCommitMetadata(instance.getUpdateCommitMetadata());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          expectedHead(instance.getExpectedHead());
          bits |= 0x2L;
        }
        mergeFromHash(instance.getMergeFromHash());
        if ((bits & 0x4L) == 0) {
          keepIndividualCommits(instance.keepIndividualCommits());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          toBranch(instance.getToBranch());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          defaultMergeType(instance.getDefaultMergeType());
          bits |= 0x10L;
        }
        if ((bits & 0x20L) == 0) {
          putAllMergeTypes(instance.getMergeTypes());
          bits |= 0x20L;
        }
      }
      if (object instanceof MetadataRewriteParams) {
        MetadataRewriteParams instance = (MetadataRewriteParams) object;
        if ((bits & 0x1L) == 0) {
          updateCommitMetadata(instance.getUpdateCommitMetadata());
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          keepIndividualCommits(instance.keepIndividualCommits());
          bits |= 0x4L;
        }
        if ((bits & 0x8L) == 0) {
          toBranch(instance.getToBranch());
          bits |= 0x8L;
        }
        if ((bits & 0x10L) == 0) {
          defaultMergeType(instance.getDefaultMergeType());
          bits |= 0x10L;
        }
        if ((bits & 0x2L) == 0) {
          expectedHead(instance.getExpectedHead());
          bits |= 0x2L;
        }
        if ((bits & 0x20L) == 0) {
          putAllMergeTypes(instance.getMergeTypes());
          bits |= 0x20L;
        }
      }
      if (object instanceof ToBranchParams) {
        ToBranchParams instance = (ToBranchParams) object;
        if ((bits & 0x8L) == 0) {
          toBranch(instance.getToBranch());
          bits |= 0x8L;
        }
        if ((bits & 0x2L) == 0) {
          expectedHead(instance.getExpectedHead());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link MergeParams#getToBranch() toBranch} attribute.
     * @param toBranch The value for toBranch 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder toBranch(BranchName toBranch) {
      this.toBranch = Objects.requireNonNull(toBranch, "toBranch");
      initBits &= ~INIT_BIT_TO_BRANCH;
      return this;
    }

    /**
     * Initializes the value for the {@link MergeParams#getExpectedHead() expectedHead} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MergeParams#getExpectedHead() expectedHead}.</em>
     * @param expectedHead The value for expectedHead 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder expectedHead(Optional<Hash> expectedHead) {
      this.expectedHead = Objects.requireNonNull(expectedHead, "expectedHead");
      return this;
    }

    /**
     * Initializes the value for the {@link MergeParams#keepIndividualCommits() keepIndividualCommits} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MergeParams#keepIndividualCommits() keepIndividualCommits}.</em>
     * @param keepIndividualCommits The value for keepIndividualCommits 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder keepIndividualCommits(boolean keepIndividualCommits) {
      this.keepIndividualCommits = keepIndividualCommits;
      optBits |= OPT_BIT_KEEP_INDIVIDUAL_COMMITS;
      return this;
    }

    /**
     * Put one entry to the {@link MergeParams#getMergeTypes() mergeTypes} map.
     * @param key The key in the mergeTypes map
     * @param value The associated value in the mergeTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMergeTypes(Key key, MergeType value) {
      this.mergeTypes.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link MergeParams#getMergeTypes() mergeTypes} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putMergeTypes(Map.Entry<? extends Key, ? extends MergeType> entry) {
      this.mergeTypes.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link MergeParams#getMergeTypes() mergeTypes} map. Nulls are not permitted
     * @param entries The entries that will be added to the mergeTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mergeTypes(Map<? extends Key, ? extends MergeType> entries) {
      this.mergeTypes = ImmutableMap.builder();
      return putAllMergeTypes(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link MergeParams#getMergeTypes() mergeTypes} map. Nulls are not permitted
     * @param entries The entries that will be added to the mergeTypes map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllMergeTypes(Map<? extends Key, ? extends MergeType> entries) {
      this.mergeTypes.putAll(entries);
      return this;
    }

    /**
     * Initializes the value for the {@link MergeParams#getDefaultMergeType() defaultMergeType} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MergeParams#getDefaultMergeType() defaultMergeType}.</em>
     * @param defaultMergeType The value for defaultMergeType 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder defaultMergeType(MergeType defaultMergeType) {
      this.defaultMergeType = Objects.requireNonNull(defaultMergeType, "defaultMergeType");
      return this;
    }

    /**
     * Initializes the value for the {@link MergeParams#getUpdateCommitMetadata() updateCommitMetadata} attribute.
     * @param updateCommitMetadata The value for updateCommitMetadata 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder updateCommitMetadata(MetadataRewriter<ByteString> updateCommitMetadata) {
      this.updateCommitMetadata = Objects.requireNonNull(updateCommitMetadata, "updateCommitMetadata");
      initBits &= ~INIT_BIT_UPDATE_COMMIT_METADATA;
      return this;
    }

    /**
     * Initializes the value for the {@link MergeParams#getMergeFromHash() mergeFromHash} attribute.
     * @param mergeFromHash The value for mergeFromHash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mergeFromHash(Hash mergeFromHash) {
      this.mergeFromHash = Objects.requireNonNull(mergeFromHash, "mergeFromHash");
      initBits &= ~INIT_BIT_MERGE_FROM_HASH;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMergeParams ImmutableMergeParams}.
     * @return An immutable instance of MergeParams
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMergeParams build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMergeParams(this);
    }

    private boolean keepIndividualCommitsIsSet() {
      return (optBits & OPT_BIT_KEEP_INDIVIDUAL_COMMITS) != 0;
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TO_BRANCH) != 0) attributes.add("toBranch");
      if ((initBits & INIT_BIT_UPDATE_COMMIT_METADATA) != 0) attributes.add("updateCommitMetadata");
      if ((initBits & INIT_BIT_MERGE_FROM_HASH) != 0) attributes.add("mergeFromHash");
      return "Cannot build MergeParams, some of required attributes are not set " + attributes;
    }
  }
}
