package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;

/**
 * Immutable implementation of {@link CommitParams}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableCommitParams.builder()}.
 */
@Generated(from = "CommitParams", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableCommitParams implements CommitParams {
  private final BranchName toBranch;
  private final Optional<Hash> expectedHead;
  private final ImmutableMap<ContentId, Optional<ByteString>> expectedStates;
  private final ImmutableList<KeyWithBytes> puts;
  private final ImmutableMap<ContentId, ByteString> global;
  private final ImmutableList<Key> unchanged;
  private final ImmutableList<Key> deletes;
  private final ByteString commitMetaSerialized;
  private final @Nullable Callable<Void> validator;

  private ImmutableCommitParams(ImmutableCommitParams.Builder builder) {
    this.toBranch = builder.toBranch;
    this.expectedStates = builder.expectedStates.build();
    this.puts = builder.puts.build();
    this.global = builder.global.build();
    this.unchanged = builder.unchanged.build();
    this.deletes = builder.deletes.build();
    this.commitMetaSerialized = builder.commitMetaSerialized;
    this.validator = builder.validator;
    this.expectedHead = builder.expectedHead != null
        ? builder.expectedHead
        : Objects.requireNonNull(CommitParams.super.getExpectedHead(), "expectedHead");
  }

  private ImmutableCommitParams(
      BranchName toBranch,
      Optional<Hash> expectedHead,
      ImmutableMap<ContentId, Optional<ByteString>> expectedStates,
      ImmutableList<KeyWithBytes> puts,
      ImmutableMap<ContentId, ByteString> global,
      ImmutableList<Key> unchanged,
      ImmutableList<Key> deletes,
      ByteString commitMetaSerialized,
      @Nullable Callable<Void> validator) {
    this.toBranch = toBranch;
    this.expectedHead = expectedHead;
    this.expectedStates = expectedStates;
    this.puts = puts;
    this.global = global;
    this.unchanged = unchanged;
    this.deletes = deletes;
    this.commitMetaSerialized = commitMetaSerialized;
    this.validator = validator;
  }

  /**
   * Branch to commit to. If {@link #getExpectedHead()} is present, the referenced branch's HEAD
   * must be equal to this hash.
   */
  @Override
  public BranchName getToBranch() {
    return toBranch;
  }

  /**
   *Expected HEAD of {@link #getToBranch()}. 
   */
  @Override
  public Optional<Hash> getExpectedHead() {
    return expectedHead;
  }

  /**
   * Mapping of content-ids to expected global content-state (think: Iceberg table-metadata), coming
   * from the "expected-state" property of a {@code PutGlobal} commit operation.
   */
  @Override
  public ImmutableMap<ContentId, Optional<ByteString>> getExpectedStates() {
    return expectedStates;
  }

  /**
   * List of all {@code Put} operations, with their keys, content-types and serialized {@code
   * Content}.
   */
  @Override
  public ImmutableList<KeyWithBytes> getPuts() {
    return puts;
  }

  /**
   * Mapping of content-ids to the new content-state (think: Iceberg table-metadata), coming from
   * the "content" property of a {@code PutGlobal} commit operation.
   */
  @Override
  public ImmutableMap<ContentId, ByteString> getGlobal() {
    return global;
  }

  /**
   *List of "unchanged" keys, from {@code Unchanged} commit operations. 
   */
  @Override
  public ImmutableList<Key> getUnchanged() {
    return unchanged;
  }

  /**
   *List of "unchanged" keys, from {@code Delete} commit operations. 
   */
  @Override
  public ImmutableList<Key> getDeletes() {
    return deletes;
  }

  /**
   *Serialized commit-metadata. 
   */
  @Override
  public ByteString getCommitMetaSerialized() {
    return commitMetaSerialized;
  }

  /**
   * @return The value of the {@code validator} attribute
   */
  @Override
  public @Nullable Callable<Void> getValidator() {
    return validator;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitParams#getToBranch() toBranch} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toBranch
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitParams withToBranch(BranchName value) {
    if (this.toBranch == value) return this;
    BranchName newValue = Objects.requireNonNull(value, "toBranch");
    return new ImmutableCommitParams(
        newValue,
        this.expectedHead,
        this.expectedStates,
        this.puts,
        this.global,
        this.unchanged,
        this.deletes,
        this.commitMetaSerialized,
        this.validator);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitParams#getExpectedHead() expectedHead} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expectedHead
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitParams withExpectedHead(Optional<Hash> value) {
    Optional<Hash> newValue = Objects.requireNonNull(value, "expectedHead");
    if (this.expectedHead.equals(newValue)) return this;
    return new ImmutableCommitParams(
        this.toBranch,
        newValue,
        this.expectedStates,
        this.puts,
        this.global,
        this.unchanged,
        this.deletes,
        this.commitMetaSerialized,
        this.validator);
  }

  /**
   * Copy the current immutable object by replacing the {@link CommitParams#getExpectedStates() expectedStates} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the expectedStates map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitParams withExpectedStates(Map<? extends ContentId, ? extends Optional<ByteString>> entries) {
    if (this.expectedStates == entries) return this;
    ImmutableMap<ContentId, Optional<ByteString>> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableCommitParams(
        this.toBranch,
        this.expectedHead,
        newValue,
        this.puts,
        this.global,
        this.unchanged,
        this.deletes,
        this.commitMetaSerialized,
        this.validator);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommitParams#getPuts() puts}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitParams withPuts(KeyWithBytes... elements) {
    ImmutableList<KeyWithBytes> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCommitParams(
        this.toBranch,
        this.expectedHead,
        this.expectedStates,
        newValue,
        this.global,
        this.unchanged,
        this.deletes,
        this.commitMetaSerialized,
        this.validator);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommitParams#getPuts() puts}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of puts elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitParams withPuts(Iterable<? extends KeyWithBytes> elements) {
    if (this.puts == elements) return this;
    ImmutableList<KeyWithBytes> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCommitParams(
        this.toBranch,
        this.expectedHead,
        this.expectedStates,
        newValue,
        this.global,
        this.unchanged,
        this.deletes,
        this.commitMetaSerialized,
        this.validator);
  }

  /**
   * Copy the current immutable object by replacing the {@link CommitParams#getGlobal() global} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the global map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitParams withGlobal(Map<? extends ContentId, ? extends ByteString> entries) {
    if (this.global == entries) return this;
    ImmutableMap<ContentId, ByteString> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableCommitParams(
        this.toBranch,
        this.expectedHead,
        this.expectedStates,
        this.puts,
        newValue,
        this.unchanged,
        this.deletes,
        this.commitMetaSerialized,
        this.validator);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommitParams#getUnchanged() unchanged}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitParams withUnchanged(Key... elements) {
    ImmutableList<Key> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCommitParams(
        this.toBranch,
        this.expectedHead,
        this.expectedStates,
        this.puts,
        this.global,
        newValue,
        this.deletes,
        this.commitMetaSerialized,
        this.validator);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommitParams#getUnchanged() unchanged}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of unchanged elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitParams withUnchanged(Iterable<? extends Key> elements) {
    if (this.unchanged == elements) return this;
    ImmutableList<Key> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCommitParams(
        this.toBranch,
        this.expectedHead,
        this.expectedStates,
        this.puts,
        this.global,
        newValue,
        this.deletes,
        this.commitMetaSerialized,
        this.validator);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommitParams#getDeletes() deletes}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitParams withDeletes(Key... elements) {
    ImmutableList<Key> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCommitParams(
        this.toBranch,
        this.expectedHead,
        this.expectedStates,
        this.puts,
        this.global,
        this.unchanged,
        newValue,
        this.commitMetaSerialized,
        this.validator);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link CommitParams#getDeletes() deletes}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of deletes elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableCommitParams withDeletes(Iterable<? extends Key> elements) {
    if (this.deletes == elements) return this;
    ImmutableList<Key> newValue = ImmutableList.copyOf(elements);
    return new ImmutableCommitParams(
        this.toBranch,
        this.expectedHead,
        this.expectedStates,
        this.puts,
        this.global,
        this.unchanged,
        newValue,
        this.commitMetaSerialized,
        this.validator);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitParams#getCommitMetaSerialized() commitMetaSerialized} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for commitMetaSerialized
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitParams withCommitMetaSerialized(ByteString value) {
    if (this.commitMetaSerialized == value) return this;
    ByteString newValue = Objects.requireNonNull(value, "commitMetaSerialized");
    return new ImmutableCommitParams(
        this.toBranch,
        this.expectedHead,
        this.expectedStates,
        this.puts,
        this.global,
        this.unchanged,
        this.deletes,
        newValue,
        this.validator);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link CommitParams#getValidator() validator} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for validator (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableCommitParams withValidator(@Nullable Callable<Void> value) {
    if (this.validator == value) return this;
    return new ImmutableCommitParams(
        this.toBranch,
        this.expectedHead,
        this.expectedStates,
        this.puts,
        this.global,
        this.unchanged,
        this.deletes,
        this.commitMetaSerialized,
        value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableCommitParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableCommitParams
        && equalTo(0, (ImmutableCommitParams) another);
  }

  private boolean equalTo(int synthetic, ImmutableCommitParams another) {
    return toBranch.equals(another.toBranch)
        && expectedHead.equals(another.expectedHead)
        && expectedStates.equals(another.expectedStates)
        && puts.equals(another.puts)
        && global.equals(another.global)
        && unchanged.equals(another.unchanged)
        && deletes.equals(another.deletes)
        && commitMetaSerialized.equals(another.commitMetaSerialized)
        && Objects.equals(validator, another.validator);
  }

  /**
   * Computes a hash code from attributes: {@code toBranch}, {@code expectedHead}, {@code expectedStates}, {@code puts}, {@code global}, {@code unchanged}, {@code deletes}, {@code commitMetaSerialized}, {@code validator}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + toBranch.hashCode();
    h += (h << 5) + expectedHead.hashCode();
    h += (h << 5) + expectedStates.hashCode();
    h += (h << 5) + puts.hashCode();
    h += (h << 5) + global.hashCode();
    h += (h << 5) + unchanged.hashCode();
    h += (h << 5) + deletes.hashCode();
    h += (h << 5) + commitMetaSerialized.hashCode();
    h += (h << 5) + Objects.hashCode(validator);
    return h;
  }

  /**
   * Prints the immutable value {@code CommitParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("CommitParams")
        .omitNullValues()
        .add("toBranch", toBranch)
        .add("expectedHead", expectedHead)
        .add("expectedStates", expectedStates)
        .add("puts", puts)
        .add("global", global)
        .add("unchanged", unchanged)
        .add("deletes", deletes)
        .add("commitMetaSerialized", commitMetaSerialized)
        .add("validator", validator)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link CommitParams} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable CommitParams instance
   */
  public static ImmutableCommitParams copyOf(CommitParams instance) {
    if (instance instanceof ImmutableCommitParams) {
      return (ImmutableCommitParams) instance;
    }
    return ImmutableCommitParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableCommitParams ImmutableCommitParams}.
   * <pre>
   * ImmutableCommitParams.builder()
   *    .toBranch(org.projectnessie.versioned.BranchName) // required {@link CommitParams#getToBranch() toBranch}
   *    .expectedHead(Optional&amp;lt;org.projectnessie.versioned.Hash&amp;gt;) // optional {@link CommitParams#getExpectedHead() expectedHead}
   *    .putExpectedStates|putAllExpectedStates(org.projectnessie.versioned.persist.adapter.ContentId =&gt; Optional&amp;lt;com.google.protobuf.ByteString&amp;gt;) // {@link CommitParams#getExpectedStates() expectedStates} mappings
   *    .addPuts|addAllPuts(org.projectnessie.versioned.persist.adapter.KeyWithBytes) // {@link CommitParams#getPuts() puts} elements
   *    .putGlobal|putAllGlobal(org.projectnessie.versioned.persist.adapter.ContentId =&gt; com.google.protobuf.ByteString) // {@link CommitParams#getGlobal() global} mappings
   *    .addUnchanged|addAllUnchanged(org.projectnessie.versioned.Key) // {@link CommitParams#getUnchanged() unchanged} elements
   *    .addDeletes|addAllDeletes(org.projectnessie.versioned.Key) // {@link CommitParams#getDeletes() deletes} elements
   *    .commitMetaSerialized(com.google.protobuf.ByteString) // required {@link CommitParams#getCommitMetaSerialized() commitMetaSerialized}
   *    .validator(concurrent.Callable&amp;lt;Void&amp;gt; | null) // nullable {@link CommitParams#getValidator() validator}
   *    .build();
   * </pre>
   * @return A new ImmutableCommitParams builder
   */
  public static ImmutableCommitParams.Builder builder() {
    return new ImmutableCommitParams.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableCommitParams ImmutableCommitParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "CommitParams", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TO_BRANCH = 0x1L;
    private static final long INIT_BIT_COMMIT_META_SERIALIZED = 0x2L;
    private long initBits = 0x3L;

    private @Nullable BranchName toBranch;
    private @Nullable Optional<Hash> expectedHead;
    private ImmutableMap.Builder<ContentId, Optional<ByteString>> expectedStates = ImmutableMap.builder();
    private ImmutableList.Builder<KeyWithBytes> puts = ImmutableList.builder();
    private ImmutableMap.Builder<ContentId, ByteString> global = ImmutableMap.builder();
    private ImmutableList.Builder<Key> unchanged = ImmutableList.builder();
    private ImmutableList.Builder<Key> deletes = ImmutableList.builder();
    private @Nullable ByteString commitMetaSerialized;
    private @Nullable Callable<Void> validator;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.versioned.persist.adapter.CommitParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(CommitParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.versioned.persist.adapter.ToBranchParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ToBranchParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof CommitParams) {
        CommitParams instance = (CommitParams) object;
        addAllPuts(instance.getPuts());
        addAllDeletes(instance.getDeletes());
        commitMetaSerialized(instance.getCommitMetaSerialized());
        if ((bits & 0x1L) == 0) {
          expectedHead(instance.getExpectedHead());
          bits |= 0x1L;
        }
        addAllUnchanged(instance.getUnchanged());
        @Nullable Callable<Void> validatorValue = instance.getValidator();
        if (validatorValue != null) {
          validator(validatorValue);
        }
        putAllExpectedStates(instance.getExpectedStates());
        putAllGlobal(instance.getGlobal());
        if ((bits & 0x2L) == 0) {
          toBranch(instance.getToBranch());
          bits |= 0x2L;
        }
      }
      if (object instanceof ToBranchParams) {
        ToBranchParams instance = (ToBranchParams) object;
        if ((bits & 0x2L) == 0) {
          toBranch(instance.getToBranch());
          bits |= 0x2L;
        }
        if ((bits & 0x1L) == 0) {
          expectedHead(instance.getExpectedHead());
          bits |= 0x1L;
        }
      }
    }

    /**
     * Initializes the value for the {@link CommitParams#getToBranch() toBranch} attribute.
     * @param toBranch The value for toBranch 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder toBranch(BranchName toBranch) {
      this.toBranch = Objects.requireNonNull(toBranch, "toBranch");
      initBits &= ~INIT_BIT_TO_BRANCH;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitParams#getExpectedHead() expectedHead} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link CommitParams#getExpectedHead() expectedHead}.</em>
     * @param expectedHead The value for expectedHead 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder expectedHead(Optional<Hash> expectedHead) {
      this.expectedHead = Objects.requireNonNull(expectedHead, "expectedHead");
      return this;
    }

    /**
     * Put one entry to the {@link CommitParams#getExpectedStates() expectedStates} map.
     * @param key The key in the expectedStates map
     * @param value The associated value in the expectedStates map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putExpectedStates(ContentId key, Optional<ByteString> value) {
      this.expectedStates.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link CommitParams#getExpectedStates() expectedStates} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putExpectedStates(Map.Entry<? extends ContentId, ? extends Optional<ByteString>> entry) {
      this.expectedStates.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CommitParams#getExpectedStates() expectedStates} map. Nulls are not permitted
     * @param entries The entries that will be added to the expectedStates map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder expectedStates(Map<? extends ContentId, ? extends Optional<ByteString>> entries) {
      this.expectedStates = ImmutableMap.builder();
      return putAllExpectedStates(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CommitParams#getExpectedStates() expectedStates} map. Nulls are not permitted
     * @param entries The entries that will be added to the expectedStates map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllExpectedStates(Map<? extends ContentId, ? extends Optional<ByteString>> entries) {
      this.expectedStates.putAll(entries);
      return this;
    }

    /**
     * Adds one element to {@link CommitParams#getPuts() puts} list.
     * @param element A puts element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPuts(KeyWithBytes element) {
      this.puts.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CommitParams#getPuts() puts} list.
     * @param elements An array of puts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addPuts(KeyWithBytes... elements) {
      this.puts.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CommitParams#getPuts() puts} list.
     * @param elements An iterable of puts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder puts(Iterable<? extends KeyWithBytes> elements) {
      this.puts = ImmutableList.builder();
      return addAllPuts(elements);
    }

    /**
     * Adds elements to {@link CommitParams#getPuts() puts} list.
     * @param elements An iterable of puts elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllPuts(Iterable<? extends KeyWithBytes> elements) {
      this.puts.addAll(elements);
      return this;
    }

    /**
     * Put one entry to the {@link CommitParams#getGlobal() global} map.
     * @param key The key in the global map
     * @param value The associated value in the global map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putGlobal(ContentId key, ByteString value) {
      this.global.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link CommitParams#getGlobal() global} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putGlobal(Map.Entry<? extends ContentId, ? extends ByteString> entry) {
      this.global.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link CommitParams#getGlobal() global} map. Nulls are not permitted
     * @param entries The entries that will be added to the global map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder global(Map<? extends ContentId, ? extends ByteString> entries) {
      this.global = ImmutableMap.builder();
      return putAllGlobal(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link CommitParams#getGlobal() global} map. Nulls are not permitted
     * @param entries The entries that will be added to the global map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllGlobal(Map<? extends ContentId, ? extends ByteString> entries) {
      this.global.putAll(entries);
      return this;
    }

    /**
     * Adds one element to {@link CommitParams#getUnchanged() unchanged} list.
     * @param element A unchanged element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addUnchanged(Key element) {
      this.unchanged.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CommitParams#getUnchanged() unchanged} list.
     * @param elements An array of unchanged elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addUnchanged(Key... elements) {
      this.unchanged.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CommitParams#getUnchanged() unchanged} list.
     * @param elements An iterable of unchanged elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder unchanged(Iterable<? extends Key> elements) {
      this.unchanged = ImmutableList.builder();
      return addAllUnchanged(elements);
    }

    /**
     * Adds elements to {@link CommitParams#getUnchanged() unchanged} list.
     * @param elements An iterable of unchanged elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllUnchanged(Iterable<? extends Key> elements) {
      this.unchanged.addAll(elements);
      return this;
    }

    /**
     * Adds one element to {@link CommitParams#getDeletes() deletes} list.
     * @param element A deletes element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addDeletes(Key element) {
      this.deletes.add(element);
      return this;
    }

    /**
     * Adds elements to {@link CommitParams#getDeletes() deletes} list.
     * @param elements An array of deletes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addDeletes(Key... elements) {
      this.deletes.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link CommitParams#getDeletes() deletes} list.
     * @param elements An iterable of deletes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder deletes(Iterable<? extends Key> elements) {
      this.deletes = ImmutableList.builder();
      return addAllDeletes(elements);
    }

    /**
     * Adds elements to {@link CommitParams#getDeletes() deletes} list.
     * @param elements An iterable of deletes elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllDeletes(Iterable<? extends Key> elements) {
      this.deletes.addAll(elements);
      return this;
    }

    /**
     * Initializes the value for the {@link CommitParams#getCommitMetaSerialized() commitMetaSerialized} attribute.
     * @param commitMetaSerialized The value for commitMetaSerialized 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder commitMetaSerialized(ByteString commitMetaSerialized) {
      this.commitMetaSerialized = Objects.requireNonNull(commitMetaSerialized, "commitMetaSerialized");
      initBits &= ~INIT_BIT_COMMIT_META_SERIALIZED;
      return this;
    }

    /**
     * Initializes the value for the {@link CommitParams#getValidator() validator} attribute.
     * @param validator The value for validator (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder validator(@Nullable Callable<Void> validator) {
      this.validator = validator;
      return this;
    }

    /**
     * Builds a new {@link ImmutableCommitParams ImmutableCommitParams}.
     * @return An immutable instance of CommitParams
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableCommitParams build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableCommitParams(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TO_BRANCH) != 0) attributes.add("toBranch");
      if ((initBits & INIT_BIT_COMMIT_META_SERIALIZED) != 0) attributes.add("commitMetaSerialized");
      return "Cannot build CommitParams, some of required attributes are not set " + attributes;
    }
  }
}
