/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.persist.adapter.MetadataRewriteParams;
import org.projectnessie.versioned.persist.adapter.ToBranchParams;
import org.projectnessie.versioned.persist.adapter.TransplantParams;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TransplantParams", generator="Immutables")
@Immutable
public final class ImmutableTransplantParams
implements TransplantParams {
    private final BranchName toBranch;
    private final Optional<Hash> expectedHead;
    private final Function<ByteString, ByteString> updateCommitMetadata;
    private final ImmutableList<Hash> sequenceToTransplant;

    private ImmutableTransplantParams(Builder builder) {
        this.toBranch = builder.toBranch;
        this.updateCommitMetadata = builder.updateCommitMetadata;
        this.sequenceToTransplant = builder.sequenceToTransplant.build();
        this.expectedHead = builder.expectedHead != null ? builder.expectedHead : Objects.requireNonNull(TransplantParams.super.getExpectedHead(), "expectedHead");
    }

    private ImmutableTransplantParams(BranchName toBranch, Optional<Hash> expectedHead, Function<ByteString, ByteString> updateCommitMetadata, ImmutableList<Hash> sequenceToTransplant) {
        this.toBranch = toBranch;
        this.expectedHead = expectedHead;
        this.updateCommitMetadata = updateCommitMetadata;
        this.sequenceToTransplant = sequenceToTransplant;
    }

    @Override
    public BranchName getToBranch() {
        return this.toBranch;
    }

    @Override
    public Optional<Hash> getExpectedHead() {
        return this.expectedHead;
    }

    @Override
    public Function<ByteString, ByteString> getUpdateCommitMetadata() {
        return this.updateCommitMetadata;
    }

    public ImmutableList<Hash> getSequenceToTransplant() {
        return this.sequenceToTransplant;
    }

    public final ImmutableTransplantParams withToBranch(BranchName value) {
        if (this.toBranch == value) {
            return this;
        }
        BranchName newValue = Objects.requireNonNull(value, "toBranch");
        return new ImmutableTransplantParams(newValue, this.expectedHead, this.updateCommitMetadata, this.sequenceToTransplant);
    }

    public final ImmutableTransplantParams withExpectedHead(Optional<Hash> value) {
        Optional<Hash> newValue = Objects.requireNonNull(value, "expectedHead");
        if (this.expectedHead.equals(newValue)) {
            return this;
        }
        return new ImmutableTransplantParams(this.toBranch, newValue, this.updateCommitMetadata, this.sequenceToTransplant);
    }

    public final ImmutableTransplantParams withUpdateCommitMetadata(Function<ByteString, ByteString> value) {
        if (this.updateCommitMetadata == value) {
            return this;
        }
        Function<ByteString, ByteString> newValue = Objects.requireNonNull(value, "updateCommitMetadata");
        return new ImmutableTransplantParams(this.toBranch, this.expectedHead, newValue, this.sequenceToTransplant);
    }

    public final ImmutableTransplantParams withSequenceToTransplant(Hash ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableTransplantParams(this.toBranch, this.expectedHead, this.updateCommitMetadata, (ImmutableList<Hash>)newValue);
    }

    public final ImmutableTransplantParams withSequenceToTransplant(Iterable<? extends Hash> elements) {
        if (this.sequenceToTransplant == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableTransplantParams(this.toBranch, this.expectedHead, this.updateCommitMetadata, (ImmutableList<Hash>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransplantParams && this.equalTo(0, (ImmutableTransplantParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableTransplantParams another) {
        return this.toBranch.equals(another.toBranch) && this.expectedHead.equals(another.expectedHead) && this.updateCommitMetadata.equals(another.updateCommitMetadata) && this.sequenceToTransplant.equals(another.sequenceToTransplant);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.toBranch.hashCode();
        h += (h << 5) + this.expectedHead.hashCode();
        h += (h << 5) + this.updateCommitMetadata.hashCode();
        h += (h << 5) + this.sequenceToTransplant.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransplantParams").omitNullValues().add("toBranch", (Object)this.toBranch).add("expectedHead", this.expectedHead).add("updateCommitMetadata", this.updateCommitMetadata).add("sequenceToTransplant", this.sequenceToTransplant).toString();
    }

    public static ImmutableTransplantParams copyOf(TransplantParams instance) {
        if (instance instanceof ImmutableTransplantParams) {
            return (ImmutableTransplantParams)instance;
        }
        return ImmutableTransplantParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransplantParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TO_BRANCH = 1L;
        private static final long INIT_BIT_UPDATE_COMMIT_METADATA = 2L;
        private long initBits = 3L;
        @Nullable
        private BranchName toBranch;
        @Nullable
        private Optional<Hash> expectedHead;
        @Nullable
        private Function<ByteString, ByteString> updateCommitMetadata;
        private ImmutableList.Builder<Hash> sequenceToTransplant = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TransplantParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(MetadataRewriteParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ToBranchParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ToBranchParams instance;
            long bits = 0L;
            if (object instanceof TransplantParams) {
                instance = (TransplantParams)object;
                if ((bits & 1L) == 0L) {
                    this.updateCommitMetadata(instance.getUpdateCommitMetadata());
                    bits |= 1L;
                }
                this.addAllSequenceToTransplant(instance.getSequenceToTransplant());
                if ((bits & 4L) == 0L) {
                    this.toBranch(instance.getToBranch());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.expectedHead(instance.getExpectedHead());
                    bits |= 2L;
                }
            }
            if (object instanceof MetadataRewriteParams) {
                instance = (MetadataRewriteParams)object;
                if ((bits & 4L) == 0L) {
                    this.toBranch(instance.getToBranch());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.updateCommitMetadata(instance.getUpdateCommitMetadata());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.expectedHead(instance.getExpectedHead());
                    bits |= 2L;
                }
            }
            if (object instanceof ToBranchParams) {
                instance = (ToBranchParams)object;
                if ((bits & 4L) == 0L) {
                    this.toBranch(instance.getToBranch());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.expectedHead(instance.getExpectedHead());
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder toBranch(BranchName toBranch) {
            this.toBranch = Objects.requireNonNull(toBranch, "toBranch");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expectedHead(Optional<Hash> expectedHead) {
            this.expectedHead = Objects.requireNonNull(expectedHead, "expectedHead");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder updateCommitMetadata(Function<ByteString, ByteString> updateCommitMetadata) {
            this.updateCommitMetadata = Objects.requireNonNull(updateCommitMetadata, "updateCommitMetadata");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSequenceToTransplant(Hash element) {
            this.sequenceToTransplant.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addSequenceToTransplant(Hash ... elements) {
            this.sequenceToTransplant.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder sequenceToTransplant(Iterable<? extends Hash> elements) {
            this.sequenceToTransplant = ImmutableList.builder();
            return this.addAllSequenceToTransplant(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllSequenceToTransplant(Iterable<? extends Hash> elements) {
            this.sequenceToTransplant.addAll(elements);
            return this;
        }

        public ImmutableTransplantParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransplantParams(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("toBranch");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("updateCommitMetadata");
            }
            return "Cannot build TransplantParams, some of required attributes are not set " + attributes;
        }
    }
}

