/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.persist.adapter.MergeParams;
import org.projectnessie.versioned.persist.adapter.MetadataRewriteParams;
import org.projectnessie.versioned.persist.adapter.ToBranchParams;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="MergeParams", generator="Immutables")
@Immutable
public final class ImmutableMergeParams
implements MergeParams {
    private final BranchName toBranch;
    private final Optional<Hash> expectedHead;
    private final Function<ByteString, ByteString> updateCommitMetadata;
    private final Hash mergeFromHash;

    private ImmutableMergeParams(Builder builder) {
        this.toBranch = builder.toBranch;
        this.updateCommitMetadata = builder.updateCommitMetadata;
        this.mergeFromHash = builder.mergeFromHash;
        this.expectedHead = builder.expectedHead != null ? builder.expectedHead : Objects.requireNonNull(MergeParams.super.getExpectedHead(), "expectedHead");
    }

    private ImmutableMergeParams(BranchName toBranch, Optional<Hash> expectedHead, Function<ByteString, ByteString> updateCommitMetadata, Hash mergeFromHash) {
        this.toBranch = toBranch;
        this.expectedHead = expectedHead;
        this.updateCommitMetadata = updateCommitMetadata;
        this.mergeFromHash = mergeFromHash;
    }

    @Override
    public BranchName getToBranch() {
        return this.toBranch;
    }

    @Override
    public Optional<Hash> getExpectedHead() {
        return this.expectedHead;
    }

    @Override
    public Function<ByteString, ByteString> getUpdateCommitMetadata() {
        return this.updateCommitMetadata;
    }

    @Override
    public Hash getMergeFromHash() {
        return this.mergeFromHash;
    }

    public final ImmutableMergeParams withToBranch(BranchName value) {
        if (this.toBranch == value) {
            return this;
        }
        BranchName newValue = Objects.requireNonNull(value, "toBranch");
        return new ImmutableMergeParams(newValue, this.expectedHead, this.updateCommitMetadata, this.mergeFromHash);
    }

    public final ImmutableMergeParams withExpectedHead(Optional<Hash> value) {
        Optional<Hash> newValue = Objects.requireNonNull(value, "expectedHead");
        if (this.expectedHead.equals(newValue)) {
            return this;
        }
        return new ImmutableMergeParams(this.toBranch, newValue, this.updateCommitMetadata, this.mergeFromHash);
    }

    public final ImmutableMergeParams withUpdateCommitMetadata(Function<ByteString, ByteString> value) {
        if (this.updateCommitMetadata == value) {
            return this;
        }
        Function<ByteString, ByteString> newValue = Objects.requireNonNull(value, "updateCommitMetadata");
        return new ImmutableMergeParams(this.toBranch, this.expectedHead, newValue, this.mergeFromHash);
    }

    public final ImmutableMergeParams withMergeFromHash(Hash value) {
        if (this.mergeFromHash == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "mergeFromHash");
        return new ImmutableMergeParams(this.toBranch, this.expectedHead, this.updateCommitMetadata, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMergeParams && this.equalTo(0, (ImmutableMergeParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableMergeParams another) {
        return this.toBranch.equals(another.toBranch) && this.expectedHead.equals(another.expectedHead) && this.updateCommitMetadata.equals(another.updateCommitMetadata) && this.mergeFromHash.equals((Object)another.mergeFromHash);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.toBranch.hashCode();
        h += (h << 5) + this.expectedHead.hashCode();
        h += (h << 5) + this.updateCommitMetadata.hashCode();
        h += (h << 5) + this.mergeFromHash.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"MergeParams").omitNullValues().add("toBranch", (Object)this.toBranch).add("expectedHead", this.expectedHead).add("updateCommitMetadata", this.updateCommitMetadata).add("mergeFromHash", (Object)this.mergeFromHash).toString();
    }

    public static ImmutableMergeParams copyOf(MergeParams instance) {
        if (instance instanceof ImmutableMergeParams) {
            return (ImmutableMergeParams)instance;
        }
        return ImmutableMergeParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="MergeParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TO_BRANCH = 1L;
        private static final long INIT_BIT_UPDATE_COMMIT_METADATA = 2L;
        private static final long INIT_BIT_MERGE_FROM_HASH = 4L;
        private long initBits = 7L;
        @Nullable
        private BranchName toBranch;
        @Nullable
        private Optional<Hash> expectedHead;
        @Nullable
        private Function<ByteString, ByteString> updateCommitMetadata;
        @Nullable
        private Hash mergeFromHash;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(MergeParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(MetadataRewriteParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(ToBranchParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            ToBranchParams instance;
            long bits = 0L;
            if (object instanceof MergeParams) {
                instance = (MergeParams)object;
                this.mergeFromHash(instance.getMergeFromHash());
                if ((bits & 1L) == 0L) {
                    this.updateCommitMetadata(instance.getUpdateCommitMetadata());
                    bits |= 1L;
                }
                if ((bits & 4L) == 0L) {
                    this.toBranch(instance.getToBranch());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.expectedHead(instance.getExpectedHead());
                    bits |= 2L;
                }
            }
            if (object instanceof MetadataRewriteParams) {
                instance = (MetadataRewriteParams)object;
                if ((bits & 4L) == 0L) {
                    this.toBranch(instance.getToBranch());
                    bits |= 4L;
                }
                if ((bits & 1L) == 0L) {
                    this.updateCommitMetadata(instance.getUpdateCommitMetadata());
                    bits |= 1L;
                }
                if ((bits & 2L) == 0L) {
                    this.expectedHead(instance.getExpectedHead());
                    bits |= 2L;
                }
            }
            if (object instanceof ToBranchParams) {
                instance = (ToBranchParams)object;
                if ((bits & 4L) == 0L) {
                    this.toBranch(instance.getToBranch());
                    bits |= 4L;
                }
                if ((bits & 2L) == 0L) {
                    this.expectedHead(instance.getExpectedHead());
                    bits |= 2L;
                }
            }
        }

        @CanIgnoreReturnValue
        public final Builder toBranch(BranchName toBranch) {
            this.toBranch = Objects.requireNonNull(toBranch, "toBranch");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expectedHead(Optional<Hash> expectedHead) {
            this.expectedHead = Objects.requireNonNull(expectedHead, "expectedHead");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder updateCommitMetadata(Function<ByteString, ByteString> updateCommitMetadata) {
            this.updateCommitMetadata = Objects.requireNonNull(updateCommitMetadata, "updateCommitMetadata");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder mergeFromHash(Hash mergeFromHash) {
            this.mergeFromHash = Objects.requireNonNull(mergeFromHash, "mergeFromHash");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableMergeParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMergeParams(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("toBranch");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("updateCommitMetadata");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("mergeFromHash");
            }
            return "Cannot build MergeParams, some of required attributes are not set " + attributes;
        }
    }
}

