package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;

/**
 * Immutable implementation of {@link TransplantParams}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableTransplantParams.builder()}.
 */
@Generated(from = "TransplantParams", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableTransplantParams
    implements TransplantParams {
  private final BranchName toBranch;
  private final Optional<Hash> expectedHead;
  private final Function<ByteString, ByteString> updateCommitMetadata;
  private final ImmutableList<Hash> sequenceToTransplant;

  private ImmutableTransplantParams(ImmutableTransplantParams.Builder builder) {
    this.toBranch = builder.toBranch;
    this.updateCommitMetadata = builder.updateCommitMetadata;
    this.sequenceToTransplant = builder.sequenceToTransplant.build();
    this.expectedHead = builder.expectedHead != null
        ? builder.expectedHead
        : Objects.requireNonNull(TransplantParams.super.getExpectedHead(), "expectedHead");
  }

  private ImmutableTransplantParams(
      BranchName toBranch,
      Optional<Hash> expectedHead,
      Function<ByteString, ByteString> updateCommitMetadata,
      ImmutableList<Hash> sequenceToTransplant) {
    this.toBranch = toBranch;
    this.expectedHead = expectedHead;
    this.updateCommitMetadata = updateCommitMetadata;
    this.sequenceToTransplant = sequenceToTransplant;
  }

  /**
   * Branch to commit to. If {@link #getExpectedHead()} is present, the referenced branch's HEAD
   * must be equal to this hash.
   */
  @Override
  public BranchName getToBranch() {
    return toBranch;
  }

  /**
   *Expected HEAD of {@link #getToBranch()}. 
   */
  @Override
  public Optional<Hash> getExpectedHead() {
    return expectedHead;
  }

  /**
   *Function to rewrite the commit-metadata. 
   */
  @Override
  public Function<ByteString, ByteString> getUpdateCommitMetadata() {
    return updateCommitMetadata;
  }

  /**
   *Commits to cherry-pick onto {@link #getToBranch()}. 
   */
  @Override
  public ImmutableList<Hash> getSequenceToTransplant() {
    return sequenceToTransplant;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransplantParams#getToBranch() toBranch} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toBranch
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransplantParams withToBranch(BranchName value) {
    if (this.toBranch == value) return this;
    BranchName newValue = Objects.requireNonNull(value, "toBranch");
    return new ImmutableTransplantParams(newValue, this.expectedHead, this.updateCommitMetadata, this.sequenceToTransplant);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransplantParams#getExpectedHead() expectedHead} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expectedHead
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransplantParams withExpectedHead(Optional<Hash> value) {
    Optional<Hash> newValue = Objects.requireNonNull(value, "expectedHead");
    if (this.expectedHead.equals(newValue)) return this;
    return new ImmutableTransplantParams(this.toBranch, newValue, this.updateCommitMetadata, this.sequenceToTransplant);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link TransplantParams#getUpdateCommitMetadata() updateCommitMetadata} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updateCommitMetadata
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableTransplantParams withUpdateCommitMetadata(Function<ByteString, ByteString> value) {
    if (this.updateCommitMetadata == value) return this;
    Function<ByteString, ByteString> newValue = Objects.requireNonNull(value, "updateCommitMetadata");
    return new ImmutableTransplantParams(this.toBranch, this.expectedHead, newValue, this.sequenceToTransplant);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TransplantParams#getSequenceToTransplant() sequenceToTransplant}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTransplantParams withSequenceToTransplant(Hash... elements) {
    ImmutableList<Hash> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTransplantParams(this.toBranch, this.expectedHead, this.updateCommitMetadata, newValue);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link TransplantParams#getSequenceToTransplant() sequenceToTransplant}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of sequenceToTransplant elements to set
   * @return A modified copy of {@code this} object
   */
  public final ImmutableTransplantParams withSequenceToTransplant(Iterable<? extends Hash> elements) {
    if (this.sequenceToTransplant == elements) return this;
    ImmutableList<Hash> newValue = ImmutableList.copyOf(elements);
    return new ImmutableTransplantParams(this.toBranch, this.expectedHead, this.updateCommitMetadata, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableTransplantParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableTransplantParams
        && equalTo(0, (ImmutableTransplantParams) another);
  }

  private boolean equalTo(int synthetic, ImmutableTransplantParams another) {
    return toBranch.equals(another.toBranch)
        && expectedHead.equals(another.expectedHead)
        && updateCommitMetadata.equals(another.updateCommitMetadata)
        && sequenceToTransplant.equals(another.sequenceToTransplant);
  }

  /**
   * Computes a hash code from attributes: {@code toBranch}, {@code expectedHead}, {@code updateCommitMetadata}, {@code sequenceToTransplant}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + toBranch.hashCode();
    h += (h << 5) + expectedHead.hashCode();
    h += (h << 5) + updateCommitMetadata.hashCode();
    h += (h << 5) + sequenceToTransplant.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code TransplantParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("TransplantParams")
        .omitNullValues()
        .add("toBranch", toBranch)
        .add("expectedHead", expectedHead)
        .add("updateCommitMetadata", updateCommitMetadata)
        .add("sequenceToTransplant", sequenceToTransplant)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link TransplantParams} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable TransplantParams instance
   */
  public static ImmutableTransplantParams copyOf(TransplantParams instance) {
    if (instance instanceof ImmutableTransplantParams) {
      return (ImmutableTransplantParams) instance;
    }
    return ImmutableTransplantParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableTransplantParams ImmutableTransplantParams}.
   * <pre>
   * ImmutableTransplantParams.builder()
   *    .toBranch(org.projectnessie.versioned.BranchName) // required {@link TransplantParams#getToBranch() toBranch}
   *    .expectedHead(Optional&amp;lt;org.projectnessie.versioned.Hash&amp;gt;) // optional {@link TransplantParams#getExpectedHead() expectedHead}
   *    .updateCommitMetadata(function.Function&amp;lt;com.google.protobuf.ByteString, com.google.protobuf.ByteString&amp;gt;) // required {@link TransplantParams#getUpdateCommitMetadata() updateCommitMetadata}
   *    .addSequenceToTransplant|addAllSequenceToTransplant(org.projectnessie.versioned.Hash) // {@link TransplantParams#getSequenceToTransplant() sequenceToTransplant} elements
   *    .build();
   * </pre>
   * @return A new ImmutableTransplantParams builder
   */
  public static ImmutableTransplantParams.Builder builder() {
    return new ImmutableTransplantParams.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableTransplantParams ImmutableTransplantParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "TransplantParams", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TO_BRANCH = 0x1L;
    private static final long INIT_BIT_UPDATE_COMMIT_METADATA = 0x2L;
    private long initBits = 0x3L;

    private @Nullable BranchName toBranch;
    private @Nullable Optional<Hash> expectedHead;
    private @Nullable Function<ByteString, ByteString> updateCommitMetadata;
    private ImmutableList.Builder<Hash> sequenceToTransplant = ImmutableList.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.versioned.persist.adapter.TransplantParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(TransplantParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.versioned.persist.adapter.MetadataRewriteParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MetadataRewriteParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.versioned.persist.adapter.ToBranchParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ToBranchParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof TransplantParams) {
        TransplantParams instance = (TransplantParams) object;
        if ((bits & 0x1L) == 0) {
          updateCommitMetadata(instance.getUpdateCommitMetadata());
          bits |= 0x1L;
        }
        addAllSequenceToTransplant(instance.getSequenceToTransplant());
        if ((bits & 0x4L) == 0) {
          toBranch(instance.getToBranch());
          bits |= 0x4L;
        }
        if ((bits & 0x2L) == 0) {
          expectedHead(instance.getExpectedHead());
          bits |= 0x2L;
        }
      }
      if (object instanceof MetadataRewriteParams) {
        MetadataRewriteParams instance = (MetadataRewriteParams) object;
        if ((bits & 0x4L) == 0) {
          toBranch(instance.getToBranch());
          bits |= 0x4L;
        }
        if ((bits & 0x1L) == 0) {
          updateCommitMetadata(instance.getUpdateCommitMetadata());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          expectedHead(instance.getExpectedHead());
          bits |= 0x2L;
        }
      }
      if (object instanceof ToBranchParams) {
        ToBranchParams instance = (ToBranchParams) object;
        if ((bits & 0x4L) == 0) {
          toBranch(instance.getToBranch());
          bits |= 0x4L;
        }
        if ((bits & 0x2L) == 0) {
          expectedHead(instance.getExpectedHead());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link TransplantParams#getToBranch() toBranch} attribute.
     * @param toBranch The value for toBranch 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder toBranch(BranchName toBranch) {
      this.toBranch = Objects.requireNonNull(toBranch, "toBranch");
      initBits &= ~INIT_BIT_TO_BRANCH;
      return this;
    }

    /**
     * Initializes the value for the {@link TransplantParams#getExpectedHead() expectedHead} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link TransplantParams#getExpectedHead() expectedHead}.</em>
     * @param expectedHead The value for expectedHead 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder expectedHead(Optional<Hash> expectedHead) {
      this.expectedHead = Objects.requireNonNull(expectedHead, "expectedHead");
      return this;
    }

    /**
     * Initializes the value for the {@link TransplantParams#getUpdateCommitMetadata() updateCommitMetadata} attribute.
     * @param updateCommitMetadata The value for updateCommitMetadata 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder updateCommitMetadata(Function<ByteString, ByteString> updateCommitMetadata) {
      this.updateCommitMetadata = Objects.requireNonNull(updateCommitMetadata, "updateCommitMetadata");
      initBits &= ~INIT_BIT_UPDATE_COMMIT_METADATA;
      return this;
    }

    /**
     * Adds one element to {@link TransplantParams#getSequenceToTransplant() sequenceToTransplant} list.
     * @param element A sequenceToTransplant element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSequenceToTransplant(Hash element) {
      this.sequenceToTransplant.add(element);
      return this;
    }

    /**
     * Adds elements to {@link TransplantParams#getSequenceToTransplant() sequenceToTransplant} list.
     * @param elements An array of sequenceToTransplant elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addSequenceToTransplant(Hash... elements) {
      this.sequenceToTransplant.add(elements);
      return this;
    }


    /**
     * Sets or replaces all elements for {@link TransplantParams#getSequenceToTransplant() sequenceToTransplant} list.
     * @param elements An iterable of sequenceToTransplant elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sequenceToTransplant(Iterable<? extends Hash> elements) {
      this.sequenceToTransplant = ImmutableList.builder();
      return addAllSequenceToTransplant(elements);
    }

    /**
     * Adds elements to {@link TransplantParams#getSequenceToTransplant() sequenceToTransplant} list.
     * @param elements An iterable of sequenceToTransplant elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllSequenceToTransplant(Iterable<? extends Hash> elements) {
      this.sequenceToTransplant.addAll(elements);
      return this;
    }

    /**
     * Builds a new {@link ImmutableTransplantParams ImmutableTransplantParams}.
     * @return An immutable instance of TransplantParams
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableTransplantParams build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableTransplantParams(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TO_BRANCH) != 0) attributes.add("toBranch");
      if ((initBits & INIT_BIT_UPDATE_COMMIT_METADATA) != 0) attributes.add("updateCommitMetadata");
      return "Cannot build TransplantParams, some of required attributes are not set " + attributes;
    }
  }
}
