package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;

/**
 * Immutable implementation of {@link MergeParams}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableMergeParams.builder()}.
 */
@Generated(from = "MergeParams", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableMergeParams implements MergeParams {
  private final BranchName toBranch;
  private final Optional<Hash> expectedHead;
  private final Function<ByteString, ByteString> updateCommitMetadata;
  private final Hash mergeFromHash;

  private ImmutableMergeParams(ImmutableMergeParams.Builder builder) {
    this.toBranch = builder.toBranch;
    this.updateCommitMetadata = builder.updateCommitMetadata;
    this.mergeFromHash = builder.mergeFromHash;
    this.expectedHead = builder.expectedHead != null
        ? builder.expectedHead
        : Objects.requireNonNull(MergeParams.super.getExpectedHead(), "expectedHead");
  }

  private ImmutableMergeParams(
      BranchName toBranch,
      Optional<Hash> expectedHead,
      Function<ByteString, ByteString> updateCommitMetadata,
      Hash mergeFromHash) {
    this.toBranch = toBranch;
    this.expectedHead = expectedHead;
    this.updateCommitMetadata = updateCommitMetadata;
    this.mergeFromHash = mergeFromHash;
  }

  /**
   * Branch to commit to. If {@link #getExpectedHead()} is present, the referenced branch's HEAD
   * must be equal to this hash.
   */
  @Override
  public BranchName getToBranch() {
    return toBranch;
  }

  /**
   *Expected HEAD of {@link #getToBranch()}. 
   */
  @Override
  public Optional<Hash> getExpectedHead() {
    return expectedHead;
  }

  /**
   *Function to rewrite the commit-metadata. 
   */
  @Override
  public Function<ByteString, ByteString> getUpdateCommitMetadata() {
    return updateCommitMetadata;
  }

  /**
   *Commit-hash to start reading commits from. 
   */
  @Override
  public Hash getMergeFromHash() {
    return mergeFromHash;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MergeParams#getToBranch() toBranch} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for toBranch
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMergeParams withToBranch(BranchName value) {
    if (this.toBranch == value) return this;
    BranchName newValue = Objects.requireNonNull(value, "toBranch");
    return new ImmutableMergeParams(newValue, this.expectedHead, this.updateCommitMetadata, this.mergeFromHash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MergeParams#getExpectedHead() expectedHead} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for expectedHead
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMergeParams withExpectedHead(Optional<Hash> value) {
    Optional<Hash> newValue = Objects.requireNonNull(value, "expectedHead");
    if (this.expectedHead.equals(newValue)) return this;
    return new ImmutableMergeParams(this.toBranch, newValue, this.updateCommitMetadata, this.mergeFromHash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MergeParams#getUpdateCommitMetadata() updateCommitMetadata} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for updateCommitMetadata
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMergeParams withUpdateCommitMetadata(Function<ByteString, ByteString> value) {
    if (this.updateCommitMetadata == value) return this;
    Function<ByteString, ByteString> newValue = Objects.requireNonNull(value, "updateCommitMetadata");
    return new ImmutableMergeParams(this.toBranch, this.expectedHead, newValue, this.mergeFromHash);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link MergeParams#getMergeFromHash() mergeFromHash} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for mergeFromHash
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableMergeParams withMergeFromHash(Hash value) {
    if (this.mergeFromHash == value) return this;
    Hash newValue = Objects.requireNonNull(value, "mergeFromHash");
    return new ImmutableMergeParams(this.toBranch, this.expectedHead, this.updateCommitMetadata, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableMergeParams} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableMergeParams
        && equalTo(0, (ImmutableMergeParams) another);
  }

  private boolean equalTo(int synthetic, ImmutableMergeParams another) {
    return toBranch.equals(another.toBranch)
        && expectedHead.equals(another.expectedHead)
        && updateCommitMetadata.equals(another.updateCommitMetadata)
        && mergeFromHash.equals(another.mergeFromHash);
  }

  /**
   * Computes a hash code from attributes: {@code toBranch}, {@code expectedHead}, {@code updateCommitMetadata}, {@code mergeFromHash}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + toBranch.hashCode();
    h += (h << 5) + expectedHead.hashCode();
    h += (h << 5) + updateCommitMetadata.hashCode();
    h += (h << 5) + mergeFromHash.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code MergeParams} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("MergeParams")
        .omitNullValues()
        .add("toBranch", toBranch)
        .add("expectedHead", expectedHead)
        .add("updateCommitMetadata", updateCommitMetadata)
        .add("mergeFromHash", mergeFromHash)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link MergeParams} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable MergeParams instance
   */
  public static ImmutableMergeParams copyOf(MergeParams instance) {
    if (instance instanceof ImmutableMergeParams) {
      return (ImmutableMergeParams) instance;
    }
    return ImmutableMergeParams.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableMergeParams ImmutableMergeParams}.
   * <pre>
   * ImmutableMergeParams.builder()
   *    .toBranch(org.projectnessie.versioned.BranchName) // required {@link MergeParams#getToBranch() toBranch}
   *    .expectedHead(Optional&amp;lt;org.projectnessie.versioned.Hash&amp;gt;) // optional {@link MergeParams#getExpectedHead() expectedHead}
   *    .updateCommitMetadata(function.Function&amp;lt;com.google.protobuf.ByteString, com.google.protobuf.ByteString&amp;gt;) // required {@link MergeParams#getUpdateCommitMetadata() updateCommitMetadata}
   *    .mergeFromHash(org.projectnessie.versioned.Hash) // required {@link MergeParams#getMergeFromHash() mergeFromHash}
   *    .build();
   * </pre>
   * @return A new ImmutableMergeParams builder
   */
  public static ImmutableMergeParams.Builder builder() {
    return new ImmutableMergeParams.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableMergeParams ImmutableMergeParams}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "MergeParams", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_TO_BRANCH = 0x1L;
    private static final long INIT_BIT_UPDATE_COMMIT_METADATA = 0x2L;
    private static final long INIT_BIT_MERGE_FROM_HASH = 0x4L;
    private long initBits = 0x7L;

    private @Nullable BranchName toBranch;
    private @Nullable Optional<Hash> expectedHead;
    private @Nullable Function<ByteString, ByteString> updateCommitMetadata;
    private @Nullable Hash mergeFromHash;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.versioned.persist.adapter.MergeParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MergeParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.versioned.persist.adapter.MetadataRewriteParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(MetadataRewriteParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    /**
     * Fill a builder with attribute values from the provided {@code org.projectnessie.versioned.persist.adapter.ToBranchParams} instance.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ToBranchParams instance) {
      Objects.requireNonNull(instance, "instance");
      from((Object) instance);
      return this;
    }

    private void from(Object object) {
      @Var long bits = 0;
      if (object instanceof MergeParams) {
        MergeParams instance = (MergeParams) object;
        mergeFromHash(instance.getMergeFromHash());
        if ((bits & 0x1L) == 0) {
          updateCommitMetadata(instance.getUpdateCommitMetadata());
          bits |= 0x1L;
        }
        if ((bits & 0x4L) == 0) {
          toBranch(instance.getToBranch());
          bits |= 0x4L;
        }
        if ((bits & 0x2L) == 0) {
          expectedHead(instance.getExpectedHead());
          bits |= 0x2L;
        }
      }
      if (object instanceof MetadataRewriteParams) {
        MetadataRewriteParams instance = (MetadataRewriteParams) object;
        if ((bits & 0x4L) == 0) {
          toBranch(instance.getToBranch());
          bits |= 0x4L;
        }
        if ((bits & 0x1L) == 0) {
          updateCommitMetadata(instance.getUpdateCommitMetadata());
          bits |= 0x1L;
        }
        if ((bits & 0x2L) == 0) {
          expectedHead(instance.getExpectedHead());
          bits |= 0x2L;
        }
      }
      if (object instanceof ToBranchParams) {
        ToBranchParams instance = (ToBranchParams) object;
        if ((bits & 0x4L) == 0) {
          toBranch(instance.getToBranch());
          bits |= 0x4L;
        }
        if ((bits & 0x2L) == 0) {
          expectedHead(instance.getExpectedHead());
          bits |= 0x2L;
        }
      }
    }

    /**
     * Initializes the value for the {@link MergeParams#getToBranch() toBranch} attribute.
     * @param toBranch The value for toBranch 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder toBranch(BranchName toBranch) {
      this.toBranch = Objects.requireNonNull(toBranch, "toBranch");
      initBits &= ~INIT_BIT_TO_BRANCH;
      return this;
    }

    /**
     * Initializes the value for the {@link MergeParams#getExpectedHead() expectedHead} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link MergeParams#getExpectedHead() expectedHead}.</em>
     * @param expectedHead The value for expectedHead 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder expectedHead(Optional<Hash> expectedHead) {
      this.expectedHead = Objects.requireNonNull(expectedHead, "expectedHead");
      return this;
    }

    /**
     * Initializes the value for the {@link MergeParams#getUpdateCommitMetadata() updateCommitMetadata} attribute.
     * @param updateCommitMetadata The value for updateCommitMetadata 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder updateCommitMetadata(Function<ByteString, ByteString> updateCommitMetadata) {
      this.updateCommitMetadata = Objects.requireNonNull(updateCommitMetadata, "updateCommitMetadata");
      initBits &= ~INIT_BIT_UPDATE_COMMIT_METADATA;
      return this;
    }

    /**
     * Initializes the value for the {@link MergeParams#getMergeFromHash() mergeFromHash} attribute.
     * @param mergeFromHash The value for mergeFromHash 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder mergeFromHash(Hash mergeFromHash) {
      this.mergeFromHash = Objects.requireNonNull(mergeFromHash, "mergeFromHash");
      initBits &= ~INIT_BIT_MERGE_FROM_HASH;
      return this;
    }

    /**
     * Builds a new {@link ImmutableMergeParams ImmutableMergeParams}.
     * @return An immutable instance of MergeParams
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableMergeParams build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableMergeParams(this);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_TO_BRANCH) != 0) attributes.add("toBranch");
      if ((initBits & INIT_BIT_UPDATE_COMMIT_METADATA) != 0) attributes.add("updateCommitMetadata");
      if ((initBits & INIT_BIT_MERGE_FROM_HASH) != 0) attributes.add("mergeFromHash");
      return "Cannot build MergeParams, some of required attributes are not set " + attributes;
    }
  }
}
