/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.persist.adapter.GlobalLogCompactionParams;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GlobalLogCompactionParams", generator="Immutables")
@Immutable
public final class ImmutableGlobalLogCompactionParams
implements GlobalLogCompactionParams {
    private final boolean isEnabled;
    private final int noCompactionWhenCompactedWithin;
    private final int noCompactionUpToLength;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableGlobalLogCompactionParams(Builder builder) {
        if (builder.isEnabledIsSet()) {
            this.initShim.isEnabled(builder.isEnabled);
        }
        if (builder.noCompactionWhenCompactedWithinIsSet()) {
            this.initShim.noCompactionWhenCompactedWithin(builder.noCompactionWhenCompactedWithin);
        }
        if (builder.noCompactionUpToLengthIsSet()) {
            this.initShim.noCompactionUpToLength(builder.noCompactionUpToLength);
        }
        this.isEnabled = this.initShim.isEnabled();
        this.noCompactionWhenCompactedWithin = this.initShim.getNoCompactionWhenCompactedWithin();
        this.noCompactionUpToLength = this.initShim.getNoCompactionUpToLength();
        this.initShim = null;
    }

    private ImmutableGlobalLogCompactionParams(boolean isEnabled, int noCompactionWhenCompactedWithin, int noCompactionUpToLength) {
        this.isEnabled = isEnabled;
        this.noCompactionWhenCompactedWithin = noCompactionWhenCompactedWithin;
        this.noCompactionUpToLength = noCompactionUpToLength;
        this.initShim = null;
    }

    private boolean isEnabledInitialize() {
        return GlobalLogCompactionParams.super.isEnabled();
    }

    private int getNoCompactionWhenCompactedWithinInitialize() {
        return GlobalLogCompactionParams.super.getNoCompactionWhenCompactedWithin();
    }

    private int getNoCompactionUpToLengthInitialize() {
        return GlobalLogCompactionParams.super.getNoCompactionUpToLength();
    }

    @Override
    public boolean isEnabled() {
        InitShim shim = this.initShim;
        return shim != null ? shim.isEnabled() : this.isEnabled;
    }

    @Override
    public int getNoCompactionWhenCompactedWithin() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getNoCompactionWhenCompactedWithin() : this.noCompactionWhenCompactedWithin;
    }

    @Override
    public int getNoCompactionUpToLength() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getNoCompactionUpToLength() : this.noCompactionUpToLength;
    }

    public final ImmutableGlobalLogCompactionParams withIsEnabled(boolean value) {
        if (this.isEnabled == value) {
            return this;
        }
        return new ImmutableGlobalLogCompactionParams(value, this.noCompactionWhenCompactedWithin, this.noCompactionUpToLength);
    }

    public final ImmutableGlobalLogCompactionParams withNoCompactionWhenCompactedWithin(int value) {
        if (this.noCompactionWhenCompactedWithin == value) {
            return this;
        }
        return new ImmutableGlobalLogCompactionParams(this.isEnabled, value, this.noCompactionUpToLength);
    }

    public final ImmutableGlobalLogCompactionParams withNoCompactionUpToLength(int value) {
        if (this.noCompactionUpToLength == value) {
            return this;
        }
        return new ImmutableGlobalLogCompactionParams(this.isEnabled, this.noCompactionWhenCompactedWithin, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGlobalLogCompactionParams && this.equalTo(0, (ImmutableGlobalLogCompactionParams)another);
    }

    private boolean equalTo(int synthetic, ImmutableGlobalLogCompactionParams another) {
        return this.isEnabled == another.isEnabled && this.noCompactionWhenCompactedWithin == another.noCompactionWhenCompactedWithin && this.noCompactionUpToLength == another.noCompactionUpToLength;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Booleans.hashCode((boolean)this.isEnabled);
        h += (h << 5) + this.noCompactionWhenCompactedWithin;
        h += (h << 5) + this.noCompactionUpToLength;
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"GlobalLogCompactionParams").omitNullValues().add("isEnabled", this.isEnabled).add("noCompactionWhenCompactedWithin", this.noCompactionWhenCompactedWithin).add("noCompactionUpToLength", this.noCompactionUpToLength).toString();
    }

    public static ImmutableGlobalLogCompactionParams copyOf(GlobalLogCompactionParams instance) {
        if (instance instanceof ImmutableGlobalLogCompactionParams) {
            return (ImmutableGlobalLogCompactionParams)instance;
        }
        return ImmutableGlobalLogCompactionParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GlobalLogCompactionParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long OPT_BIT_IS_ENABLED = 1L;
        private static final long OPT_BIT_NO_COMPACTION_WHEN_COMPACTED_WITHIN = 2L;
        private static final long OPT_BIT_NO_COMPACTION_UP_TO_LENGTH = 4L;
        private long optBits;
        private boolean isEnabled;
        private int noCompactionWhenCompactedWithin;
        private int noCompactionUpToLength;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(GlobalLogCompactionParams instance) {
            Objects.requireNonNull(instance, "instance");
            this.isEnabled(instance.isEnabled());
            this.noCompactionWhenCompactedWithin(instance.getNoCompactionWhenCompactedWithin());
            this.noCompactionUpToLength(instance.getNoCompactionUpToLength());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder isEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder noCompactionWhenCompactedWithin(int noCompactionWhenCompactedWithin) {
            this.noCompactionWhenCompactedWithin = noCompactionWhenCompactedWithin;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder noCompactionUpToLength(int noCompactionUpToLength) {
            this.noCompactionUpToLength = noCompactionUpToLength;
            this.optBits |= 4L;
            return this;
        }

        public ImmutableGlobalLogCompactionParams build() {
            return new ImmutableGlobalLogCompactionParams(this);
        }

        private boolean isEnabledIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean noCompactionWhenCompactedWithinIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean noCompactionUpToLengthIsSet() {
            return (this.optBits & 4L) != 0L;
        }
    }

    @Generated(from="GlobalLogCompactionParams", generator="Immutables")
    private final class InitShim {
        private byte isEnabledBuildStage = 0;
        private boolean isEnabled;
        private byte noCompactionWhenCompactedWithinBuildStage = 0;
        private int noCompactionWhenCompactedWithin;
        private byte noCompactionUpToLengthBuildStage = 0;
        private int noCompactionUpToLength;

        private InitShim() {
        }

        boolean isEnabled() {
            if (this.isEnabledBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.isEnabledBuildStage == 0) {
                this.isEnabledBuildStage = (byte)-1;
                this.isEnabled = ImmutableGlobalLogCompactionParams.this.isEnabledInitialize();
                this.isEnabledBuildStage = 1;
            }
            return this.isEnabled;
        }

        void isEnabled(boolean isEnabled) {
            this.isEnabled = isEnabled;
            this.isEnabledBuildStage = 1;
        }

        int getNoCompactionWhenCompactedWithin() {
            if (this.noCompactionWhenCompactedWithinBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.noCompactionWhenCompactedWithinBuildStage == 0) {
                this.noCompactionWhenCompactedWithinBuildStage = (byte)-1;
                this.noCompactionWhenCompactedWithin = ImmutableGlobalLogCompactionParams.this.getNoCompactionWhenCompactedWithinInitialize();
                this.noCompactionWhenCompactedWithinBuildStage = 1;
            }
            return this.noCompactionWhenCompactedWithin;
        }

        void noCompactionWhenCompactedWithin(int noCompactionWhenCompactedWithin) {
            this.noCompactionWhenCompactedWithin = noCompactionWhenCompactedWithin;
            this.noCompactionWhenCompactedWithinBuildStage = 1;
        }

        int getNoCompactionUpToLength() {
            if (this.noCompactionUpToLengthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.noCompactionUpToLengthBuildStage == 0) {
                this.noCompactionUpToLengthBuildStage = (byte)-1;
                this.noCompactionUpToLength = ImmutableGlobalLogCompactionParams.this.getNoCompactionUpToLengthInitialize();
                this.noCompactionUpToLengthBuildStage = 1;
            }
            return this.noCompactionUpToLength;
        }

        void noCompactionUpToLength(int noCompactionUpToLength) {
            this.noCompactionUpToLength = noCompactionUpToLength;
            this.noCompactionUpToLengthBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.isEnabledBuildStage == -1) {
                attributes.add("isEnabled");
            }
            if (this.noCompactionWhenCompactedWithinBuildStage == -1) {
                attributes.add("noCompactionWhenCompactedWithin");
            }
            if (this.noCompactionUpToLengthBuildStage == -1) {
                attributes.add("noCompactionUpToLength");
            }
            return "Cannot build GlobalLogCompactionParams, attribute initializers form cycle " + attributes;
        }
    }
}

