/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Callable;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.persist.adapter.CommitAttempt;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="CommitAttempt", generator="Immutables")
@Immutable
public final class ImmutableCommitAttempt
implements CommitAttempt {
    private final BranchName commitToBranch;
    private final Optional<Hash> expectedHead;
    private final ImmutableMap<ContentId, Optional<ByteString>> expectedStates;
    private final ImmutableList<KeyWithBytes> puts;
    private final ImmutableMap<ContentId, ByteString> global;
    private final ImmutableList<Key> unchanged;
    private final ImmutableList<Key> deletes;
    private final ByteString commitMetaSerialized;
    @Nullable
    private final Callable<Void> validator;

    private ImmutableCommitAttempt(Builder builder) {
        this.commitToBranch = builder.commitToBranch;
        this.expectedStates = builder.expectedStates.build();
        this.puts = builder.puts.build();
        this.global = builder.global.build();
        this.unchanged = builder.unchanged.build();
        this.deletes = builder.deletes.build();
        this.commitMetaSerialized = builder.commitMetaSerialized;
        this.validator = builder.validator;
        this.expectedHead = builder.expectedHead != null ? builder.expectedHead : Objects.requireNonNull(CommitAttempt.super.getExpectedHead(), "expectedHead");
    }

    private ImmutableCommitAttempt(BranchName commitToBranch, Optional<Hash> expectedHead, ImmutableMap<ContentId, Optional<ByteString>> expectedStates, ImmutableList<KeyWithBytes> puts, ImmutableMap<ContentId, ByteString> global, ImmutableList<Key> unchanged, ImmutableList<Key> deletes, ByteString commitMetaSerialized, @Nullable Callable<Void> validator) {
        this.commitToBranch = commitToBranch;
        this.expectedHead = expectedHead;
        this.expectedStates = expectedStates;
        this.puts = puts;
        this.global = global;
        this.unchanged = unchanged;
        this.deletes = deletes;
        this.commitMetaSerialized = commitMetaSerialized;
        this.validator = validator;
    }

    @Override
    public BranchName getCommitToBranch() {
        return this.commitToBranch;
    }

    @Override
    public Optional<Hash> getExpectedHead() {
        return this.expectedHead;
    }

    public ImmutableMap<ContentId, Optional<ByteString>> getExpectedStates() {
        return this.expectedStates;
    }

    public ImmutableList<KeyWithBytes> getPuts() {
        return this.puts;
    }

    public ImmutableMap<ContentId, ByteString> getGlobal() {
        return this.global;
    }

    public ImmutableList<Key> getUnchanged() {
        return this.unchanged;
    }

    public ImmutableList<Key> getDeletes() {
        return this.deletes;
    }

    @Override
    public ByteString getCommitMetaSerialized() {
        return this.commitMetaSerialized;
    }

    @Override
    @Nullable
    public Callable<Void> getValidator() {
        return this.validator;
    }

    public final ImmutableCommitAttempt withCommitToBranch(BranchName value) {
        if (this.commitToBranch == value) {
            return this;
        }
        BranchName newValue = Objects.requireNonNull(value, "commitToBranch");
        return new ImmutableCommitAttempt(newValue, this.expectedHead, this.expectedStates, this.puts, this.global, this.unchanged, this.deletes, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitAttempt withExpectedHead(Optional<Hash> value) {
        Optional<Hash> newValue = Objects.requireNonNull(value, "expectedHead");
        if (this.expectedHead.equals(newValue)) {
            return this;
        }
        return new ImmutableCommitAttempt(this.commitToBranch, newValue, this.expectedStates, this.puts, this.global, this.unchanged, this.deletes, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitAttempt withExpectedStates(Map<? extends ContentId, ? extends Optional<ByteString>> entries) {
        if (this.expectedStates == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCommitAttempt(this.commitToBranch, this.expectedHead, (ImmutableMap<ContentId, Optional<ByteString>>)newValue, this.puts, this.global, this.unchanged, this.deletes, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitAttempt withPuts(KeyWithBytes ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitAttempt(this.commitToBranch, this.expectedHead, this.expectedStates, (ImmutableList<KeyWithBytes>)newValue, this.global, this.unchanged, this.deletes, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitAttempt withPuts(Iterable<? extends KeyWithBytes> elements) {
        if (this.puts == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitAttempt(this.commitToBranch, this.expectedHead, this.expectedStates, (ImmutableList<KeyWithBytes>)newValue, this.global, this.unchanged, this.deletes, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitAttempt withGlobal(Map<? extends ContentId, ? extends ByteString> entries) {
        if (this.global == entries) {
            return this;
        }
        ImmutableMap newValue = ImmutableMap.copyOf(entries);
        return new ImmutableCommitAttempt(this.commitToBranch, this.expectedHead, this.expectedStates, this.puts, (ImmutableMap<ContentId, ByteString>)newValue, this.unchanged, this.deletes, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitAttempt withUnchanged(Key ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitAttempt(this.commitToBranch, this.expectedHead, this.expectedStates, this.puts, this.global, (ImmutableList<Key>)newValue, this.deletes, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitAttempt withUnchanged(Iterable<? extends Key> elements) {
        if (this.unchanged == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitAttempt(this.commitToBranch, this.expectedHead, this.expectedStates, this.puts, this.global, (ImmutableList<Key>)newValue, this.deletes, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitAttempt withDeletes(Key ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableCommitAttempt(this.commitToBranch, this.expectedHead, this.expectedStates, this.puts, this.global, this.unchanged, (ImmutableList<Key>)newValue, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitAttempt withDeletes(Iterable<? extends Key> elements) {
        if (this.deletes == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableCommitAttempt(this.commitToBranch, this.expectedHead, this.expectedStates, this.puts, this.global, this.unchanged, (ImmutableList<Key>)newValue, this.commitMetaSerialized, this.validator);
    }

    public final ImmutableCommitAttempt withCommitMetaSerialized(ByteString value) {
        if (this.commitMetaSerialized == value) {
            return this;
        }
        ByteString newValue = Objects.requireNonNull(value, "commitMetaSerialized");
        return new ImmutableCommitAttempt(this.commitToBranch, this.expectedHead, this.expectedStates, this.puts, this.global, this.unchanged, this.deletes, newValue, this.validator);
    }

    public final ImmutableCommitAttempt withValidator(@Nullable Callable<Void> value) {
        if (this.validator == value) {
            return this;
        }
        return new ImmutableCommitAttempt(this.commitToBranch, this.expectedHead, this.expectedStates, this.puts, this.global, this.unchanged, this.deletes, this.commitMetaSerialized, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableCommitAttempt && this.equalTo(0, (ImmutableCommitAttempt)another);
    }

    private boolean equalTo(int synthetic, ImmutableCommitAttempt another) {
        return this.commitToBranch.equals(another.commitToBranch) && this.expectedHead.equals(another.expectedHead) && this.expectedStates.equals(another.expectedStates) && this.puts.equals(another.puts) && this.global.equals(another.global) && this.unchanged.equals(another.unchanged) && this.deletes.equals(another.deletes) && this.commitMetaSerialized.equals((Object)another.commitMetaSerialized) && Objects.equals(this.validator, another.validator);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.commitToBranch.hashCode();
        h += (h << 5) + this.expectedHead.hashCode();
        h += (h << 5) + this.expectedStates.hashCode();
        h += (h << 5) + this.puts.hashCode();
        h += (h << 5) + this.global.hashCode();
        h += (h << 5) + this.unchanged.hashCode();
        h += (h << 5) + this.deletes.hashCode();
        h += (h << 5) + this.commitMetaSerialized.hashCode();
        h += (h << 5) + Objects.hashCode(this.validator);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"CommitAttempt").omitNullValues().add("commitToBranch", (Object)this.commitToBranch).add("expectedHead", this.expectedHead).add("expectedStates", this.expectedStates).add("puts", this.puts).add("global", this.global).add("unchanged", this.unchanged).add("deletes", this.deletes).add("commitMetaSerialized", (Object)this.commitMetaSerialized).add("validator", this.validator).toString();
    }

    public static ImmutableCommitAttempt copyOf(CommitAttempt instance) {
        if (instance instanceof ImmutableCommitAttempt) {
            return (ImmutableCommitAttempt)instance;
        }
        return ImmutableCommitAttempt.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="CommitAttempt", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_COMMIT_TO_BRANCH = 1L;
        private static final long INIT_BIT_COMMIT_META_SERIALIZED = 2L;
        private long initBits = 3L;
        @Nullable
        private BranchName commitToBranch;
        @Nullable
        private Optional<Hash> expectedHead;
        private ImmutableMap.Builder<ContentId, Optional<ByteString>> expectedStates = ImmutableMap.builder();
        private ImmutableList.Builder<KeyWithBytes> puts = ImmutableList.builder();
        private ImmutableMap.Builder<ContentId, ByteString> global = ImmutableMap.builder();
        private ImmutableList.Builder<Key> unchanged = ImmutableList.builder();
        private ImmutableList.Builder<Key> deletes = ImmutableList.builder();
        @Nullable
        private ByteString commitMetaSerialized;
        @Nullable
        private Callable<Void> validator;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(CommitAttempt instance) {
            Objects.requireNonNull(instance, "instance");
            this.commitToBranch(instance.getCommitToBranch());
            this.expectedHead(instance.getExpectedHead());
            this.putAllExpectedStates(instance.getExpectedStates());
            this.addAllPuts(instance.getPuts());
            this.putAllGlobal(instance.getGlobal());
            this.addAllUnchanged(instance.getUnchanged());
            this.addAllDeletes(instance.getDeletes());
            this.commitMetaSerialized(instance.getCommitMetaSerialized());
            Callable<Void> validatorValue = instance.getValidator();
            if (validatorValue != null) {
                this.validator(validatorValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitToBranch(BranchName commitToBranch) {
            this.commitToBranch = Objects.requireNonNull(commitToBranch, "commitToBranch");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expectedHead(Optional<Hash> expectedHead) {
            this.expectedHead = Objects.requireNonNull(expectedHead, "expectedHead");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExpectedStates(ContentId key, Optional<ByteString> value) {
            this.expectedStates.put((Object)key, value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putExpectedStates(Map.Entry<? extends ContentId, ? extends Optional<ByteString>> entry) {
            this.expectedStates.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expectedStates(Map<? extends ContentId, ? extends Optional<ByteString>> entries) {
            this.expectedStates = ImmutableMap.builder();
            return this.putAllExpectedStates(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllExpectedStates(Map<? extends ContentId, ? extends Optional<ByteString>> entries) {
            this.expectedStates.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPuts(KeyWithBytes element) {
            this.puts.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addPuts(KeyWithBytes ... elements) {
            this.puts.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder puts(Iterable<? extends KeyWithBytes> elements) {
            this.puts = ImmutableList.builder();
            return this.addAllPuts(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllPuts(Iterable<? extends KeyWithBytes> elements) {
            this.puts.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putGlobal(ContentId key, ByteString value) {
            this.global.put((Object)key, (Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder putGlobal(Map.Entry<? extends ContentId, ? extends ByteString> entry) {
            this.global.put(entry);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder global(Map<? extends ContentId, ? extends ByteString> entries) {
            this.global = ImmutableMap.builder();
            return this.putAllGlobal(entries);
        }

        @CanIgnoreReturnValue
        public final Builder putAllGlobal(Map<? extends ContentId, ? extends ByteString> entries) {
            this.global.putAll(entries);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addUnchanged(Key element) {
            this.unchanged.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addUnchanged(Key ... elements) {
            this.unchanged.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder unchanged(Iterable<? extends Key> elements) {
            this.unchanged = ImmutableList.builder();
            return this.addAllUnchanged(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllUnchanged(Iterable<? extends Key> elements) {
            this.unchanged.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDeletes(Key element) {
            this.deletes.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addDeletes(Key ... elements) {
            this.deletes.add((Object[])elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deletes(Iterable<? extends Key> elements) {
            this.deletes = ImmutableList.builder();
            return this.addAllDeletes(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllDeletes(Iterable<? extends Key> elements) {
            this.deletes.addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder commitMetaSerialized(ByteString commitMetaSerialized) {
            this.commitMetaSerialized = Objects.requireNonNull(commitMetaSerialized, "commitMetaSerialized");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validator(@Nullable Callable<Void> validator) {
            this.validator = validator;
            return this;
        }

        public ImmutableCommitAttempt build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableCommitAttempt(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("commitToBranch");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("commitMetaSerialized");
            }
            return "Cannot build CommitAttempt, some of required attributes are not set " + attributes;
        }
    }
}

