package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link RepoDescription}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableRepoDescription.builder()}.
 */
@Generated(from = "RepoDescription", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableRepoDescription
    implements RepoDescription {
  private final int repoVersion;
  private final ImmutableMap<String, String> properties;

  private ImmutableRepoDescription(
      int repoVersion,
      ImmutableMap<String, String> properties) {
    this.repoVersion = repoVersion;
    this.properties = properties;
  }

  /**
   *A logical version number describing the logical data model. 
   */
  @Override
  public int getRepoVersion() {
    return repoVersion;
  }

  /**
   *Map of properties for a Nessie repository. 
   */
  @Override
  public ImmutableMap<String, String> getProperties() {
    return properties;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link RepoDescription#getRepoVersion() repoVersion} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for repoVersion
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableRepoDescription withRepoVersion(int value) {
    if (this.repoVersion == value) return this;
    return new ImmutableRepoDescription(value, this.properties);
  }

  /**
   * Copy the current immutable object by replacing the {@link RepoDescription#getProperties() properties} map with the specified map.
   * Nulls are not permitted as keys or values.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param entries The entries to be added to the properties map
   * @return A modified copy of {@code this} object
   */
  public final ImmutableRepoDescription withProperties(Map<String, ? extends String> entries) {
    if (this.properties == entries) return this;
    ImmutableMap<String, String> newValue = ImmutableMap.copyOf(entries);
    return new ImmutableRepoDescription(this.repoVersion, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableRepoDescription} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableRepoDescription
        && equalTo(0, (ImmutableRepoDescription) another);
  }

  private boolean equalTo(int synthetic, ImmutableRepoDescription another) {
    return repoVersion == another.repoVersion
        && properties.equals(another.properties);
  }

  /**
   * Computes a hash code from attributes: {@code repoVersion}, {@code properties}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + repoVersion;
    h += (h << 5) + properties.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code RepoDescription} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("RepoDescription")
        .omitNullValues()
        .add("repoVersion", repoVersion)
        .add("properties", properties)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link RepoDescription} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable RepoDescription instance
   */
  public static ImmutableRepoDescription copyOf(RepoDescription instance) {
    if (instance instanceof ImmutableRepoDescription) {
      return (ImmutableRepoDescription) instance;
    }
    return ImmutableRepoDescription.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableRepoDescription ImmutableRepoDescription}.
   * <pre>
   * ImmutableRepoDescription.builder()
   *    .repoVersion(int) // required {@link RepoDescription#getRepoVersion() repoVersion}
   *    .putProperties|putAllProperties(String =&gt; String) // {@link RepoDescription#getProperties() properties} mappings
   *    .build();
   * </pre>
   * @return A new ImmutableRepoDescription builder
   */
  public static ImmutableRepoDescription.Builder builder() {
    return new ImmutableRepoDescription.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableRepoDescription ImmutableRepoDescription}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "RepoDescription", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_REPO_VERSION = 0x1L;
    private long initBits = 0x1L;

    private int repoVersion;
    private ImmutableMap.Builder<String, String> properties = ImmutableMap.builder();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code RepoDescription} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(RepoDescription instance) {
      Objects.requireNonNull(instance, "instance");
      repoVersion(instance.getRepoVersion());
      putAllProperties(instance.getProperties());
      return this;
    }

    /**
     * Initializes the value for the {@link RepoDescription#getRepoVersion() repoVersion} attribute.
     * @param repoVersion The value for repoVersion 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder repoVersion(int repoVersion) {
      this.repoVersion = repoVersion;
      initBits &= ~INIT_BIT_REPO_VERSION;
      return this;
    }

    /**
     * Put one entry to the {@link RepoDescription#getProperties() properties} map.
     * @param key The key in the properties map
     * @param value The associated value in the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putProperties(String key, String value) {
      this.properties.put(key, value);
      return this;
    }

    /**
     * Put one entry to the {@link RepoDescription#getProperties() properties} map. Nulls are not permitted
     * @param entry The key and value entry
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putProperties(Map.Entry<String, ? extends String> entry) {
      this.properties.put(entry);
      return this;
    }

    /**
     * Sets or replaces all mappings from the specified map as entries for the {@link RepoDescription#getProperties() properties} map. Nulls are not permitted
     * @param entries The entries that will be added to the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder properties(Map<String, ? extends String> entries) {
      this.properties = ImmutableMap.builder();
      return putAllProperties(entries);
    }

    /**
     * Put all mappings from the specified map as entries to {@link RepoDescription#getProperties() properties} map. Nulls are not permitted
     * @param entries The entries that will be added to the properties map
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder putAllProperties(Map<String, ? extends String> entries) {
      this.properties.putAll(entries);
      return this;
    }

    /**
     * Builds a new {@link ImmutableRepoDescription ImmutableRepoDescription}.
     * @return An immutable instance of RepoDescription
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableRepoDescription build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableRepoDescription(repoVersion, properties.build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_REPO_VERSION) != 0) attributes.add("repoVersion");
      return "Cannot build RepoDescription, some of required attributes are not set " + attributes;
    }
  }
}
