/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.protobuf.ByteString;
import java.util.List;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.persist.adapter.ImmutableCommitLogEntry;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyWithBytes;

@Value.Immutable
public interface CommitLogEntry {
    public long getCreatedTime();

    public Hash getHash();

    public long getCommitSeq();

    public List<Hash> getParents();

    public ByteString getMetadata();

    public List<KeyWithBytes> getPuts();

    public List<Key> getDeletes();

    @Nullable
    public KeyList getKeyList();

    public List<Hash> getKeyListsIds();

    public int getKeyListDistance();

    public static CommitLogEntry of(long createdTime, Hash hash, long commitSeq, List<Hash> parents, ByteString metadata, List<KeyWithBytes> puts, List<Key> deletes, int keyListDistance, KeyList keyList, List<Hash> keyListIds) {
        return ImmutableCommitLogEntry.builder().createdTime(createdTime).hash(hash).commitSeq(commitSeq).parents(parents).metadata(metadata).puts(puts).deletes(deletes).keyListDistance(keyListDistance).keyList(keyList).addAllKeyListsIds(keyListIds).build();
    }
}

