/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter.spi;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ReferenceRetryFailureException;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;

public final class TryLoopState
implements AutoCloseable {
    private final MonotonicClock monotonicClock;
    private final long t0;
    private final long maxTime;
    private final int maxRetries;
    private final Function<TryLoopState, String> retryErrorMessage;
    private final BiConsumer<Boolean, TryLoopState> completionNotifier;
    private final long maxSleep;
    private long lowerBound;
    private long upperBound;
    private int retries;

    TryLoopState(Function<TryLoopState, String> retryErrorMessage, DatabaseAdapterConfig config, MonotonicClock monotonicClock, BiConsumer<Boolean, TryLoopState> completionNotifier) {
        this.retryErrorMessage = retryErrorMessage;
        this.maxTime = TimeUnit.MILLISECONDS.toNanos(config.getCommitTimeout());
        this.maxRetries = config.getCommitRetries();
        this.monotonicClock = monotonicClock;
        this.t0 = monotonicClock.currentNanos();
        this.lowerBound = config.getRetryInitialSleepMillisLower();
        this.upperBound = config.getRetryInitialSleepMillisUpper();
        this.maxSleep = config.getRetryMaxSleepMillis();
        this.completionNotifier = completionNotifier;
    }

    public static TryLoopState newTryLoopState(Function<TryLoopState, String> retryErrorMessage, BiConsumer<Boolean, TryLoopState> completionNotifier, DatabaseAdapterConfig config) {
        return new TryLoopState(retryErrorMessage, config, DefaultMonotonicClock.INSTANCE, completionNotifier);
    }

    public int getRetries() {
        return this.retries;
    }

    public long getDuration(TimeUnit timeUnit) {
        return timeUnit.convert(this.monotonicClock.currentNanos() - this.t0, TimeUnit.NANOSECONDS);
    }

    public Hash success(Hash result) {
        this.completionNotifier.accept(true, this);
        return result;
    }

    private ReferenceRetryFailureException unsuccessful() {
        this.completionNotifier.accept(false, this);
        return new ReferenceRetryFailureException(this.retryErrorMessage.apply(this), this.getRetries(), this.getDuration(TimeUnit.MILLISECONDS));
    }

    public void retry() throws ReferenceRetryFailureException {
        ++this.retries;
        long current = this.monotonicClock.currentNanos();
        long elapsed = current - this.t0;
        if (this.maxTime < elapsed || this.maxRetries < this.retries) {
            throw this.unsuccessful();
        }
        long sleepMillis = ThreadLocalRandom.current().nextLong(this.lowerBound, this.upperBound);
        sleepMillis = Math.min(TimeUnit.NANOSECONDS.toMillis(this.maxTime - elapsed), sleepMillis);
        this.monotonicClock.sleepMillis(sleepMillis);
        long upper = this.upperBound * 2L;
        if (upper <= this.maxSleep) {
            this.lowerBound *= 2L;
            this.upperBound = upper;
        }
    }

    @Override
    public void close() {
    }

    static class DefaultMonotonicClock
    implements MonotonicClock {
        static final MonotonicClock INSTANCE = new DefaultMonotonicClock();

        private DefaultMonotonicClock() {
        }

        @Override
        public long currentNanos() {
            return System.nanoTime();
        }

        @Override
        public void sleepMillis(long sleepMillis) {
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static interface MonotonicClock {
        public long currentNanos();

        public void sleepMillis(long var1);
    }
}

