/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.persist.adapter.KeyList;
import org.projectnessie.versioned.persist.adapter.KeyListEntity;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="KeyListEntity", generator="Immutables")
@Immutable
public final class ImmutableKeyListEntity
implements KeyListEntity {
    private final Hash id;
    private final KeyList keys;

    private ImmutableKeyListEntity(Hash id, KeyList keys) {
        this.id = id;
        this.keys = keys;
    }

    @Override
    public Hash getId() {
        return this.id;
    }

    @Override
    public KeyList getKeys() {
        return this.keys;
    }

    public final ImmutableKeyListEntity withId(Hash value) {
        if (this.id == value) {
            return this;
        }
        Hash newValue = Objects.requireNonNull(value, "id");
        return new ImmutableKeyListEntity(newValue, this.keys);
    }

    public final ImmutableKeyListEntity withKeys(KeyList value) {
        if (this.keys == value) {
            return this;
        }
        KeyList newValue = Objects.requireNonNull(value, "keys");
        return new ImmutableKeyListEntity(this.id, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyListEntity && this.equalTo(0, (ImmutableKeyListEntity)another);
    }

    private boolean equalTo(int synthetic, ImmutableKeyListEntity another) {
        return this.id.equals((Object)another.id) && this.keys.equals(another.keys);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.id.hashCode();
        h += (h << 5) + this.keys.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"KeyListEntity").omitNullValues().add("id", (Object)this.id).add("keys", (Object)this.keys).toString();
    }

    public static ImmutableKeyListEntity copyOf(KeyListEntity instance) {
        if (instance instanceof ImmutableKeyListEntity) {
            return (ImmutableKeyListEntity)instance;
        }
        return ImmutableKeyListEntity.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="KeyListEntity", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ID = 1L;
        private static final long INIT_BIT_KEYS = 2L;
        private long initBits = 3L;
        @Nullable
        private Hash id;
        @Nullable
        private KeyList keys;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(KeyListEntity instance) {
            Objects.requireNonNull(instance, "instance");
            this.id(instance.getId());
            this.keys(instance.getKeys());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder id(Hash id) {
            this.id = Objects.requireNonNull(id, "id");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder keys(KeyList keys) {
            this.keys = Objects.requireNonNull(keys, "keys");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableKeyListEntity build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeyListEntity(this.id, this.keys);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("id");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("keys");
            }
            return "Cannot build KeyListEntity, some of required attributes are not set " + attributes;
        }
    }
}

