/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.ContentIdWithType;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ContentIdWithType", generator="Immutables")
@Immutable
public final class ImmutableContentIdWithType
implements ContentIdWithType {
    private final ContentId contentId;
    private final byte type;

    private ImmutableContentIdWithType(ContentId contentId, byte type) {
        this.contentId = contentId;
        this.type = type;
    }

    @Override
    public ContentId getContentId() {
        return this.contentId;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public final ImmutableContentIdWithType withContentId(ContentId value) {
        if (this.contentId == value) {
            return this;
        }
        ContentId newValue = Objects.requireNonNull(value, "contentId");
        return new ImmutableContentIdWithType(newValue, this.type);
    }

    public final ImmutableContentIdWithType withType(byte value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableContentIdWithType(this.contentId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContentIdWithType && this.equalTo(0, (ImmutableContentIdWithType)another);
    }

    private boolean equalTo(int synthetic, ImmutableContentIdWithType another) {
        return this.contentId.equals(another.contentId) && this.type == another.type;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.contentId.hashCode();
        h += (h << 5) + Bytes.hashCode((byte)this.type);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ContentIdWithType").omitNullValues().add("contentId", (Object)this.contentId).add("type", (int)this.type).toString();
    }

    public static ImmutableContentIdWithType copyOf(ContentIdWithType instance) {
        if (instance instanceof ImmutableContentIdWithType) {
            return (ImmutableContentIdWithType)instance;
        }
        return ImmutableContentIdWithType.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ContentIdWithType", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CONTENT_ID = 1L;
        private static final long INIT_BIT_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private ContentId contentId;
        private byte type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ContentIdWithType instance) {
            Objects.requireNonNull(instance, "instance");
            this.contentId(instance.getContentId());
            this.type(instance.getType());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentId(ContentId contentId) {
            this.contentId = Objects.requireNonNull(contentId, "contentId");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(byte type) {
            this.type = type;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public ImmutableContentIdWithType build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContentIdWithType(this.contentId, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("contentId");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build ContentIdWithType, some of required attributes are not set " + attributes;
        }
    }
}

