/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.persist.adapter.ContentAndState;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ContentAndState", generator="Immutables")
@Immutable
public final class ImmutableContentAndState<CONTENT>
implements ContentAndState<CONTENT> {
    private final CONTENT refState;
    @Nullable
    private final CONTENT globalState;

    private ImmutableContentAndState(CONTENT refState, @Nullable CONTENT globalState) {
        this.refState = refState;
        this.globalState = globalState;
    }

    @Override
    public CONTENT getRefState() {
        return this.refState;
    }

    @Override
    @Nullable
    public CONTENT getGlobalState() {
        return this.globalState;
    }

    public final ImmutableContentAndState<CONTENT> withRefState(CONTENT value) {
        if (this.refState == value) {
            return this;
        }
        CONTENT newValue = Objects.requireNonNull(value, "refState");
        return new ImmutableContentAndState<CONTENT>(newValue, this.globalState);
    }

    public final ImmutableContentAndState<CONTENT> withGlobalState(@Nullable CONTENT value) {
        if (this.globalState == value) {
            return this;
        }
        return new ImmutableContentAndState<CONTENT>(this.refState, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableContentAndState && this.equalTo(0, (ImmutableContentAndState)another);
    }

    private boolean equalTo(int synthetic, ImmutableContentAndState<?> another) {
        return this.refState.equals(another.refState) && Objects.equals(this.globalState, another.globalState);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.refState.hashCode();
        h += (h << 5) + Objects.hashCode(this.globalState);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ContentAndState").omitNullValues().add("refState", this.refState).add("globalState", this.globalState).toString();
    }

    public static <CONTENT> ImmutableContentAndState<CONTENT> copyOf(ContentAndState<CONTENT> instance) {
        if (instance instanceof ImmutableContentAndState) {
            return (ImmutableContentAndState)instance;
        }
        return ImmutableContentAndState.builder().from(instance).build();
    }

    public static <CONTENT> Builder<CONTENT> builder() {
        return new Builder();
    }

    @Generated(from="ContentAndState", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<CONTENT> {
        private static final long INIT_BIT_REF_STATE = 1L;
        private long initBits = 1L;
        @Nullable
        private CONTENT refState;
        @Nullable
        private CONTENT globalState;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<CONTENT> from(ContentAndState<CONTENT> instance) {
            Objects.requireNonNull(instance, "instance");
            this.refState(instance.getRefState());
            CONTENT globalStateValue = instance.getGlobalState();
            if (globalStateValue != null) {
                this.globalState(globalStateValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<CONTENT> refState(CONTENT refState) {
            this.refState = Objects.requireNonNull(refState, "refState");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<CONTENT> globalState(@Nullable CONTENT globalState) {
            this.globalState = globalState;
            return this;
        }

        public ImmutableContentAndState<CONTENT> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableContentAndState(this.refState, this.globalState);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("refState");
            }
            return "Cannot build ContentAndState, some of required attributes are not set " + attributes;
        }
    }
}

