/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.function.Function;
import java.util.function.Predicate;
import org.projectnessie.versioned.persist.adapter.ContentVariantSupplier;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapter;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;
import org.projectnessie.versioned.persist.adapter.DatabaseConnectionProvider;

public interface DatabaseAdapterFactory<Config extends DatabaseAdapterConfig, AdjustableConfig extends Config, Connector extends DatabaseConnectionProvider<?>> {
    public Builder<Config, AdjustableConfig, Connector> newBuilder();

    public String getName();

    public static <Config extends DatabaseAdapterConfig, AdjustableConfig extends Config, Connector extends DatabaseConnectionProvider<?>> DatabaseAdapterFactory<Config, AdjustableConfig, Connector> loadFactoryByName(String name) {
        try {
            return DatabaseAdapterFactory.loadFactory(f -> f.getName().equalsIgnoreCase(name));
        }
        catch (Exception e) {
            throw new RuntimeException(String.format("For database adapter factory '%s': %s", name, e), e);
        }
    }

    public static <Config extends DatabaseAdapterConfig, AdjustableConfig extends Config, Connector extends DatabaseConnectionProvider<?>> DatabaseAdapterFactory<Config, AdjustableConfig, Connector> loadFactory(Predicate<DatabaseAdapterFactory<?, ?, ?>> check) {
        Iterator<DatabaseAdapterFactory> iter = ServiceLoader.load(DatabaseAdapterFactory.class).iterator();
        if (!iter.hasNext()) {
            throw new IllegalStateException("No DatabaseAdapterFactory implementation available.");
        }
        while (iter.hasNext()) {
            DatabaseAdapterFactory candidate = iter.next();
            if (!check.test(candidate)) continue;
            return candidate;
        }
        throw new IllegalArgumentException("No DatabaseAdapterFactory passed the given predicate.");
    }

    public static abstract class Builder<Config, AdjustableConfig, Connector> {
        private Config config;
        private Connector connector;

        public Builder<Config, AdjustableConfig, Connector> withConfig(Config config) {
            this.config = config;
            return this;
        }

        public Builder<Config, AdjustableConfig, Connector> withConnector(Connector connector) {
            this.connector = connector;
            return this;
        }

        protected abstract Config getDefaultConfig();

        protected abstract AdjustableConfig adjustableConfig(Config var1);

        public Config getConfig() {
            if (this.config == null) {
                this.config = this.getDefaultConfig();
            }
            return this.config;
        }

        public Connector getConnector() {
            return this.connector;
        }

        public abstract DatabaseAdapter build(ContentVariantSupplier var1);

        public Builder<Config, AdjustableConfig, Connector> configure(Function<AdjustableConfig, Config> configurator) {
            this.config = configurator.apply(this.adjustableConfig(this.getConfig()));
            return this;
        }
    }
}

