/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.protobuf.ByteString;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import org.projectnessie.versioned.BranchName;
import org.projectnessie.versioned.GetNamedRefsParams;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.NamedRef;
import org.projectnessie.versioned.RefLogNotFoundException;
import org.projectnessie.versioned.ReferenceAlreadyExistsException;
import org.projectnessie.versioned.ReferenceConflictException;
import org.projectnessie.versioned.ReferenceInfo;
import org.projectnessie.versioned.ReferenceNotFoundException;
import org.projectnessie.versioned.persist.adapter.CommitAttempt;
import org.projectnessie.versioned.persist.adapter.CommitLogEntry;
import org.projectnessie.versioned.persist.adapter.ContentAndState;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.ContentIdAndBytes;
import org.projectnessie.versioned.persist.adapter.ContentIdWithType;
import org.projectnessie.versioned.persist.adapter.Difference;
import org.projectnessie.versioned.persist.adapter.KeyFilterPredicate;
import org.projectnessie.versioned.persist.adapter.KeyWithType;
import org.projectnessie.versioned.persist.adapter.RefLog;

public interface DatabaseAdapter {
    public void initializeRepo(String var1);

    public void eraseRepo();

    public Hash noAncestorHash();

    public Hash hashOnReference(NamedRef var1, Optional<Hash> var2) throws ReferenceNotFoundException;

    public Map<Key, ContentAndState<ByteString>> values(Hash var1, Collection<Key> var2, KeyFilterPredicate var3) throws ReferenceNotFoundException;

    public Stream<CommitLogEntry> commitLog(Hash var1) throws ReferenceNotFoundException;

    public Stream<KeyWithType> keys(Hash var1, KeyFilterPredicate var2) throws ReferenceNotFoundException;

    public Hash commit(CommitAttempt var1) throws ReferenceConflictException, ReferenceNotFoundException;

    public Hash transplant(BranchName var1, Optional<Hash> var2, List<Hash> var3, Function<ByteString, ByteString> var4) throws ReferenceNotFoundException, ReferenceConflictException;

    public Hash merge(Hash var1, BranchName var2, Optional<Hash> var3, Function<ByteString, ByteString> var4) throws ReferenceNotFoundException, ReferenceConflictException;

    public ReferenceInfo<ByteString> namedRef(String var1, GetNamedRefsParams var2) throws ReferenceNotFoundException;

    public Stream<ReferenceInfo<ByteString>> namedRefs(GetNamedRefsParams var1) throws ReferenceNotFoundException;

    public Hash create(NamedRef var1, Hash var2) throws ReferenceAlreadyExistsException, ReferenceNotFoundException;

    public void delete(NamedRef var1, Optional<Hash> var2) throws ReferenceNotFoundException, ReferenceConflictException;

    public void assign(NamedRef var1, Optional<Hash> var2, Hash var3) throws ReferenceNotFoundException, ReferenceConflictException;

    public Stream<Difference> diff(Hash var1, Hash var2, KeyFilterPredicate var3) throws ReferenceNotFoundException;

    public Stream<ContentIdWithType> globalKeys(ToIntFunction<ByteString> var1);

    public Stream<ContentIdAndBytes> globalContent(Set<ContentId> var1, ToIntFunction<ByteString> var2);

    public Optional<ContentIdAndBytes> globalContent(ContentId var1, ToIntFunction<ByteString> var2);

    public Stream<RefLog> refLog(Hash var1) throws RefLogNotFoundException;
}

