/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter.spi;

import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.projectnessie.versioned.Hash;
import org.projectnessie.versioned.ReferenceRetryFailureException;
import org.projectnessie.versioned.persist.adapter.DatabaseAdapterConfig;

public final class TryLoopState
implements AutoCloseable {
    static final int INITIAL_LOWER_BOUND = 5;
    static final int INITIAL_UPPER_BOUND = 25;
    private final MonotonicClock monotonicClock;
    private final long t0;
    private final long maxTime;
    private final int maxRetries;
    private int retries;
    private final Supplier<String> retryErrorMessage;
    private long lowerBound = 5L;
    private long upperBound = 25L;

    TryLoopState(Supplier<String> retryErrorMessage, DatabaseAdapterConfig config, MonotonicClock monotonicClock) {
        this.retryErrorMessage = retryErrorMessage;
        this.maxTime = TimeUnit.MILLISECONDS.toNanos(config.getCommitTimeout());
        this.maxRetries = config.getCommitRetries();
        this.monotonicClock = monotonicClock;
        this.t0 = monotonicClock.currentNanos();
    }

    public static TryLoopState newTryLoopState(Supplier<String> retryErrorMessage, DatabaseAdapterConfig config) {
        return new TryLoopState(retryErrorMessage, config, DefaultMonotonicClock.INSTANCE);
    }

    public Hash success(Hash result) {
        return result;
    }

    public void retry() throws ReferenceRetryFailureException {
        ++this.retries;
        long current = this.monotonicClock.currentNanos();
        long elapsed = current - this.t0;
        if (this.maxTime < elapsed || this.maxRetries < this.retries) {
            throw new ReferenceRetryFailureException(this.retryErrorMessage.get());
        }
        long sleepMillis = ThreadLocalRandom.current().nextLong(this.lowerBound, this.upperBound);
        sleepMillis = Math.min(TimeUnit.NANOSECONDS.toMillis(this.maxTime - elapsed), sleepMillis);
        this.monotonicClock.sleepMillis(sleepMillis);
        this.lowerBound *= 2L;
        this.upperBound *= 2L;
    }

    @Override
    public void close() {
    }

    static class DefaultMonotonicClock
    implements MonotonicClock {
        static final MonotonicClock INSTANCE = new DefaultMonotonicClock();

        private DefaultMonotonicClock() {
        }

        @Override
        public long currentNanos() {
            return System.nanoTime();
        }

        @Override
        public void sleepMillis(long sleepMillis) {
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    static interface MonotonicClock {
        public long currentNanos();

        public void sleepMillis(long var1);
    }
}

