package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Key;

/**
 * Immutable implementation of {@link KeyWithBytes}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableKeyWithBytes.builder()}.
 */
@Generated(from = "KeyWithBytes", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableKeyWithBytes implements KeyWithBytes {
  private final Key key;
  private final ContentId contentId;
  private final byte type;
  private final ByteString value;

  private ImmutableKeyWithBytes(
      Key key,
      ContentId contentId,
      byte type,
      ByteString value) {
    this.key = key;
    this.contentId = contentId;
    this.type = type;
    this.value = value;
  }

  /**
   * @return The value of the {@code key} attribute
   */
  @Override
  public Key getKey() {
    return key;
  }

  /**
   * @return The value of the {@code contentId} attribute
   */
  @Override
  public ContentId getContentId() {
    return contentId;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public byte getType() {
    return type;
  }

  /**
   * @return The value of the {@code value} attribute
   */
  @Override
  public ByteString getValue() {
    return value;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link KeyWithBytes#getKey() key} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for key
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableKeyWithBytes withKey(Key value) {
    if (this.key == value) return this;
    Key newValue = Objects.requireNonNull(value, "key");
    return new ImmutableKeyWithBytes(newValue, this.contentId, this.type, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link KeyWithBytes#getContentId() contentId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for contentId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableKeyWithBytes withContentId(ContentId value) {
    if (this.contentId == value) return this;
    ContentId newValue = Objects.requireNonNull(value, "contentId");
    return new ImmutableKeyWithBytes(this.key, newValue, this.type, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link KeyWithBytes#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableKeyWithBytes withType(byte value) {
    if (this.type == value) return this;
    return new ImmutableKeyWithBytes(this.key, this.contentId, value, this.value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link KeyWithBytes#getValue() value} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for value
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableKeyWithBytes withValue(ByteString value) {
    if (this.value == value) return this;
    ByteString newValue = Objects.requireNonNull(value, "value");
    return new ImmutableKeyWithBytes(this.key, this.contentId, this.type, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableKeyWithBytes} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableKeyWithBytes
        && equalTo((ImmutableKeyWithBytes) another);
  }

  private boolean equalTo(ImmutableKeyWithBytes another) {
    return key.equals(another.key)
        && contentId.equals(another.contentId)
        && type == another.type
        && value.equals(another.value);
  }

  /**
   * Computes a hash code from attributes: {@code key}, {@code contentId}, {@code type}, {@code value}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + key.hashCode();
    h += (h << 5) + contentId.hashCode();
    h += (h << 5) + Bytes.hashCode(type);
    h += (h << 5) + value.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code KeyWithBytes} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("KeyWithBytes")
        .omitNullValues()
        .add("key", key)
        .add("contentId", contentId)
        .add("type", type)
        .add("value", value)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link KeyWithBytes} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable KeyWithBytes instance
   */
  public static ImmutableKeyWithBytes copyOf(KeyWithBytes instance) {
    if (instance instanceof ImmutableKeyWithBytes) {
      return (ImmutableKeyWithBytes) instance;
    }
    return ImmutableKeyWithBytes.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableKeyWithBytes ImmutableKeyWithBytes}.
   * <pre>
   * ImmutableKeyWithBytes.builder()
   *    .key(org.projectnessie.versioned.Key) // required {@link KeyWithBytes#getKey() key}
   *    .contentId(org.projectnessie.versioned.persist.adapter.ContentId) // required {@link KeyWithBytes#getContentId() contentId}
   *    .type(byte) // required {@link KeyWithBytes#getType() type}
   *    .value(com.google.protobuf.ByteString) // required {@link KeyWithBytes#getValue() value}
   *    .build();
   * </pre>
   * @return A new ImmutableKeyWithBytes builder
   */
  public static ImmutableKeyWithBytes.Builder builder() {
    return new ImmutableKeyWithBytes.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableKeyWithBytes ImmutableKeyWithBytes}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "KeyWithBytes", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_KEY = 0x1L;
    private static final long INIT_BIT_CONTENT_ID = 0x2L;
    private static final long INIT_BIT_TYPE = 0x4L;
    private static final long INIT_BIT_VALUE = 0x8L;
    private long initBits = 0xfL;

    private @Nullable Key key;
    private @Nullable ContentId contentId;
    private byte type;
    private @Nullable ByteString value;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code KeyWithBytes} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(KeyWithBytes instance) {
      Objects.requireNonNull(instance, "instance");
      key(instance.getKey());
      contentId(instance.getContentId());
      type(instance.getType());
      value(instance.getValue());
      return this;
    }

    /**
     * Initializes the value for the {@link KeyWithBytes#getKey() key} attribute.
     * @param key The value for key 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder key(Key key) {
      this.key = Objects.requireNonNull(key, "key");
      initBits &= ~INIT_BIT_KEY;
      return this;
    }

    /**
     * Initializes the value for the {@link KeyWithBytes#getContentId() contentId} attribute.
     * @param contentId The value for contentId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder contentId(ContentId contentId) {
      this.contentId = Objects.requireNonNull(contentId, "contentId");
      initBits &= ~INIT_BIT_CONTENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link KeyWithBytes#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(byte type) {
      this.type = type;
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Initializes the value for the {@link KeyWithBytes#getValue() value} attribute.
     * @param value The value for value 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder value(ByteString value) {
      this.value = Objects.requireNonNull(value, "value");
      initBits &= ~INIT_BIT_VALUE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableKeyWithBytes ImmutableKeyWithBytes}.
     * @return An immutable instance of KeyWithBytes
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableKeyWithBytes build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableKeyWithBytes(key, contentId, type, value);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_KEY) != 0) attributes.add("key");
      if ((initBits & INIT_BIT_CONTENT_ID) != 0) attributes.add("contentId");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      if ((initBits & INIT_BIT_VALUE) != 0) attributes.add("value");
      return "Cannot build KeyWithBytes, some of required attributes are not set " + attributes;
    }
  }
}
