/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Key;
import org.projectnessie.versioned.persist.adapter.ContentId;
import org.projectnessie.versioned.persist.adapter.KeyWithType;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="KeyWithType", generator="Immutables")
@Immutable
public final class ImmutableKeyWithType
implements KeyWithType {
    private final Key key;
    private final ContentId contentId;
    private final byte type;
    private transient int hashCode;

    private ImmutableKeyWithType(Key key, ContentId contentId, byte type) {
        this.key = key;
        this.contentId = contentId;
        this.type = type;
    }

    @Override
    public Key getKey() {
        return this.key;
    }

    @Override
    public ContentId getContentId() {
        return this.contentId;
    }

    @Override
    public byte getType() {
        return this.type;
    }

    public final ImmutableKeyWithType withKey(Key value) {
        if (this.key == value) {
            return this;
        }
        Key newValue = Objects.requireNonNull(value, "key");
        return new ImmutableKeyWithType(newValue, this.contentId, this.type);
    }

    public final ImmutableKeyWithType withContentId(ContentId value) {
        if (this.contentId == value) {
            return this;
        }
        ContentId newValue = Objects.requireNonNull(value, "contentId");
        return new ImmutableKeyWithType(this.key, newValue, this.type);
    }

    public final ImmutableKeyWithType withType(byte value) {
        if (this.type == value) {
            return this;
        }
        return new ImmutableKeyWithType(this.key, this.contentId, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableKeyWithType && this.equalTo((ImmutableKeyWithType)another);
    }

    private boolean equalTo(ImmutableKeyWithType another) {
        if (this.hashCode != 0 && another.hashCode != 0 && this.hashCode != another.hashCode) {
            return false;
        }
        return this.key.equals((Object)another.key) && this.contentId.equals(another.contentId) && this.type == another.type;
    }

    public int hashCode() {
        int h = this.hashCode;
        if (h == 0) {
            this.hashCode = h = this.computeHashCode();
        }
        return h;
    }

    private int computeHashCode() {
        int h = 5381;
        h += (h << 5) + this.key.hashCode();
        h += (h << 5) + this.contentId.hashCode();
        h += (h << 5) + Bytes.hashCode((byte)this.type);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"KeyWithType").omitNullValues().add("key", (Object)this.key).add("contentId", (Object)this.contentId).add("type", (int)this.type).toString();
    }

    public static ImmutableKeyWithType copyOf(KeyWithType instance) {
        if (instance instanceof ImmutableKeyWithType) {
            return (ImmutableKeyWithType)instance;
        }
        return ImmutableKeyWithType.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="KeyWithType", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_KEY = 1L;
        private static final long INIT_BIT_CONTENT_ID = 2L;
        private static final long INIT_BIT_TYPE = 4L;
        private long initBits = 7L;
        @Nullable
        private Key key;
        @Nullable
        private ContentId contentId;
        private byte type;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(KeyWithType instance) {
            Objects.requireNonNull(instance, "instance");
            this.key(instance.getKey());
            this.contentId(instance.getContentId());
            this.type(instance.getType());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder key(Key key) {
            this.key = Objects.requireNonNull(key, "key");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder contentId(ContentId contentId) {
            this.contentId = Objects.requireNonNull(contentId, "contentId");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder type(byte type) {
            this.type = type;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableKeyWithType build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableKeyWithType(this.key, this.contentId, this.type);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("key");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("contentId");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build KeyWithType, some of required attributes are not set " + attributes;
        }
    }
}

