package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.versioned.Hash;

/**
 * Immutable implementation of {@link KeyListEntity}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableKeyListEntity.builder()}.
 */
@Generated(from = "KeyListEntity", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableKeyListEntity implements KeyListEntity {
  private final Hash id;
  private final KeyList keys;

  private ImmutableKeyListEntity(Hash id, KeyList keys) {
    this.id = id;
    this.keys = keys;
  }

  /**
   * @return The value of the {@code id} attribute
   */
  @Override
  public Hash getId() {
    return id;
  }

  /**
   * @return The value of the {@code keys} attribute
   */
  @Override
  public KeyList getKeys() {
    return keys;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link KeyListEntity#getId() id} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for id
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableKeyListEntity withId(Hash value) {
    if (this.id == value) return this;
    Hash newValue = Objects.requireNonNull(value, "id");
    return new ImmutableKeyListEntity(newValue, this.keys);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link KeyListEntity#getKeys() keys} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for keys
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableKeyListEntity withKeys(KeyList value) {
    if (this.keys == value) return this;
    KeyList newValue = Objects.requireNonNull(value, "keys");
    return new ImmutableKeyListEntity(this.id, newValue);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableKeyListEntity} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableKeyListEntity
        && equalTo((ImmutableKeyListEntity) another);
  }

  private boolean equalTo(ImmutableKeyListEntity another) {
    return id.equals(another.id)
        && keys.equals(another.keys);
  }

  /**
   * Computes a hash code from attributes: {@code id}, {@code keys}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + id.hashCode();
    h += (h << 5) + keys.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code KeyListEntity} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("KeyListEntity")
        .omitNullValues()
        .add("id", id)
        .add("keys", keys)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link KeyListEntity} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable KeyListEntity instance
   */
  public static ImmutableKeyListEntity copyOf(KeyListEntity instance) {
    if (instance instanceof ImmutableKeyListEntity) {
      return (ImmutableKeyListEntity) instance;
    }
    return ImmutableKeyListEntity.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableKeyListEntity ImmutableKeyListEntity}.
   * <pre>
   * ImmutableKeyListEntity.builder()
   *    .id(org.projectnessie.versioned.Hash) // required {@link KeyListEntity#getId() id}
   *    .keys(org.projectnessie.versioned.persist.adapter.KeyList) // required {@link KeyListEntity#getKeys() keys}
   *    .build();
   * </pre>
   * @return A new ImmutableKeyListEntity builder
   */
  public static ImmutableKeyListEntity.Builder builder() {
    return new ImmutableKeyListEntity.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableKeyListEntity ImmutableKeyListEntity}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "KeyListEntity", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_ID = 0x1L;
    private static final long INIT_BIT_KEYS = 0x2L;
    private long initBits = 0x3L;

    private @Nullable Hash id;
    private @Nullable KeyList keys;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code KeyListEntity} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(KeyListEntity instance) {
      Objects.requireNonNull(instance, "instance");
      id(instance.getId());
      keys(instance.getKeys());
      return this;
    }

    /**
     * Initializes the value for the {@link KeyListEntity#getId() id} attribute.
     * @param id The value for id 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder id(Hash id) {
      this.id = Objects.requireNonNull(id, "id");
      initBits &= ~INIT_BIT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link KeyListEntity#getKeys() keys} attribute.
     * @param keys The value for keys 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder keys(KeyList keys) {
      this.keys = Objects.requireNonNull(keys, "keys");
      initBits &= ~INIT_BIT_KEYS;
      return this;
    }

    /**
     * Builds a new {@link ImmutableKeyListEntity ImmutableKeyListEntity}.
     * @return An immutable instance of KeyListEntity
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableKeyListEntity build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableKeyListEntity(id, keys);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_ID) != 0) attributes.add("id");
      if ((initBits & INIT_BIT_KEYS) != 0) attributes.add("keys");
      return "Cannot build KeyListEntity, some of required attributes are not set " + attributes;
    }
  }
}
