package org.projectnessie.versioned.persist.adapter;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Bytes;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link ContentIdWithType}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code ImmutableContentIdWithType.builder()}.
 */
@Generated(from = "ContentIdWithType", generator = "Immutables")
@SuppressWarnings({"all"})
@ParametersAreNonnullByDefault
@javax.annotation.Generated("org.immutables.processor.ProxyProcessor")
@Immutable
@CheckReturnValue
public final class ImmutableContentIdWithType
    implements ContentIdWithType {
  private final ContentId contentId;
  private final byte type;

  private ImmutableContentIdWithType(ContentId contentId, byte type) {
    this.contentId = contentId;
    this.type = type;
  }

  /**
   * @return The value of the {@code contentId} attribute
   */
  @Override
  public ContentId getContentId() {
    return contentId;
  }

  /**
   * @return The value of the {@code type} attribute
   */
  @Override
  public byte getType() {
    return type;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContentIdWithType#getContentId() contentId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for contentId
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContentIdWithType withContentId(ContentId value) {
    if (this.contentId == value) return this;
    ContentId newValue = Objects.requireNonNull(value, "contentId");
    return new ImmutableContentIdWithType(newValue, this.type);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link ContentIdWithType#getType() type} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for type
   * @return A modified copy of the {@code this} object
   */
  public final ImmutableContentIdWithType withType(byte value) {
    if (this.type == value) return this;
    return new ImmutableContentIdWithType(this.contentId, value);
  }

  /**
   * This instance is equal to all instances of {@code ImmutableContentIdWithType} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(@Nullable Object another) {
    if (this == another) return true;
    return another instanceof ImmutableContentIdWithType
        && equalTo((ImmutableContentIdWithType) another);
  }

  private boolean equalTo(ImmutableContentIdWithType another) {
    return contentId.equals(another.contentId)
        && type == another.type;
  }

  /**
   * Computes a hash code from attributes: {@code contentId}, {@code type}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + contentId.hashCode();
    h += (h << 5) + Bytes.hashCode(type);
    return h;
  }

  /**
   * Prints the immutable value {@code ContentIdWithType} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return MoreObjects.toStringHelper("ContentIdWithType")
        .omitNullValues()
        .add("contentId", contentId)
        .add("type", type)
        .toString();
  }

  /**
   * Creates an immutable copy of a {@link ContentIdWithType} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable ContentIdWithType instance
   */
  public static ImmutableContentIdWithType copyOf(ContentIdWithType instance) {
    if (instance instanceof ImmutableContentIdWithType) {
      return (ImmutableContentIdWithType) instance;
    }
    return ImmutableContentIdWithType.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link ImmutableContentIdWithType ImmutableContentIdWithType}.
   * <pre>
   * ImmutableContentIdWithType.builder()
   *    .contentId(org.projectnessie.versioned.persist.adapter.ContentId) // required {@link ContentIdWithType#getContentId() contentId}
   *    .type(byte) // required {@link ContentIdWithType#getType() type}
   *    .build();
   * </pre>
   * @return A new ImmutableContentIdWithType builder
   */
  public static ImmutableContentIdWithType.Builder builder() {
    return new ImmutableContentIdWithType.Builder();
  }

  /**
   * Builds instances of type {@link ImmutableContentIdWithType ImmutableContentIdWithType}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "ContentIdWithType", generator = "Immutables")
  @NotThreadSafe
  public static final class Builder {
    private static final long INIT_BIT_CONTENT_ID = 0x1L;
    private static final long INIT_BIT_TYPE = 0x2L;
    private long initBits = 0x3L;

    private @Nullable ContentId contentId;
    private byte type;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code ContentIdWithType} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(ContentIdWithType instance) {
      Objects.requireNonNull(instance, "instance");
      contentId(instance.getContentId());
      type(instance.getType());
      return this;
    }

    /**
     * Initializes the value for the {@link ContentIdWithType#getContentId() contentId} attribute.
     * @param contentId The value for contentId 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder contentId(ContentId contentId) {
      this.contentId = Objects.requireNonNull(contentId, "contentId");
      initBits &= ~INIT_BIT_CONTENT_ID;
      return this;
    }

    /**
     * Initializes the value for the {@link ContentIdWithType#getType() type} attribute.
     * @param type The value for type 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder type(byte type) {
      this.type = type;
      initBits &= ~INIT_BIT_TYPE;
      return this;
    }

    /**
     * Builds a new {@link ImmutableContentIdWithType ImmutableContentIdWithType}.
     * @return An immutable instance of ContentIdWithType
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public ImmutableContentIdWithType build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new ImmutableContentIdWithType(contentId, type);
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_CONTENT_ID) != 0) attributes.add("contentId");
      if ((initBits & INIT_BIT_TYPE) != 0) attributes.add("type");
      return "Cannot build ContentIdWithType, some of required attributes are not set " + attributes;
    }
  }
}
